/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PixelmonUpdateData
extends PixelmonData {
    EnumUpdateType[] updateTypes;

    public PixelmonUpdateData() {
    }

    public PixelmonUpdateData(NBTTagCompound p, EnumUpdateType[] updateTypes) {
        super(p);
        this.updateTypes = updateTypes;
    }

    public PixelmonUpdateData(EntityPixelmon p, EnumUpdateType[] updateTypes) {
        super(p);
        this.updateTypes = updateTypes;
    }

    public PixelmonUpdateData(PokemonLink p, EnumUpdateType[] updateTypes) {
        super(p);
        this.updateTypes = updateTypes;
    }

    public PixelmonUpdateData(PokemonLink p, EnumUpdateType[] updateTypes, boolean inBattle) {
        this(p, updateTypes);
        this.inBattle = inBattle;
    }

    @Override
    public void encodeInto(ByteBuf data) {
        data.writeInt(this.pokemonID[0]);
        data.writeInt(this.pokemonID[1]);
        data.writeShort(this.updateTypes.length);
        data.writeBoolean(this.inBattle);
        for (EnumUpdateType t : this.updateTypes) {
            data.writeShort(t.ordinal());
        }
        block18: for (EnumUpdateType t : this.updateTypes) {
            switch (t) {
                case HP: {
                    data.writeShort(this.hp);
                    data.writeShort(this.health);
                    data.writeBoolean(this.isFainted);
                    continue block18;
                }
                case Stats: {
                    data.writeShort(this.lvl);
                    data.writeInt(this.nextLvlXP);
                    data.writeShort(this.xp);
                    data.writeShort(this.HP);
                    data.writeShort(this.Speed);
                    data.writeShort(this.Attack);
                    data.writeShort(this.Defence);
                    data.writeShort(this.SpecialAttack);
                    data.writeShort(this.SpecialDefence);
                    data.writeShort((int)this.form);
                    data.writeBoolean(this.isShiny);
                    data.writeShort(this.pokeball.ordinal());
                    data.writeShort(this.gender.ordinal());
                    data.writeShort(this.type1 == null ? -1 : this.type1.getIndex());
                    data.writeShort(this.type2 == null ? -1 : this.type2.getIndex());
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.ability);
                    continue block18;
                }
                case Nickname: {
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.nickname);
                    continue block18;
                }
                case Name: {
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.name);
                    continue block18;
                }
                case Friendship: {
                    data.writeShort(this.friendship);
                    continue block18;
                }
                case Moveset: {
                    data.writeShort(this.numMoves);
                    for (int i = 0; i < this.numMoves; ++i) {
                        this.moveset[i].writeData(data);
                    }
                    continue block18;
                }
                case HeldItem: {
                    ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)(this.heldItem == null ? ItemStack.field_190927_a : this.heldItem));
                    continue block18;
                }
                case Status: {
                    if (this.status == null) {
                        data.writeShort(-1);
                        continue block18;
                    }
                    data.writeShort(this.status.ordinal());
                    continue block18;
                }
                case CanLevel: {
                    data.writeBoolean(this.doesLevel);
                    continue block18;
                }
                case Egg: {
                    data.writeBoolean(this.isEgg);
                    data.writeInt(this.eggCycles);
                    data.writeInt(this.steps);
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.eggDescription);
                    continue block18;
                }
                case Target: {
                    data.writeInt(this.targetId);
                    continue block18;
                }
                case Ability: {
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.ability);
                    continue block18;
                }
                case Texture: {
                    data.writeShort((int)this.specialTexture);
                    continue block18;
                }
                case Clones: {
                    data.writeInt(this.numClones);
                    continue block18;
                }
                case Enchants: {
                    data.writeInt(this.numEnchanted);
                    continue block18;
                }
            }
        }
    }

    @Override
    public void decodeInto(ByteBuf data) {
        this.pokemonID = new int[]{data.readInt(), data.readInt()};
        int numTypes = data.readShort();
        this.inBattle = data.readBoolean();
        this.updateTypes = new EnumUpdateType[numTypes];
        for (int i = 0; i < numTypes; ++i) {
            this.updateTypes[i] = EnumUpdateType.getType(data.readShort());
        }
        block18: for (EnumUpdateType t : this.updateTypes) {
            switch (t) {
                case HP: {
                    this.hp = data.readShort();
                    this.health = data.readShort();
                    this.isFainted = data.readBoolean();
                    continue block18;
                }
                case Stats: {
                    this.lvl = data.readShort();
                    this.nextLvlXP = data.readInt();
                    this.xp = data.readShort();
                    this.HP = data.readShort();
                    this.Speed = data.readShort();
                    this.Attack = data.readShort();
                    this.Defence = data.readShort();
                    this.SpecialAttack = data.readShort();
                    this.SpecialDefence = data.readShort();
                    this.form = data.readShort();
                    this.isShiny = data.readBoolean();
                    this.pokeball = EnumPokeballs.getFromIndex(data.readShort());
                    this.gender = Gender.getGender(data.readShort());
                    short type1 = data.readShort();
                    this.type1 = type1 == -1 ? null : EnumType.parseOrNull(type1);
                    short type2 = data.readShort();
                    this.type2 = type2 == -1 ? null : EnumType.parseOrNull(type2);
                    this.ability = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block18;
                }
                case Nickname: {
                    this.nickname = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block18;
                }
                case Name: {
                    this.name = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block18;
                }
                case Friendship: {
                    this.friendship = data.readShort();
                    continue block18;
                }
                case Moveset: {
                    this.numMoves = data.readShort();
                    for (int i = 0; i < this.numMoves; ++i) {
                        this.moveset[i] = new PixelmonMovesetData();
                        this.moveset[i].readData(data);
                    }
                    continue block18;
                }
                case HeldItem: {
                    this.heldItem = ByteBufUtils.readItemStack((ByteBuf)data);
                    continue block18;
                }
                case Status: {
                    short statusIndex = data.readShort();
                    if (statusIndex <= -1) continue block18;
                    this.status = StatusType.getEffect(statusIndex);
                    continue block18;
                }
                case CanLevel: {
                    this.doesLevel = data.readBoolean();
                    continue block18;
                }
                case Egg: {
                    this.isEgg = data.readBoolean();
                    this.eggCycles = data.readInt();
                    this.steps = data.readInt();
                    this.eggDescription = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block18;
                }
                case Target: {
                    this.targetId = data.readInt();
                    continue block18;
                }
                case Ability: {
                    this.ability = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block18;
                }
                case Texture: {
                    this.specialTexture = data.readShort();
                    continue block18;
                }
                case Clones: {
                    this.numClones = data.readInt();
                    continue block18;
                }
                case Enchants: {
                    this.numEnchanted = data.readInt();
                    continue block18;
                }
            }
        }
    }
}

