/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Remove;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AcceptNPCTradePacket
implements IMessage {
    private boolean isShiny;
    private int lvl;
    private String offer;
    private String exchange;
    private int id;
    private int form;

    public AcceptNPCTradePacket() {
    }

    public AcceptNPCTradePacket(boolean isShiny, int lvl, String offer, String exchange, int id, int form) {
        this.isShiny = isShiny;
        this.lvl = lvl;
        this.offer = offer;
        this.exchange = exchange;
        this.id = id;
        this.form = form;
    }

    public void fromBytes(ByteBuf buffer) {
        if (buffer.capacity() == 0) {
            return;
        }
        this.isShiny = buffer.readBoolean();
        this.lvl = buffer.readInt();
        this.offer = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.exchange = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.id = buffer.readInt();
        this.form = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.isShiny);
        buffer.writeInt(this.lvl);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.offer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.exchange);
        buffer.writeInt(this.id);
        buffer.writeInt(this.form);
    }

    public static class Handler
    implements IMessageHandler<AcceptNPCTradePacket, IMessage> {
        public IMessage onMessage(AcceptNPCTradePacket message, MessageContext ctx) {
            EntityPlayerMP playerMP = ctx.getServerHandler().field_147369_b;
            boolean checked = false;
            EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName(message.offer, playerMP.field_70170_p);
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(playerMP);
            if (optstorage.isPresent()) {
                PlayerStorage storage1 = optstorage.get();
                NBTTagCompound nbt = new NBTTagCompound();
                NBTTagCompound[] storageList = storage1.getList();
                for (int i = 0; i < storageList.length; ++i) {
                    Optional<EntityNPC> entityNPC;
                    String name;
                    if (storageList[i] != null) {
                        nbt = storageList[i];
                    }
                    if (!((name = nbt.func_74779_i("Name")).equalsIgnoreCase(message.exchange) & !checked)) continue;
                    EntityPixelmon playerOwned = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(storage1.partyPokemon[i], playerMP.field_70170_p);
                    Pixelmon.network.sendTo((IMessage)new Remove(PixelmonMethods.getID(storage1.partyPokemon[i])), playerMP);
                    storage1.changePokemon(i, null);
                    if (message.isShiny) {
                        pokemon.setIsShiny(true);
                    } else {
                        pokemon.setIsShiny(false);
                    }
                    pokemon.getLvl().setLevel(message.lvl);
                    pokemon.setForm(message.form);
                    storage1.pokedex.set(Pokedex.nameToID(pokemon.getPokemonName()), EnumPokedexRegisterStatus.caught);
                    storage1.pokedex.sendToPlayer(playerMP);
                    storage1.sendUpdatedList();
                    if (!PixelmonConfig.reuseTraders && (entityNPC = EntityNPC.locateNPCServer(playerMP.field_70170_p, message.id, EntityNPC.class)).isPresent()) {
                        entityNPC.get().func_70106_y();
                    }
                    checked = true;
                    playerMP.func_71053_j();
                    storage1.addToParty(pokemon);
                    pokemon.getEvolutions(TradeEvolution.class).forEach(evo -> {
                        if (evo.canEvolve(pokemon, playerOwned.getSpecies())) {
                            evo.doEvolution(pokemon);
                        }
                    });
                }
            }
            return null;
        }
    }
}

