/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoveData;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ExternalMove
implements IMessage {
    int moveIndex;
    long timeUsed;
    int[] pokemonId;

    public ExternalMove() {
    }

    public ExternalMove(int[] pokemonId, int moveIndex, long timeLastUsed) {
        this.pokemonId = pokemonId;
        this.moveIndex = moveIndex;
        this.timeUsed = timeLastUsed;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonId = new int[]{buf.readInt(), buf.readInt()};
        this.moveIndex = buf.readInt();
        this.timeUsed = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pokemonId[0]);
        buf.writeInt(this.pokemonId[1]);
        buf.writeInt(this.moveIndex);
        buf.writeLong(this.timeUsed);
    }

    public static class Handler
    implements IMessageHandler<ExternalMove, IMessage> {
        public IMessage onMessage(ExternalMove message, MessageContext ctx) {
            PixelmonData poke = ServerStorageDisplay.get(message.pokemonId);
            for (ExternalMoveData d : poke.getExternalMoves()) {
                if (d.moveIndex != message.moveIndex) continue;
                d.timeLastUsed = message.timeUsed;
            }
            return null;
        }
    }
}

