/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.ReceivedModListEvent;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.CoreModManager;

public class ModListPacket
implements IMessage {
    public String[] modIds;

    public ModListPacket() {
    }

    public ModListPacket(String[] modIds) {
        this.modIds = modIds;
    }

    public void fromBytes(ByteBuf buffer) {
        int numMods = buffer.readInt();
        this.modIds = new String[numMods];
        for (int i = 0; i < numMods; ++i) {
            this.modIds[i] = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    public void toBytes(ByteBuf buffer) {
        ArrayList modList = new ArrayList();
        ModDiscoverer discoverer = new ModDiscoverer();
        discoverer.findModDirMods(new File(Pixelmon.modDirectory, "mods"));
        File verDir = new File(Pixelmon.modDirectory, "1.12.2");
        if (verDir.isDirectory()) {
            discoverer.findModDirMods(verDir);
        }
        List mods = discoverer.identifyMods();
        modList.addAll(mods.stream().filter(mc -> mc instanceof FMLModContainer).map(mc -> (FMLModContainer)mc).collect(Collectors.toList()));
        buffer.writeInt(modList.size());
        for (FMLModContainer mc2 : modList) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)mc2.getModId());
        }
        for (String str : CoreModManager.getIgnoredMods()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)str);
        }
    }

    public static class Handler
    implements IMessageHandler<ModListPacket, IMessage> {
        public IMessage onMessage(ModListPacket message, MessageContext ctx) {
            Pixelmon.EVENT_BUS.post((Event)new ReceivedModListEvent(ctx.getServerHandler().field_147369_b, message.modIds));
            return null;
        }
    }
}

