/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RenamePokemon
implements IMessage {
    int[] id;
    String name;

    public RenamePokemon() {
    }

    public RenamePokemon(int[] pokemonID, String name) {
        this.id = pokemonID;
        this.name = name;
    }

    public void fromBytes(ByteBuf buffer) {
        this.id = new int[]{buffer.readInt(), buffer.readInt()};
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.id[0]);
        buffer.writeInt(this.id[1]);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
    }

    public static class Handler
    implements IMessageHandler<RenamePokemon, IMessage> {
        public IMessage onMessage(RenamePokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> this.processMessage(message, player));
            return null;
        }

        private void processMessage(RenamePokemon message, EntityPlayerMP player) {
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerComputerStorage comp;
                NBTTagCompound nbt;
                PlayerStorage storage = optstorage.get();
                Optional<EntityPixelmon> entityPixelmonOptional = storage.getAlreadyExists(message.id, player.field_70170_p);
                if (entityPixelmonOptional.isPresent()) {
                    entityPixelmonOptional.get().setNickname(message.name);
                } else if (storage.getNBT(message.id) != null) {
                    NBTTagCompound nbt2 = storage.getNBT(message.id);
                    if (nbt2 != null) {
                        nbt2.func_74778_a("Nickname", message.name);
                    }
                } else if (PixelmonStorage.computerManager.getPlayerStorage(player).contains(message.id) && (nbt = (comp = PixelmonStorage.computerManager.getPlayerStorage(player)).getPokemonNBT(message.id)) != null) {
                    nbt.func_74778_a("Nickname", message.name);
                    comp.updatePokemonNBT(message.id, nbt);
                }
                PixelmonStorage.save(player);
            }
        }
    }
}

