/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.EntityLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.NBTLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.MoveCostList;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ReplaceMove
implements IMessage {
    private int[] pokemonId;
    private int attackId;
    private int replaceIndex;
    private boolean checkEvo;

    public ReplaceMove() {
    }

    public ReplaceMove(int[] pokemonId, int attackId, int replaceIndex, boolean checkEvo) {
        this.pokemonId = pokemonId;
        this.attackId = attackId;
        this.replaceIndex = replaceIndex;
        this.checkEvo = checkEvo;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.attackId = buffer.readInt();
        this.replaceIndex = buffer.readInt();
        this.checkEvo = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        buffer.writeInt(this.attackId);
        buffer.writeInt(this.replaceIndex);
        buffer.writeBoolean(this.checkEvo);
    }

    public static class Handler
    implements IMessageHandler<ReplaceMove, IMessage> {
        public IMessage onMessage(ReplaceMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                Optional<PlayerStorage> optstorage;
                PlayerParticipant participant;
                if (!MoveCostList.checkEntry(player)) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.npc.cantpay", new Object[0]);
                    return;
                }
                Attack a = new Attack(message.attackId);
                PokemonLink pokemon = null;
                BattleControllerBase bc = BattleRegistry.getBattle((EntityPlayer)player);
                PixelmonWrapper pw = null;
                NBTTagCompound nbt = null;
                if (bc != null && (participant = bc.getPlayer((EntityPlayer)player)) != null && (pw = participant.getPokemonFromParty(message.pokemonId)) != null) {
                    pokemon = new WrapperLink(pw);
                }
                if (pokemon == null && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player)).isPresent()) {
                    PlayerStorage storage = optstorage.get();
                    EntityPixelmon p = storage.getAlreadyExists(message.pokemonId, player.field_70170_p).orElse(null);
                    if (p == null) {
                        nbt = storage.getNBT(message.pokemonId);
                        if (nbt == null) {
                            return;
                        }
                        pokemon = new NBTLink(nbt, storage);
                    } else {
                        pokemon = new EntityLink(p);
                    }
                }
                if (pokemon != null) {
                    if (message.replaceIndex > -1) {
                        Moveset moveset = pokemon.getMoveset();
                        TextComponentTranslation chatMessage = ChatHandler.getMessage("replacemove.replace", pokemon.getRealNickname(), moveset.get((int)((ReplaceMove)message).replaceIndex).baseAttack.getLocalizedName(), a.baseAttack.getLocalizedName());
                        moveset.set(message.replaceIndex, a);
                        if (bc == null || bc.battleEnded) {
                            ChatHandler.sendChat((ICommandSender)player, chatMessage);
                        } else {
                            bc.sendToPlayer((EntityPlayer)player, chatMessage);
                        }
                        if (bc == null && nbt != null) {
                            moveset.writeToNBT(nbt);
                        } else if (pw != null && bc.battleEnded) {
                            pw.writeToNBT();
                        }
                        pokemon.update(EnumUpdateType.Moveset);
                    }
                    if (message.checkEvo) {
                        PokemonLink finalPokemon = pokemon;
                        finalPokemon.getLevelContainer().tryEvolution();
                    }
                }
            });
            return null;
        }
    }
}

