/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetHeldItem
implements IMessage {
    int[] pokemonID;
    Item item;

    public SetHeldItem() {
    }

    public SetHeldItem(int[] pokemonID) {
        this.pokemonID = pokemonID;
    }

    public void setItem(Item item) {
        if (item == Items.field_190931_a) {
            this.item = null;
        }
        this.item = item;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonID = new int[]{buffer.readInt(), buffer.readInt()};
        boolean hasItem = buffer.readBoolean();
        this.item = hasItem ? Item.func_111206_d((String)ByteBufUtils.readUTF8String((ByteBuf)buffer)) : null;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonID[0]);
        buffer.writeInt(this.pokemonID[1]);
        buffer.writeBoolean(this.item != null);
        if (this.item != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.item.getRegistryName().toString());
        }
    }

    public static class Handler
    implements IMessageHandler<SetHeldItem, IMessage> {
        public IMessage onMessage(SetHeldItem message, MessageContext ctx) {
            HeldItemChangedEvent event;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            InventoryPlayer inventory = player.field_71071_by;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (!optstorage.isPresent()) {
                return null;
            }
            PlayerStorage storage = optstorage.get();
            if (storage.isOffline()) {
                return null;
            }
            int[] pokemonID = message.pokemonID;
            NBTTagCompound nbt = storage.getNBT(pokemonID);
            if (nbt == null) {
                return null;
            }
            boolean creative = player.func_184812_l_();
            ItemStack newHeldItem = ItemStack.field_190927_a;
            ItemStack currentItem = inventory.func_70445_o().func_77946_l();
            ItemStack giveItem = null;
            ItemStack singleItem = null;
            if (creative) {
                newHeldItem = message.item == null ? ItemStack.field_190927_a : new ItemStack(message.item, 1);
            } else {
                ItemStack oldItem = new ItemStack(nbt.func_74775_l("HeldItemStack"));
                if (oldItem.func_190926_b()) {
                    if (!currentItem.func_190926_b()) {
                        singleItem = currentItem.func_77946_l();
                        singleItem.func_190920_e(1);
                        newHeldItem = singleItem;
                        currentItem.func_190918_g(1);
                    }
                } else if (currentItem.func_190926_b()) {
                    currentItem = oldItem;
                    newHeldItem = ItemStack.field_190927_a;
                } else if (oldItem.func_77973_b() == currentItem.func_77973_b()) {
                    newHeldItem = ItemStack.field_190927_a;
                    currentItem.func_190917_f(1);
                } else {
                    singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    newHeldItem = singleItem;
                    if (currentItem.func_190916_E() <= 1) {
                        currentItem = oldItem;
                    } else {
                        currentItem.func_190918_g(1);
                        giveItem = oldItem;
                    }
                }
            }
            Optional<EntityPixelmon> pixelmonOptional = storage.getAlreadyExists(pokemonID, player.field_70170_p);
            if (newHeldItem.func_190926_b()) {
                newHeldItem = ItemStack.field_190927_a;
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new HeldItemChangedEvent((EntityLivingBase)player, pokemonID, pixelmonOptional, Optional.of(nbt), newHeldItem)))) {
                return null;
            }
            inventory.func_70437_b(currentItem);
            if (giveItem != null && !inventory.func_70441_a(giveItem)) {
                player.func_71019_a(giveItem, false);
            }
            if (pixelmonOptional.isPresent()) {
                pixelmonOptional.get().heldItem = event.newHeldItem;
            }
            if (newHeldItem.func_190926_b()) {
                nbt.func_82580_o("HeldItemStack");
            } else {
                nbt.func_74782_a("HeldItemStack", (NBTBase)event.newHeldItem.func_77955_b(new NBTTagCompound()));
            }
            PixelmonStorage.pokeBallManager.savePlayer(player.func_184102_h(), storage);
            return null;
        }
    }
}

