/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StopStartLevelling
implements IMessage {
    int[] pokemonId;

    public StopStartLevelling() {
    }

    public StopStartLevelling(int[] pokemonId) {
        this.pokemonId = pokemonId;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
    }

    public static class Handler
    implements IMessageHandler<StopStartLevelling, IMessage> {
        public IMessage onMessage(StopStartLevelling message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                int[] pokemonId = message.pokemonId;
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
                if (optstorage.isPresent()) {
                    PlayerStorage storage = optstorage.get();
                    if (storage.isInWorld(pokemonId)) {
                        Optional<EntityPixelmon> pixelmonOptional = storage.getAlreadyExists(pokemonId, player.field_70170_p);
                        if (pixelmonOptional.isPresent()) {
                            EntityPixelmon pixelmon = pixelmonOptional.get();
                            pixelmon.doesLevel = !pixelmon.doesLevel;
                            storage.update(pixelmon, EnumUpdateType.CanLevel);
                        }
                    } else if (storage.getNBT(pokemonId) != null) {
                        NBTTagCompound nbt = storage.getNBT(pokemonId);
                        if (nbt != null) {
                            this.invertValue(nbt);
                            storage.updateClient(nbt, EnumUpdateType.CanLevel);
                        }
                    } else if (PixelmonStorage.computerManager.getPlayerStorage(player).contains(pokemonId)) {
                        PlayerComputerStorage comp = PixelmonStorage.computerManager.getPlayerStorage(player);
                        if (!comp.contains(pokemonId)) {
                            return;
                        }
                        NBTTagCompound nbt = comp.getPokemonNBT(pokemonId);
                        if (nbt != null) {
                            this.invertValue(nbt);
                            comp.updatePokemonNBT(pokemonId, nbt);
                        }
                    }
                }
            });
            return null;
        }

        public void invertValue(NBTTagCompound nbt) {
            if (nbt.func_74764_b("DoesLevel")) {
                if (nbt.func_74767_n("DoesLevel")) {
                    nbt.func_74757_a("DoesLevel", false);
                } else {
                    nbt.func_74757_a("DoesLevel", true);
                }
            } else {
                nbt.func_74757_a("DoesLevel", true);
            }
        }
    }
}

