/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BackToMainMenu
implements IMessage {
    boolean canSwitch;
    boolean canFlee;
    ArrayList<int[]> pokemonToChoose;

    public BackToMainMenu() {
    }

    public BackToMainMenu(boolean canSwitch, boolean canFlee, ArrayList<PixelmonWrapper> pokemonToChoose) {
        this.canSwitch = canSwitch;
        this.canFlee = canFlee;
        this.pokemonToChoose = new ArrayList();
        this.pokemonToChoose.addAll(pokemonToChoose.stream().map(p -> p.getPokemonID()).collect(Collectors.toList()));
    }

    public void fromBytes(ByteBuf buffer) {
        this.canSwitch = buffer.readBoolean();
        this.canFlee = buffer.readBoolean();
        int size = buffer.readShort();
        this.pokemonToChoose = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.pokemonToChoose.add(new int[]{buffer.readInt(), buffer.readInt()});
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.canSwitch);
        buffer.writeBoolean(this.canFlee);
        buffer.writeShort(this.pokemonToChoose.size());
        for (int[] id : this.pokemonToChoose) {
            buffer.writeInt(id[0]);
            buffer.writeInt(id[1]);
        }
    }

    public static class Handler
    implements IMessageHandler<BackToMainMenu, IMessage> {
        public IMessage onMessage(BackToMainMenu message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.startPicking(message.canSwitch, message.canFlee, message.pokemonToChoose));
            return null;
        }
    }
}

