/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SwitchPokemon
implements IMessage {
    int pos;
    int battleControllerIndex;
    int[] switchingPokemonId;
    boolean happensInstantly;

    public SwitchPokemon() {
    }

    public SwitchPokemon(int pos, int battleControllerIndex, int[] switchingPokemonId, boolean happensInstantly) {
        this.pos = pos;
        this.battleControllerIndex = battleControllerIndex;
        this.switchingPokemonId = switchingPokemonId;
        this.happensInstantly = happensInstantly;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pos = buffer.readInt();
        this.battleControllerIndex = buffer.readInt();
        this.switchingPokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.happensInstantly = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pos);
        buffer.writeInt(this.battleControllerIndex);
        buffer.writeInt(this.switchingPokemonId[0]);
        buffer.writeInt(this.switchingPokemonId[1]);
        buffer.writeBoolean(this.happensInstantly);
    }

    public static class Handler
    implements IMessageHandler<SwitchPokemon, IMessage> {
        public IMessage onMessage(SwitchPokemon message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                int[] newPokemonId;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                BattleControllerBase bc = BattleRegistry.getBattle(message.battleControllerIndex);
                if (bc == null) {
                    return;
                }
                PlayerParticipant p = bc.getPlayer((EntityPlayer)player);
                if (p == null) {
                    return;
                }
                if (message.pos == -1) {
                    PixelmonWrapper switching = p.getPokemonFromID(message.switchingPokemonId);
                    if (switching == null) {
                        return;
                    }
                    newPokemonId = p.getBattleAI().getNextSwitch(switching);
                } else {
                    if (p.allPokemon.length <= message.pos) {
                        return;
                    }
                    newPokemonId = p.allPokemon[message.pos].getPokemonID();
                }
                bc.switchPokemon(message.switchingPokemonId, newPokemonId, message.happensInstantly);
            });
            return null;
        }
    }
}

