/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui;

import com.pixelmonmod.pixelmon.battles.attacks.IBattleMessage;
import com.pixelmonmod.pixelmon.battles.attacks.MessageType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StatusPacket
extends IBattleMessage
implements IMessage {
    private int status = -1;

    public StatusPacket() {
    }

    public StatusPacket(int[] id, int status) {
        this.pokemonID = id;
        this.status = status;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonID = new int[]{buf.readInt(), buf.readInt()};
        this.status = buf.readInt();
        this.messageType = MessageType.STATUS;
    }

    public void toBytes(ByteBuf buf) {
        for (int i : this.pokemonID) {
            buf.writeInt(i);
        }
        buf.writeInt(this.status);
    }

    @Override
    public void process() {
        PixelmonInGui pokemon = ClientProxy.battleManager.getPokemon(this.pokemonID);
        if (pokemon != null) {
            pokemon.status = this.status;
        }
        ClientProxy.battleManager.removeBattleMessage(this);
    }

    public static class Handler
    implements IMessageHandler<StatusPacket, IMessage> {
        public IMessage onMessage(StatusPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.addBattleMessage(message));
            return null;
        }
    }
}

