/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui;

import com.pixelmonmod.pixelmon.battles.attacks.IBattleMessage;
import com.pixelmonmod.pixelmon.battles.attacks.MessageType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.SwitchTask;
import io.netty.buffer.ByteBuf;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SwitchOutPacket
extends IBattleMessage
implements IMessage {
    PixelmonInGui newPokemonGUI;

    public SwitchOutPacket() {
    }

    public SwitchOutPacket(int[] pix1ID, PixelmonWrapper newPokemon) {
        this.pokemonID = pix1ID;
        this.newPokemonGUI = new PixelmonInGui(newPokemon);
    }

    public SwitchOutPacket(int[] pix1ID) {
        this.pokemonID = pix1ID;
        this.newPokemonGUI = new PixelmonInGui();
        this.newPokemonGUI.pokemonID = new int[]{-1, -1};
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonID = new int[]{buf.readInt(), buf.readInt()};
        this.newPokemonGUI = new PixelmonInGui();
        this.newPokemonGUI.decodeInto(buf);
        this.messageType = MessageType.SWITCHOUT;
    }

    public void toBytes(ByteBuf buf) {
        for (int i : this.pokemonID) {
            buf.writeInt(i);
        }
        this.newPokemonGUI.encodeInto(buf);
    }

    @Override
    public void process() {
        new Timer().scheduleAtFixedRate((TimerTask)new SwitchTask(this, this.pokemonID, this.newPokemonGUI), 0L, 5L);
    }

    public static class Handler
    implements IMessageHandler<SwitchOutPacket, IMessage> {
        public IMessage onMessage(SwitchOutPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.addBattleMessage(message));
            return null;
        }
    }
}

