/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChooseMoveset
implements IMessage {
    public static final ArrayList<ChoosingMovesetData> choosingMoveset = new ArrayList(4);
    int[] id;
    ArrayList<Integer> attackIds = new ArrayList(600);

    public ChooseMoveset() {
    }

    public ChooseMoveset(PixelmonData pokemon, ArrayList<Attack> chosenAttackList) {
        this.id = pokemon.pokemonID;
        this.attackIds.addAll(chosenAttackList.stream().map(a -> a.baseAttack.attackIndex).collect(Collectors.toList()));
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new int[]{buf.readInt(), buf.readInt()};
        int num = buf.readShort();
        for (int i = 0; i < num; ++i) {
            this.attackIds.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id[0]);
        buf.writeInt(this.id[1]);
        buf.writeShort(this.attackIds.size());
        this.attackIds.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
    }

    public static class Handler
    implements IMessageHandler<ChooseMoveset, IMessage> {
        public IMessage onMessage(ChooseMoveset message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(ctx.getServerHandler().field_147369_b);
                if (optstorage.isPresent()) {
                    ChoosingMovesetData d;
                    EntityPixelmon pixelmon;
                    PlayerStorage storage = optstorage.get();
                    boolean wasout = false;
                    Optional<EntityPixelmon> pixelmonOptional = storage.getAlreadyExists(message.id, ctx.getServerHandler().field_147369_b.field_70170_p);
                    if (pixelmonOptional.isPresent()) {
                        pixelmon = pixelmonOptional.get();
                        wasout = true;
                    } else {
                        pixelmon = storage.sendOut(message.id, ctx.getServerHandler().field_147369_b.field_70170_p);
                    }
                    pixelmon.getMoveset().replaceWith(message.attackIds);
                    pixelmon.update(EnumUpdateType.Moveset);
                    if (!wasout) {
                        pixelmon.unloadEntity();
                    }
                    if ((d = this.getChoosingMoveset(ctx.getServerHandler().field_147369_b)) != null) {
                        d.next();
                        if (d.pokemonList.isEmpty()) {
                            choosingMoveset.remove(d);
                        }
                    }
                }
            });
            return null;
        }

        private ChoosingMovesetData getChoosingMoveset(EntityPlayerMP playerEntity) {
            for (ChoosingMovesetData c : choosingMoveset) {
                if (c.player.getPersistentID() != playerEntity.getPersistentID()) continue;
                return c;
            }
            return null;
        }
    }
}

