/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.evolution;

import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EvolutionResponse
implements IMessage {
    boolean accept;
    int[] pokemonID;
    EvolutionResponseMode mode;

    public EvolutionResponse() {
    }

    public EvolutionResponse(int[] pokemonID, boolean accept) {
        this.pokemonID = pokemonID;
        this.accept = accept;
        this.mode = EvolutionResponseMode.Message;
    }

    public EvolutionResponse(int[] pokemonID) {
        this.mode = EvolutionResponseMode.SpawnPokemon;
        this.pokemonID = pokemonID;
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = EvolutionResponseMode.values()[buffer.readInt()];
        this.pokemonID = new int[]{buffer.readInt(), buffer.readInt()};
        if (this.mode == EvolutionResponseMode.Message) {
            this.accept = buffer.readBoolean();
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.mode.ordinal());
        buffer.writeInt(this.pokemonID[0]);
        buffer.writeInt(this.pokemonID[1]);
        if (this.mode == EvolutionResponseMode.Message) {
            buffer.writeBoolean(this.accept);
        }
    }

    public static class Handler
    implements IMessageHandler<EvolutionResponse, IMessage> {
        public IMessage onMessage(EvolutionResponse message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                if (message.mode == EvolutionResponseMode.Message) {
                    if (message.accept) {
                        EvolutionQueryList.acceptQuery(ctx.getServerHandler().field_147369_b, message.pokemonID);
                    } else {
                        EvolutionQueryList.declineQuery(ctx.getServerHandler().field_147369_b, message.pokemonID);
                    }
                } else {
                    EvolutionQueryList.spawnPokemon(ctx.getServerHandler().field_147369_b, message.pokemonID);
                }
            });
            return null;
        }
    }

    static enum EvolutionResponseMode {
        Message,
        SpawnPokemon;

    }
}

