/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.mail;

import com.pixelmonmod.pixelmon.items.heldItems.ItemMail;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MailPacket
implements IMessage {
    private Boolean sealed;
    private String author;
    private String contents;
    private String playerUUID;

    public MailPacket() {
    }

    public MailPacket(Boolean sealed, String author, String contents, EntityPlayer player) {
        this.sealed = sealed;
        this.author = author;
        this.contents = contents;
        this.playerUUID = player.func_110124_au().toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.sealed = buf.readBoolean();
        this.author = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.contents = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.sealed.booleanValue());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.author);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.contents);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID);
    }

    public static class Handler
    implements IMessageHandler<MailPacket, IMessage> {
        public IMessage onMessage(MailPacket message, MessageContext ctx) {
            UUID targetUUID = UUID.fromString(message.playerUUID);
            List players = ctx.getServerHandler().field_147369_b.func_184102_h().func_184103_al().func_181057_v();
            players.stream().filter(player -> player.func_110124_au().equals(targetUUID)).forEach(player -> {
                ItemStack letter = player.func_184614_ca();
                if (letter != null && letter.func_77973_b() instanceof ItemMail) {
                    NBTTagCompound nbtData = new NBTTagCompound();
                    nbtData.func_74757_a("editable", message.sealed == false);
                    nbtData.func_74778_a("author", message.author);
                    nbtData.func_74778_a("contents", message.contents);
                    if (message.sealed.booleanValue()) {
                        letter.func_77964_b(1);
                    }
                    letter.func_77982_d(nbtData);
                }
            });
            return null;
        }
    }
}

