/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonOpenGUI;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AddTrainerPokemon
implements IMessage {
    int trainerID;

    public AddTrainerPokemon() {
    }

    public AddTrainerPokemon(int trainerId) {
        this.trainerID = trainerId;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.trainerID);
    }

    public void fromBytes(ByteBuf buffer) {
        this.trainerID = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<AddTrainerPokemon, IMessage> {
        public IMessage onMessage(AddTrainerPokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!ItemNPCEditor.checkPermission(player)) {
                return null;
            }
            Optional<NPCTrainer> entityNPCOptional = EntityNPC.locateNPCServer(player.field_70170_p, message.trainerID, NPCTrainer.class);
            if (!entityNPCOptional.isPresent()) {
                return null;
            }
            NPCTrainer t = entityNPCOptional.get();
            if (t != null) {
                PlayerStorage storage = t.getPokemonStorage();
                if (storage.hasSpace()) {
                    EntityPixelmon pix = (EntityPixelmon)PixelmonEntityList.createEntityByName("Magikarp", player.field_70170_p);
                    storage.addToParty(pix);
                }
                t.updateLvl();
                Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), player);
                for (int i = 0; i < storage.count(); ++i) {
                    Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(storage.getList()[i])), player);
                }
                Pixelmon.network.sendTo((IMessage)new ChangePokemonOpenGUI(storage.count() - 1), player);
            }
            return null;
        }
    }
}

