/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DeleteTrainerPokemon
implements IMessage {
    int trainerID;
    int position;

    public DeleteTrainerPokemon() {
    }

    public DeleteTrainerPokemon(int trainerID, int position) {
        this.trainerID = trainerID;
        this.position = position;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.trainerID);
        buffer.writeInt(this.position);
    }

    public void fromBytes(ByteBuf buffer) {
        this.trainerID = buffer.readInt();
        this.position = buffer.readInt();
    }

    public static void deletePokemon(int trainerID, int position, MessageContext ctx, boolean updateClient) {
        EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
        Optional<NPCTrainer> entityNPCOptional = EntityNPC.locateNPCServer(p.field_70170_p, trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer t = entityNPCOptional.get();
        PlayerStorage storage = t.getPokemonStorage();
        if (storage.count() > 1) {
            storage.removeFromPartyTrainer(position);
        }
        t.updateLvl();
        if (updateClient) {
            Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), p);
            NBTTagCompound[] storageList = storage.getList();
            for (int i = 0; i < storage.count(); ++i) {
                Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(storageList[i])), p);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<DeleteTrainerPokemon, IMessage> {
        public IMessage onMessage(DeleteTrainerPokemon message, MessageContext ctx) {
            DeleteTrainerPokemon.deletePokemon(message.trainerID, message.position, ctx, true);
            return null;
        }
    }
}

