/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class InteractNPC
implements IMessage {
    int npcID;
    EnumNPCType npcType;

    public InteractNPC() {
    }

    public InteractNPC(int npcID, EnumNPCType npcType) {
        this.npcID = npcID;
        this.npcType = npcType;
    }

    public void fromBytes(ByteBuf buf) {
        this.npcID = buf.readInt();
        this.npcType = EnumNPCType.getFromOrdinal(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.npcID);
        buf.writeInt(this.npcType.ordinal());
    }

    public static class Handler
    implements IMessageHandler<InteractNPC, IMessage> {
        public IMessage onMessage(InteractNPC message, MessageContext ctx) {
            ServerStorageDisplay.NPCInteractId = message.npcID;
            ClientProxy.battleManager.choosingPokemon = true;
            if (message.npcType == EnumNPCType.Relearner) {
                ClientProxy.battleManager.mode = BattleMode.ChooseRelearnMove;
            } else if (message.npcType == EnumNPCType.Tutor) {
                ClientProxy.battleManager.mode = BattleMode.ChooseTutor;
            }
            return null;
        }
    }
}

