/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NPCLearnMove
implements IMessage {
    int slot;
    EnumNPCType npcType;

    public NPCLearnMove() {
    }

    public NPCLearnMove(int slot, EnumNPCType npcType) {
        this.slot = slot;
        this.npcType = npcType;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.npcType = EnumNPCType.getFromOrdinal(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.npcType.ordinal());
    }

    public static class Handler
    implements IMessageHandler<NPCLearnMove, IMessage> {
        public IMessage onMessage(NPCLearnMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                if (storage.partyPokemon[message.slot] != null) {
                    int[] id = PixelmonMethods.getID(storage.partyPokemon[message.slot]);
                    if (message.npcType == EnumNPCType.Relearner) {
                        player.openGui((Object)Pixelmon.instance, EnumGui.Relearner.getIndex().intValue(), player.field_70170_p, id[0], id[1], 0);
                    } else if (message.npcType == EnumNPCType.Tutor) {
                        player.openGui((Object)Pixelmon.instance, EnumGui.Tutor.getIndex().intValue(), player.field_70170_p, id[0], id[1], 0);
                    }
                }
            }
            return null;
        }
    }
}

