/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerData;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.EnumBuySell;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ShopKeeperPacket
implements IMessage {
    EnumBuySell buySell;
    String itemID;
    int amount;
    int shopKeeperID;

    public ShopKeeperPacket() {
    }

    public ShopKeeperPacket(EnumBuySell buySell, int shopkeeperID, String itemID, int amount) {
        this.shopKeeperID = shopkeeperID;
        this.itemID = itemID;
        this.amount = amount;
        this.buySell = buySell;
    }

    public void fromBytes(ByteBuf buf) {
        this.buySell = buf.readBoolean() ? EnumBuySell.Buy : EnumBuySell.Sell;
        this.shopKeeperID = buf.readInt();
        this.itemID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.buySell == EnumBuySell.Buy);
        buf.writeInt(this.shopKeeperID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.itemID);
        buf.writeInt(this.amount);
    }

    public static boolean checkInventoryCanFit(InventoryPlayer inventoryIn, ItemStack itemStackIn) {
        if (!itemStackIn.func_190926_b()) {
            try {
                int i;
                do {
                    i = itemStackIn.func_190916_E();
                    itemStackIn.func_190920_e(inventoryIn.func_70452_e(itemStackIn));
                } while (itemStackIn.func_190916_E() > 0 && itemStackIn.func_190916_E() < i);
                return itemStackIn.func_190916_E() < i;
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashReportCategory = crashReport.func_85058_a("Item being added");
                crashReportCategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemStackIn.func_77973_b()));
                crashReportCategory.func_71507_a("Item data", (Object)itemStackIn.func_77960_j());
                crashReportCategory.func_71507_a("Item name", (Object)itemStackIn.func_82833_r());
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public static class Handler
    implements IMessageHandler<ShopKeeperPacket, IMessage> {
        public IMessage onMessage(ShopKeeperPacket message, MessageContext ctx) {
            block14: {
                EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
                Optional<NPCShopkeeper> npcOptional = EntityNPC.locateNPCServer(p.field_70170_p, message.shopKeeperID, NPCShopkeeper.class);
                if (!npcOptional.isPresent()) {
                    return null;
                }
                NPCShopkeeper npc = npcOptional.get();
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(p);
                if (!optstorage.isPresent()) break block14;
                PlayerStorage storage = optstorage.get();
                if (message.buySell == EnumBuySell.Buy) {
                    ArrayList<ShopItemWithVariation> itemList = npc.getItemList();
                    for (ShopItemWithVariation s : itemList) {
                        if (!s.getBaseShopItem().id.equals(message.itemID)) continue;
                        int buyCost = s.getBuyCost();
                        if (storage.getCurrency() < buyCost * message.amount) continue;
                        ItemStack item = s.getItem();
                        ItemStack buyStack = item.func_77946_l();
                        int initialAmount = message.amount;
                        buyStack.func_190920_e(message.amount);
                        if (ShopKeeperPacket.checkInventoryCanFit(p.field_71071_by, buyStack)) {
                            Item buyItem = buyStack.func_77973_b();
                            if (buyItem instanceof ItemPokeball && ((ItemPokeball)buyItem).type == EnumPokeballs.PokeBall && message.amount >= 10) {
                                ItemStack premierBall = new ItemStack(PixelmonItemsPokeballs.premierBall, 1);
                                ShopKeeperPacket.checkInventoryCanFit(p.field_71071_by, premierBall);
                            }
                            storage.removeCurrency(buyCost * message.amount);
                            this.updateTransaction(storage, p, npc);
                            return null;
                        }
                        if (initialAmount > buyStack.func_190916_E()) {
                            storage.removeCurrency(buyCost * (initialAmount - buyStack.func_190916_E()));
                            this.updateTransaction(storage, p, npc);
                            return null;
                        }
                        Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(storage.getCurrency()), p);
                    }
                } else {
                    ArrayList<ShopItemWithVariation> sellList = npc.getSellList((EntityPlayer)p);
                    for (ShopItemWithVariation s : sellList) {
                        if (!s.getBaseShopItem().id.equals(message.itemID)) continue;
                        int count = 0;
                        ItemStack sStack = s.getItem();
                        for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                            ItemStack item = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                            if (!this.areItemsEqual(item, sStack)) continue;
                            count += item.func_190916_E();
                        }
                        if (count < message.amount) continue;
                        int cost = s.getSellCost();
                        count = message.amount;
                        for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                            ItemStack item = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                            if (this.areItemsEqual(item, sStack)) {
                                if (item.func_190916_E() >= count) {
                                    item.func_190920_e(item.func_190916_E() - count);
                                    count = 0;
                                } else {
                                    count -= item.func_190916_E();
                                    item.func_190920_e(0);
                                }
                                if (item.func_190916_E() == 0) {
                                    p.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                                }
                            }
                            if (count <= 0) break;
                        }
                        storage.addCurrency(cost * message.amount);
                        this.updateTransaction(storage, p, npc);
                    }
                }
            }
            return null;
        }

        private void updateTransaction(PlayerStorage storage, EntityPlayerMP p, NPCShopkeeper npc) {
            Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(storage.getCurrency()), p);
            p.func_71120_a(p.field_71069_bz);
            npc.sendItemsToPlayer((EntityPlayer)p);
        }

        private boolean areItemsEqual(ItemStack item1, ItemStack item2) {
            return !item1.func_190926_b() && ItemStack.func_179545_c((ItemStack)item1, (ItemStack)item2) && ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2) && item1.func_77952_i() == item2.func_77952_i();
        }
    }
}

