/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditedPlayer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditingPlayer;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.items.ItemPokemonEditor;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RespondPokemonEditorAllowed
implements IMessage {
    UUID editingPlayer;
    boolean allowPokemonEditors;

    public RespondPokemonEditorAllowed() {
    }

    public RespondPokemonEditorAllowed(UUID editingPlayer, boolean allowPokemonEditors) {
        this.editingPlayer = editingPlayer;
        this.allowPokemonEditors = allowPokemonEditors;
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.editingPlayer);
        buf.writeBoolean(this.allowPokemonEditors);
    }

    public void fromBytes(ByteBuf buf) {
        this.editingPlayer = PixelmonMethods.fromBytesUUID(buf);
        this.allowPokemonEditors = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<RespondPokemonEditorAllowed, IMessage> {
        public IMessage onMessage(RespondPokemonEditorAllowed message, MessageContext ctx) {
            MinecraftServer server = ctx.getServerHandler().field_147369_b.func_184102_h();
            EntityPlayerMP editingPlayer = server.func_184103_al().func_177451_a(message.editingPlayer);
            EntityPlayerMP editedPlayer = ctx.getServerHandler().field_147369_b;
            if (editingPlayer != null) {
                if (!ItemPokemonEditor.checkPermission(editingPlayer)) {
                    return null;
                }
                if (message.allowPokemonEditors) {
                    Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(editedPlayer);
                    if (optstorage.isPresent()) {
                        PlayerStorage storage = optstorage.get();
                        server.func_152344_a(() -> {
                            storage.recallAllPokemon();
                            Pixelmon.network.sendTo((IMessage)new SetEditingPlayer(editingPlayer.func_110124_au(), editingPlayer.getDisplayNameString()), editedPlayer);
                            editedPlayer.openGui((Object)Pixelmon.instance, EnumGui.EditedPlayer.ordinal(), editedPlayer.field_70170_p, 0, 0, 0);
                            Pixelmon.network.sendTo((IMessage)new SetEditedPlayer(editedPlayer.func_110124_au(), editedPlayer.getDisplayNameString(), storage.convertToData()), editingPlayer);
                            editingPlayer.openGui((Object)Pixelmon.instance, EnumGui.PokemonEditor.ordinal(), editingPlayer.field_70170_p, 0, 0, 0);
                        });
                    }
                } else {
                    ChatHandler.sendChat((Entity)editingPlayer, I18n.func_74838_a((String)"gui.pokemoneditor.notallowedplayer"), editedPlayer.getDisplayNameString());
                }
            }
            return null;
        }
    }
}

