/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetImportPokemonID;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class UpdateEditedPokemon
implements IMessage {
    PixelmonData data;

    protected UpdateEditedPokemon() {
    }

    protected UpdateEditedPokemon(PixelmonData data) {
        this.data = data;
    }

    public void toBytes(ByteBuf buffer) {
        this.data.encodeInto(buffer);
    }

    public void fromBytes(ByteBuf buffer) {
        this.data = new PixelmonData();
        this.data.decodeInto(buffer);
    }

    public static NBTTagCompound updatePokemon(UpdateEditedPokemon message, EntityPlayerMP player, PlayerStorage storage) {
        int pos = message.data.order;
        NBTTagCompound tag = storage.getList()[pos];
        EntityPixelmon pixelmon = null;
        if (tag == null) {
            pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityByName(message.data.name, player.func_130014_f_());
            storage.addToParty(pixelmon, message.data.order);
            tag = storage.getList()[pos];
        }
        if (tag != null) {
            message.data.updatePokemon(tag);
            pixelmon = storage.sendOutFromPosition(pos, player.field_70170_p);
        }
        if (pixelmon != null) {
            if (PixelmonMethods.isIDSame(message.data.pokemonID, new int[]{-1, -1})) {
                Pixelmon.network.sendTo((IMessage)new SetImportPokemonID(pos, pixelmon.getPokemonId()), player);
            }
            pixelmon.updateStats();
            pixelmon.healByPercent(100.0f);
            pixelmon.isFainted = false;
            storage.updateAndSendToClient(pixelmon, EnumUpdateType.Stats, EnumUpdateType.Nickname, EnumUpdateType.Ability, EnumUpdateType.HeldItem, EnumUpdateType.HP, EnumUpdateType.Moveset, EnumUpdateType.Friendship);
            pixelmon.unloadEntity();
        }
        return tag;
    }
}

