/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemon;
import com.pixelmonmod.pixelmon.items.ItemPokemonEditor;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdatePlayerPokemon
extends UpdateEditedPokemon {
    UUID playerID;

    public UpdatePlayerPokemon() {
    }

    public UpdatePlayerPokemon(PixelmonData data) {
        super(data);
        this.playerID = GuiPokemonEditorParty.editedPlayerUUID;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        PixelmonMethods.toBytesUUID(buffer, this.playerID);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.playerID = PixelmonMethods.fromBytesUUID(buffer);
    }

    public static class Handler
    implements IMessageHandler<UpdatePlayerPokemon, IMessage> {
        public IMessage onMessage(UpdatePlayerPokemon message, MessageContext ctx) {
            Optional<PlayerStorage> optstorage;
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            if (!ItemPokemonEditor.checkPermission(sender)) {
                return null;
            }
            EntityPlayerMP player = sender.func_184102_h().func_184103_al().func_177451_a(message.playerID);
            if (player != null && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player)).isPresent()) {
                PlayerStorage storage = optstorage.get();
                sender.func_184102_h().func_152344_a(() -> {
                    UpdateEditedPokemon.updatePokemon(message, player, storage);
                    ItemPokemonEditor.updateSinglePokemon(sender, message.playerID, message.data.order);
                });
            }
            return null;
        }
    }
}

