/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.ranch;

import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ranch.EnumRanchServerPacketMode;
import com.pixelmonmod.pixelmon.items.ItemRanchUpgrade;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RanchBlockServerPacket
implements IMessage {
    EnumRanchServerPacketMode mode;
    int x;
    int y;
    int z;
    int[] id;
    boolean[] extendDirection;

    public RanchBlockServerPacket() {
    }

    public RanchBlockServerPacket(int x, int y, int z, EnumRanchServerPacketMode mode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    public RanchBlockServerPacket(int x, int y, int z, int[] id, EnumRanchServerPacketMode mode) {
        this(x, y, z, mode);
        this.id = id;
    }

    public RanchBlockServerPacket(int x, int y, int z, EnumRanchServerPacketMode mode, boolean[] extendDirection) {
        this(x, y, z, mode);
        this.extendDirection = extendDirection;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = EnumRanchServerPacketMode.getFromOrdinal(buf.readShort());
        switch (this.mode) {
            case RemovePokemon: 
            case AddPokemon: {
                this.id = new int[]{buf.readInt(), buf.readInt()};
                break;
            }
            case ExtendRanch: {
                this.extendDirection = new boolean[]{buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean()};
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeShort(this.mode.ordinal());
        switch (this.mode) {
            case RemovePokemon: 
            case AddPokemon: {
                buf.writeInt(this.id[0]);
                buf.writeInt(this.id[1]);
                break;
            }
            case ExtendRanch: {
                buf.writeBoolean(this.extendDirection[0]);
                buf.writeBoolean(this.extendDirection[1]);
                buf.writeBoolean(this.extendDirection[2]);
                buf.writeBoolean(this.extendDirection[3]);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<RanchBlockServerPacket, IMessage> {
        public IMessage onMessage(RanchBlockServerPacket message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                TileEntityRanchBlock rb = (TileEntityRanchBlock)player.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
                if (rb == null) {
                    return;
                }
                block0 : switch (message.mode) {
                    case AddPokemon: {
                        rb.addPokemon(player, message.id);
                        break;
                    }
                    case RemovePokemon: {
                        rb.removePokemon(player, message.id);
                        break;
                    }
                    case CollectEgg: {
                        rb.claimEgg(player);
                        break;
                    }
                    case ExtendRanch: {
                        rb.getBounds().Extend(player, message.extendDirection[0] ? 1 : 0, message.extendDirection[1] ? 1 : 0, message.extendDirection[2] ? 1 : 0, message.extendDirection[3] ? 1 : 0);
                        if (player.field_71075_bZ.field_75098_d) break;
                        if (player.func_184614_ca().func_77973_b() instanceof ItemRanchUpgrade) {
                            player.field_71071_by.func_174925_a(player.func_184614_ca().func_77973_b(), player.func_184614_ca().func_77960_j(), 1, player.func_184614_ca().func_77978_p());
                            break;
                        }
                        for (ItemStack s : player.field_71071_by.field_70462_a) {
                            if (!(s.func_77973_b() instanceof ItemRanchUpgrade)) continue;
                            player.field_71071_by.func_174925_a(s.func_77973_b(), s.func_77960_j(), 1, s.func_77978_p());
                            break block0;
                        }
                        break;
                    }
                }
            });
            return null;
        }
    }
}

