/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.vendingMachine;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.machines.BlockVendingMachine;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerData;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class VendingMachinePacket
implements IMessage {
    String itemID;
    int amount;
    BlockPos pos;

    public VendingMachinePacket() {
    }

    public VendingMachinePacket(BlockPos pos, String itemName, int amount) {
        this.pos = pos;
        this.itemID = itemName;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.itemID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.itemID);
        buf.writeInt(this.amount);
    }

    public static boolean checkInventoryCanFit(InventoryPlayer inventoryIn, ItemStack itemStackIn) {
        InventoryPlayer inventory = new InventoryPlayer(inventoryIn.field_70458_d);
        if (itemStackIn != null && itemStackIn.func_190916_E() != 0 && itemStackIn.func_77973_b() != null) {
            try {
                int i;
                if (itemStackIn.func_77951_h()) {
                    int i2 = inventory.func_70447_i();
                    if (i2 >= 0) {
                        inventory.field_70462_a.set(i2, (Object)itemStackIn.func_77946_l());
                        ((ItemStack)inventory.field_70462_a.get(i2)).func_190915_d(5);
                        itemStackIn.func_190920_e(0);
                        return true;
                    }
                    if (inventory.field_70458_d.field_71075_bZ.field_75098_d) {
                        itemStackIn.func_190920_e(0);
                        return true;
                    }
                    return false;
                }
                do {
                    i = itemStackIn.func_190916_E();
                    itemStackIn.func_190920_e(inventory.func_70452_e(itemStackIn));
                } while (itemStackIn.func_190916_E() > 0 && itemStackIn.func_190916_E() < i);
                if (itemStackIn.func_190916_E() == i && inventory.field_70458_d.field_71075_bZ.field_75098_d) {
                    itemStackIn.func_190920_e(0);
                    return true;
                }
                return itemStackIn.func_190916_E() < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemStackIn.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)itemStackIn.func_77960_j());
                crashreportcategory.func_71507_a("Item name", (Object)itemStackIn.func_82833_r());
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    public static class Handler
    implements IMessageHandler<VendingMachinePacket, IMessage> {
        public IMessage onMessage(VendingMachinePacket message, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            BlockVendingMachine vendingMachine = (BlockVendingMachine)p.field_70170_p.func_180495_p(message.pos).func_177230_c();
            if (vendingMachine == null) {
                return null;
            }
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(p);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                ArrayList<ShopItemWithVariation> itemList = ((BlockVendingMachine)PixelmonBlocks.blueVendingMachineBlock).getShop().getItems();
                for (ShopItemWithVariation s : itemList) {
                    if (!s.getBaseShopItem().id.equals(message.itemID)) continue;
                    s.getBuyCost();
                    if (storage.getCurrency() < s.getBuyCost()) continue;
                    ItemStack item = s.getItem();
                    ItemStack buyStack = item.func_77946_l();
                    buyStack.func_190920_e(message.amount);
                    if (!VendingMachinePacket.checkInventoryCanFit(p.field_71071_by, buyStack)) continue;
                    buyStack.func_190920_e(message.amount);
                    p.field_71071_by.func_70441_a(buyStack);
                    storage.removeCurrency(s.getBuyCost());
                    Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(storage.getCurrency()), p);
                    p.func_71120_a(p.field_71069_bz);
                    p.func_71053_j();
                    return null;
                }
            }
            return null;
        }
    }
}

