/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class Battle
extends PixelmonCommand {
    private PlayerParticipant player1;
    private PlayerParticipant player2;

    public Battle() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "pokebattle";
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "/pokebattle <player1> <player2>";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2 || args.length > 3) {
            this.sendMessage(sender, "pixelmon.command.general.invalid", new Object[0]);
            this.sendMessage(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayerMP player1 = this.getPlayer(sender, args[0]);
        if (player1 == null) {
            throw new PlayerNotFoundException(args[0]);
        }
        EntityPlayerMP player2 = this.getPlayer(sender, args[1]);
        if (player2 == null) {
            throw new PlayerNotFoundException(args[1]);
        }
        if (player1 == player2) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle.sameperson", new Object[0]);
            return;
        }
        if (BattleRegistry.getBattle((EntityPlayer)player1) != null) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle.cannotchallenge", player1.func_70005_c_());
            return;
        }
        if (BattleRegistry.getBattle((EntityPlayer)player2) != null) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle.cannotchallenge", player2.func_70005_c_());
            return;
        }
        if (player1.field_70170_p != player2.field_70170_p) {
            Battle.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.battle.dimension", (Object[])new Object[0]);
            return;
        }
        PlayerStorage storage1 = this.getPlayerStorage(player1);
        PlayerStorage storage2 = this.getPlayerStorage(player2);
        if (storage1 != null && storage2 != null) {
            EntityPixelmon player1FirstPokemon = storage1.getFirstAblePokemon(player1.field_70170_p);
            this.player1 = new PlayerParticipant(player1, player1FirstPokemon);
            EntityPixelmon player2FirstPokemon = storage2.getFirstAblePokemon(player2.field_70170_p);
            this.player2 = new PlayerParticipant(player2, player2FirstPokemon);
            EntityPlayerMP invalidPlayer = null;
            if (player1FirstPokemon == null) {
                invalidPlayer = player1;
            } else if (player2FirstPokemon == null) {
                invalidPlayer = player2;
            }
            if (invalidPlayer != null) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle.nopokemon", invalidPlayer.getDisplayNameString());
                return;
            }
            Battle.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.battle.started", (Object[])new Object[]{player1.getDisplayNameString(), player2.getDisplayNameString()});
            this.player1.startedBattle = true;
            BattleParticipant[] team1 = new BattleParticipant[]{this.player1};
            BattleParticipant[] team2 = new BattleParticipant[]{this.player2};
            new BattleControllerBase(team1, team2);
        } else if (PixelmonConfig.printErrors) {
            Pixelmon.LOGGER.error("Error loading player for command /pokebattle: " + args[0] + " " + args[1]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length != 1 && args.length != 2 ? Collections.emptyList() : this.tabCompleteUsernames(args);
    }
}

