/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.items.PixelmonItemBlock;
import com.pixelmonmod.pixelmon.util.PixelBlockSnapshot;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSnapShot
extends CommandBase {
    private ArrayList<BlockPos> corners = new ArrayList();
    public static NBTTagCompound testCompound;

    public String func_71517_b() {
        return "psnapshot";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <argument>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer) || args.length == 0) {
            CommandChatHandler.sendChat(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        World world = player.field_70170_p;
        if (args[0].equals("set")) {
            this.corners.add(player.func_180425_c());
            if (this.corners.size() > 2) {
                this.corners.remove(0);
            }
            CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.corners", new Object[0]);
            for (BlockPos p : this.corners) {
                CommandChatHandler.sendChat(sender, p.toString(), new Object[0]);
            }
        } else if (args[0].equals("save")) {
            if (this.corners.size() < 2) {
                CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.nobounds", new Object[0]);
                return;
            }
            testCompound = new NBTTagCompound();
            BlockPos corner0 = this.corners.get(0);
            BlockPos corner1 = this.corners.get(1);
            int x0 = corner0.func_177958_n();
            int x1 = corner1.func_177958_n();
            int y0 = corner0.func_177956_o();
            int y1 = corner1.func_177956_o();
            int z0 = corner0.func_177952_p();
            int z1 = corner1.func_177952_p();
            int minX = Math.min(x0, x1);
            int maxX = Math.max(x0, x1);
            int minY = Math.min(y0, y1);
            int maxY = Math.max(y0, y1);
            int minZ = Math.min(z0, z1);
            int maxZ = Math.max(z0, z1);
            testCompound.func_74768_a("Width", maxX - minX + 1);
            testCompound.func_74768_a("Height", maxY - minY + 1);
            testCompound.func_74768_a("Length", maxZ - minZ + 1);
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BlockPos loc;
                        BlockPos pos = new BlockPos(x, y, z);
                        PixelBlockSnapshot snapshot = null;
                        if (world.func_180495_p(pos).func_177230_c() instanceof MultiBlock && !(loc = ((MultiBlock)world.func_180495_p(pos).func_177230_c()).findBaseBlock((IBlockAccess)player.field_70170_p, new BlockPos.MutableBlockPos(pos), world.func_180495_p(pos))).equals((Object)pos)) {
                            snapshot = new PixelBlockSnapshot(world, pos, Blocks.field_150350_a.func_176223_P());
                        }
                        if (snapshot == null) {
                            snapshot = new PixelBlockSnapshot(world, pos, world.func_180495_p(pos));
                        }
                        NBTTagCompound snapshotTag = new NBTTagCompound();
                        snapshot.writeToNBT(snapshotTag);
                        testCompound.func_74782_a("X" + (x - minX) + "Y" + (y - minY) + "Z" + (z - minZ), (NBTBase)snapshotTag);
                    }
                }
            }
            AxisAlignedBB aabb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List statues = world.func_72872_a(EntityStatue.class, aabb);
            testCompound.func_74768_a("numStatues", statues.size());
            int index = 0;
            if (statues.size() > 0) {
                testCompound.func_74768_a("baseX", minX);
                testCompound.func_74768_a("baseY", minY);
                testCompound.func_74768_a("baseZ", minZ);
            }
            for (Object statue : statues) {
                NBTTagCompound statueTag = new NBTTagCompound();
                statue.func_189511_e(statueTag);
                testCompound.func_74782_a("statue" + index++, (NBTBase)statueTag);
            }
            List trainers = world.func_72872_a(NPCTrainer.class, aabb);
            for (Object trainer : trainers) {
                Pixelmon.LOGGER.info("Trainer position: " + (((NPCTrainer)((Object)trainer)).field_70165_t - (double)minX) + " " + (((NPCTrainer)((Object)trainer)).field_70163_u - (double)minY) + " " + (((NPCTrainer)((Object)trainer)).field_70161_v - (double)minZ));
            }
            List chattingNPCS = world.func_72872_a(NPCChatting.class, aabb);
            for (NPCChatting npc : chattingNPCS) {
                Pixelmon.LOGGER.info("Chatting NPC position: " + (npc.field_70165_t - (double)minX) + " " + (npc.field_70163_u - (double)minY) + " " + (npc.field_70161_v - (double)minZ));
            }
            if (args.length > 1) {
                String baseDirectory = Pixelmon.modDirectory + "/snapshots/";
                String filename = baseDirectory + args[1] + ".snapshot";
                File saveFile = new File(filename);
                File saveDirPath = new File(baseDirectory);
                if (!saveDirPath.exists()) {
                    saveDirPath.mkdirs();
                }
                try {
                    FileOutputStream f = new FileOutputStream(saveFile);
                    DataOutputStream s = new DataOutputStream(f);
                    CompressedStreamTools.func_74800_a((NBTTagCompound)testCompound, (DataOutput)s);
                    s.close();
                    f.close();
                    CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.savefile", args[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.save", new Object[0]);
            }
        } else {
            if (args[0].equals("read") && args.length > 1) {
                String filename = Pixelmon.modDirectory + "/snapshots/" + args[1] + ".snapshot";
                File saveFile = new File(filename);
                try {
                    testCompound = CompressedStreamTools.func_74797_a((File)saveFile);
                    CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.load", args[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CommandChatHandler.sendFormattedChat(sender, TextFormatting.RED, "pixelmon.command.snapshot.errorread", args[1]);
                    return;
                }
            }
            if (args[0].equals("place")) {
                this.place(server, sender, player, world);
            } else if (args[0].equals("convert")) {
                String baseDirectory = Pixelmon.modDirectory + "/snapshots/";
                String baseFile = baseDirectory + args[1];
                String filename = baseFile + ".snapshot";
                File saveFile = new File(filename);
                try {
                    testCompound = CompressedStreamTools.func_74797_a((File)saveFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CommandChatHandler.sendFormattedChat(sender, TextFormatting.RED, "pixelmon.command.snapshot.errorread", args[1]);
                    return;
                }
                int width = testCompound.func_74762_e("Width");
                int height = testCompound.func_74762_e("Height");
                int length = testCompound.func_74762_e("Length");
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        for (int z = 0; z < length; ++z) {
                            NBTTagCompound tag = (NBTTagCompound)testCompound.func_74781_a("X" + x + "Y" + y + "Z" + z);
                            if (!tag.func_74764_b("blockMod") || !tag.func_74779_i("blockMod").equals("pixelmon")) continue;
                            String blockName = "pixelmon:" + tag.func_74779_i("blockName");
                            Block newBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
                            if (newBlock == null) {
                                if (blockName.endsWith("Block")) {
                                    blockName = blockName.substring(0, blockName.length() - 5).toLowerCase().replace("_", "");
                                }
                                newBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName.toLowerCase()));
                            }
                            if (newBlock == null) {
                                newBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName.toLowerCase().replace(":tile.", ":").replace(":item.", ":").replace("_", "")));
                            }
                            if (newBlock == null) continue;
                            blockName = newBlock.func_149739_a();
                            tag.func_74778_a("blockName", newBlock.getRegistryName().func_110623_a());
                            testCompound.func_74782_a("X" + x + "Y" + y + "Z" + z, (NBTBase)tag);
                        }
                    }
                }
                filename = baseFile + "-converted.snapshot";
                saveFile = new File(filename);
                File saveDirPath = new File(baseDirectory);
                if (!saveDirPath.exists()) {
                    saveDirPath.mkdirs();
                }
                try {
                    FileOutputStream f = new FileOutputStream(saveFile);
                    DataOutputStream s = new DataOutputStream(f);
                    CompressedStreamTools.func_74800_a((NBTTagCompound)testCompound, (DataOutput)s);
                    s.close();
                    f.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CommandChatHandler.sendFormattedChat(sender, TextFormatting.GREEN, "pixelmon.command.snapshot.convert", args[1]);
            } else {
                CommandChatHandler.sendChat(sender, this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void place(MinecraftServer server, ICommandSender sender, EntityPlayer player, World world) {
        BlockPos newPos;
        PixelBlockSnapshot snapshot;
        NBTTagCompound blockTag;
        int z;
        int y;
        int x;
        if (testCompound == null) {
            CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.nosave", new Object[0]);
            return;
        }
        int width = testCompound.func_74762_e("Width");
        int height = testCompound.func_74762_e("Height");
        int length = testCompound.func_74762_e("Length");
        BlockPos basePos = player.func_180425_c();
        int rotation = (int)Math.abs(player.func_70079_am()) % 360;
        EnumFacing facing = rotation < 45 ? EnumFacing.NORTH : (rotation < 135 ? EnumFacing.EAST : (rotation < 225 ? EnumFacing.SOUTH : (rotation < 315 ? EnumFacing.WEST : EnumFacing.NORTH)));
        ArrayList<BlockPos> multiblocks = new ArrayList<BlockPos>();
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    blockTag = (NBTTagCompound)testCompound.func_74781_a("X" + x + "Y" + y + "Z" + z);
                    snapshot = PixelBlockSnapshot.readFromNBT(world, blockTag);
                    if (snapshot.getReplacedBlock().func_185904_a() == Material.field_151594_q || snapshot.getReplacedBlock().func_177230_c() instanceof BlockDoublePlant) continue;
                    newPos = this.getPos(x, y, z, basePos, facing);
                    snapshot.restoreToLocationWithRotation(newPos, facing);
                    if (!(world.func_180495_p(newPos).func_177230_c() instanceof MultiBlock)) continue;
                    multiblocks.add(newPos);
                }
            }
        }
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    blockTag = (NBTTagCompound)testCompound.func_74781_a("X" + x + "Y" + y + "Z" + z);
                    snapshot = PixelBlockSnapshot.readFromNBT(world, blockTag);
                    if (snapshot.getReplacedBlock().func_185904_a() == Material.field_151594_q) {
                        newPos = this.getPos(x, y, z, basePos, facing);
                        snapshot.restoreToLocationWithRotation(newPos, facing);
                        if (world.func_180495_p(newPos).func_177230_c() instanceof MultiBlock) {
                            multiblocks.add(newPos);
                        }
                        if (!(world.func_180495_p(newPos).func_177230_c() instanceof BlockRedstoneLight)) continue;
                    }
                    if (y + 1 >= height) continue;
                    PixelBlockSnapshot nextSnapshot = PixelBlockSnapshot.readFromNBT(world, blockTag);
                    if (!(snapshot.getReplacedBlock().func_177230_c() instanceof BlockDoublePlant) || !(nextSnapshot.getReplacedBlock().func_177230_c() instanceof BlockDoublePlant)) continue;
                    BlockPos newPos2 = this.getPos(x, y, z, basePos, facing);
                    snapshot.restoreToLocationWithRotation(newPos2, facing);
                }
            }
        }
        for (BlockPos newPos3 : multiblocks) {
            IBlockState state = world.func_180495_p(newPos3);
            Block block = state.func_177230_c();
            EnumFacing blockRot = (EnumFacing)state.func_177229_b((IProperty)MultiBlock.FACING);
            PixelmonItemBlock.setMultiBlocksWidth(newPos3, blockRot, world, (MultiBlock)block, block, player);
        }
        int numStatues = testCompound.func_74762_e("numStatues");
        if (numStatues > 0) {
            float baseX = testCompound.func_74762_e("baseX");
            float baseY = testCompound.func_74762_e("baseY");
            float baseZ = testCompound.func_74762_e("baseZ");
            for (int i = 0; i < numStatues; ++i) {
                NBTTagCompound statueTag = testCompound.func_74775_l("statue" + i);
                EntityStatue statue = new EntityStatue(world);
                statue.func_70020_e(statueTag);
                double posX = statue.field_70165_t - (double)baseX;
                double posY = statue.field_70163_u - (double)baseY;
                double posZ = statue.field_70161_v - (double)baseZ;
                double x2 = 0.0;
                double y2 = 0.0;
                double z2 = 0.0;
                if (facing == EnumFacing.EAST) {
                    x2 = posX + (double)basePos.func_177958_n();
                    y2 = posY + (double)basePos.func_177956_o();
                    z2 = posZ + (double)basePos.func_177952_p();
                } else if (facing == EnumFacing.SOUTH) {
                    x2 = -1.0 * posZ + 1.0 + (double)basePos.func_177958_n();
                    y2 = posY + (double)basePos.func_177956_o();
                    z2 = posX + (double)basePos.func_177952_p();
                } else if (facing == EnumFacing.WEST) {
                    x2 = -1.0 * posX + 1.0 + (double)basePos.func_177958_n();
                    y2 = posY + (double)basePos.func_177956_o();
                    z2 = -1.0 * posZ + 1.0 + (double)basePos.func_177952_p();
                } else if (facing == EnumFacing.NORTH) {
                    x2 = posZ + (double)basePos.func_177958_n();
                    y2 = posY + (double)basePos.func_177956_o();
                    z2 = -1.0 * posX + 1.0 + (double)basePos.func_177952_p();
                }
                if (facing != EnumFacing.EAST) {
                    if (facing == EnumFacing.WEST) {
                        statue.setRotation(statue.getRotation() + 180.0f);
                    } else if (facing == EnumFacing.NORTH) {
                        statue.setRotation(statue.getRotation() - 90.0f);
                    } else if (facing == EnumFacing.SOUTH) {
                        statue.setRotation(statue.getRotation() + 90.0f);
                    }
                    statue.field_70126_B = statue.field_70177_z;
                }
                statue.func_70107_b(x2, y2, z2);
                statue.func_184221_a(UUID.randomUUID());
                world.func_72838_d((Entity)statue);
            }
        }
        CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.place", new Object[0]);
    }

    private BlockPos getPos(int x, int y, int z, BlockPos basePos, EnumFacing facing) {
        if (facing == EnumFacing.EAST) {
            return new BlockPos(x + basePos.func_177958_n(), y + basePos.func_177956_o(), z + basePos.func_177952_p());
        }
        if (facing == EnumFacing.SOUTH) {
            return new BlockPos(-1 * z + basePos.func_177958_n(), y + basePos.func_177956_o(), x + basePos.func_177952_p());
        }
        if (facing == EnumFacing.WEST) {
            return new BlockPos(-1 * x + basePos.func_177958_n(), y + basePos.func_177956_o(), -1 * z + basePos.func_177952_p());
        }
        if (facing == EnumFacing.NORTH) {
            return new BlockPos(z + basePos.func_177958_n(), y + basePos.func_177956_o(), -1 * x + basePos.func_177952_p());
        }
        return null;
    }
}

