/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICalculateSpawnLocations;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class CheckSpawns
extends PixelmonCommand {
    public CheckSpawns() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "checkspawns";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/checkspawns [specific] [pokemon...]";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    protected void execute(ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.needtobeplayer", new Object[0]);
        } else if (PixelmonSpawning.coordinator == null || !PixelmonSpawning.coordinator.getActive()) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.checkspawns.betterspawningisoff", new Object[0]);
        } else {
            float adjusted;
            boolean regional = args.length == 0 || !args[0].equals("specific");
            ArrayList<String> specificPokemon = new ArrayList<String>();
            if (args.length > 0) {
                for (String arg : args) {
                    if (!EnumPokemon.hasPokemonAnyCase(arg)) continue;
                    specificPokemon.add(I18n.func_74838_a((String)("pixelmon." + EnumPokemon.getFromNameAnyCase((String)arg).name.toLowerCase() + ".name")));
                }
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            PlayerTrackingSpawner spawner = null;
            for (AbstractSpawner abstractSpawner : PixelmonSpawning.coordinator.spawners) {
                if (!(abstractSpawner instanceof PlayerTrackingSpawner) || !((PlayerTrackingSpawner)abstractSpawner).playerUUID.equals(player.func_110124_au())) continue;
                spawner = (PlayerTrackingSpawner)abstractSpawner;
                break;
            }
            if (spawner == null) {
                this.sendMessage(sender, TextFormatting.RED, "Error finding associated player tracking spawner.", new Object[0]);
                return;
            }
            BlockPos pos = player.func_180425_c();
            BlockCollection collection = new BlockCollection((World)player.func_71121_q(), pos.func_177958_n() - spawner.horizontalSliceRadius, pos.func_177958_n() + spawner.horizontalSliceRadius, pos.func_177956_o() - spawner.verticalSliceRadius, pos.func_177956_o() + spawner.verticalSliceRadius, pos.func_177952_p() - spawner.horizontalSliceRadius, pos.func_177952_p() + spawner.horizontalSliceRadius);
            ICalculateSpawnLocations calculator = spawner.spawnLocationCalculator;
            ArrayList<SpawnInfo> possibleSpawns = new ArrayList<SpawnInfo>();
            float raritySum = 0.0f;
            HashMap<SpawnInfo, Float> adjustedRarities = new HashMap<SpawnInfo, Float>();
            ArrayList<SpawnLocation> spawnLocations = calculator.calculateSpawnableLocations(collection);
            for (SpawnLocation spawnLocation : spawnLocations) {
                if (!spawnLocation.location.pos.equals((Object)pos) && !regional) continue;
                ArrayList<SpawnInfo> blockPossibleSpawns = spawner.getSuitableSpawns(spawnLocation);
                for (SpawnInfo spawnInfo : blockPossibleSpawns) {
                    adjusted = spawnInfo.getAdjustedRarity(spawnLocation);
                    raritySum += adjusted;
                    if (adjustedRarities.containsKey(spawnInfo)) {
                        adjusted += ((Float)adjustedRarities.get(spawnInfo)).floatValue();
                    }
                    adjustedRarities.put(spawnInfo, Float.valueOf(adjusted));
                    if (possibleSpawns.contains(spawnInfo)) continue;
                    possibleSpawns.add(spawnInfo);
                }
            }
            DecimalFormat df = new DecimalFormat(".####");
            DecimalFormat df2 = new DecimalFormat(".##");
            HashMap<String, Double> percentages = new HashMap<String, Double>();
            for (SpawnInfo spawnInfo : possibleSpawns) {
                String label;
                adjusted = ((Float)adjustedRarities.get(spawnInfo)).floatValue() * 100.0f;
                double percentage = (double)(adjusted / raritySum) + (percentages.containsKey(label = spawnInfo.toString()) ? (Double)percentages.get(label) : 0.0);
                if (percentage < 0.01 || percentage > 99.99) {
                    percentages.put(label, Double.parseDouble(df.format(percentage)));
                    continue;
                }
                percentages.put(label, Double.parseDouble(df2.format(percentage)));
            }
            double greenThreshold = 10.0;
            double yellowThreshold = 2.0;
            double redThreshold = 0.5;
            double lightPurpleThreshold = 0.001;
            ArrayList sortedEntries = new ArrayList(percentages.entrySet());
            sortedEntries.sort(new Comparator<Map.Entry<String, Double>>(){

                @Override
                public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            if (regional) {
                this.sendMessage(sender, TextFormatting.AQUA, "pixelmon.command.checkspawns.spawns.inthisarea", sortedEntries.isEmpty() ? TextFormatting.RED + "0" : "");
            } else {
                this.sendMessage(sender, TextFormatting.AQUA, "pixelmon.command.checkspawns.spawns.atthisposition", sortedEntries.isEmpty() ? TextFormatting.RED + "0" : "");
            }
            ArrayList<String> messages = new ArrayList<String>();
            for (Map.Entry entry : sortedEntries) {
                if (!specificPokemon.isEmpty() && !specificPokemon.contains(entry.getKey())) continue;
                TextFormatting colour = TextFormatting.DARK_PURPLE;
                if ((Double)entry.getValue() > 10.0) {
                    colour = TextFormatting.GREEN;
                } else if ((Double)entry.getValue() > 2.0) {
                    colour = TextFormatting.YELLOW;
                } else if ((Double)entry.getValue() > 0.5) {
                    colour = TextFormatting.RED;
                } else if ((Double)entry.getValue() > 0.001) {
                    colour = TextFormatting.LIGHT_PURPLE;
                }
                messages.add(TextFormatting.GOLD + (String)entry.getKey() + TextFormatting.GRAY + ": " + colour + String.valueOf(entry.getValue()) + "%");
            }
            while (!messages.isEmpty()) {
                String message = (String)messages.remove(0);
                int onThisLine = 1;
                while (!messages.isEmpty() && onThisLine++ < 3) {
                    message = message + TextFormatting.GOLD + ", " + (String)messages.remove(0);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(message));
            }
        }
    }
}

