/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.conditions.WorldTime;
import com.pixelmonmod.pixelmon.api.spawning.util.SetLoader;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.debug.DebugHelper;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.biome.Biome;

public class Debug
extends PixelmonCommand {
    public Debug() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "pixeldebug";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pixeldebug [lang/effect/camera/fov/reloadmodels/itemsprite/render/collection/spawns]";
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        block21: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    if (args.length == 0) {
                                                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
                                                    }
                                                    if (!args[0].equalsIgnoreCase("lang")) break block22;
                                                    DebugHelper.langCheck((EntityPlayer)sender);
                                                    break block21;
                                                }
                                                if (!args[0].equalsIgnoreCase("effect")) break block23;
                                                DebugHelper.effectRegistryCheck();
                                                break block21;
                                            }
                                            if (args[0].equalsIgnoreCase("camera")) break block21;
                                            if (!args[0].equalsIgnoreCase("fov")) break block24;
                                            Minecraft.func_71410_x().field_71474_y.field_74334_X = Integer.parseInt(args[1]);
                                            break block21;
                                        }
                                        if (!args[0].equalsIgnoreCase("reloadmodels")) break block25;
                                        try {
                                            Method m = PixelmonModelRegistry.class.getDeclaredMethod("init", new Class[0]);
                                            m.setAccessible(true);
                                            m.invoke(null, new Object[0]);
                                        }
                                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                                            e2.printStackTrace();
                                        }
                                        GenericSmdModel.loadedModels.forEach(GenericSmdModel::reloadModel);
                                        break block21;
                                    }
                                    if (!args[0].equalsIgnoreCase("itemsprite")) break block26;
                                    ItemStack stack = new ItemStack(PixelmonItems.itemPixelmonSprite);
                                    NBTTagCompound tagCompound = new NBTTagCompound();
                                    tagCompound.func_74778_a("SpriteName", args[1]);
                                    stack.func_77982_d(tagCompound);
                                    ((EntityPlayerMP)sender).field_71071_by.func_70441_a(stack);
                                    break block21;
                                }
                                if (!args[0].equalsIgnoreCase("render")) break block27;
                                Minecraft.func_71410_x().field_71474_y.field_151451_c = 1000;
                                break block21;
                            }
                            if (!args[0].equalsIgnoreCase("collection")) break block28;
                            EntityPlayerMP player = (EntityPlayerMP)sender;
                            int n = Integer.parseInt(args[1]);
                            int radius = Integer.parseInt(args[2]);
                            long tic = System.currentTimeMillis();
                            for (int i = 0; i < n; ++i) {
                                new BlockCollection(player.field_70170_p, (int)player.field_70165_t - radius, (int)player.field_70165_t + radius, (int)player.field_70163_u - radius, (int)player.field_70163_u + radius, (int)player.field_70161_v - radius, (int)player.field_70161_v + radius);
                            }
                            long toc = System.currentTimeMillis();
                            this.sendMessage(sender, "Time to process " + n + " collections of radius " + radius + " (" + n * 8 * radius * radius * radius + " blocks): " + (toc - tic) + " milliseconds.", new Object[0]);
                            break block21;
                        }
                        if (!args[0].equalsIgnoreCase("model-scale")) break block29;
                        if (args.length != 3) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /pixeldebug model-scale <pokemon:form> <scale>"));
                        } else {
                            try {
                                String name = args[1];
                                int form = -1;
                                if (args[1].contains(":")) {
                                    name = args[1].split(":")[0];
                                    form = Debug.func_175755_a((String)args[1].split(":")[1]);
                                }
                                EnumPokemon pokemon = EnumPokemon.valueOf(name);
                                double scale = Debug.func_175765_c((String)args[2]);
                                PixelmonModelBase model = (PixelmonModelBase)PixelmonModelRegistry.getModel(pokemon, pokemon.getFormEnum(form));
                                if (model instanceof PixelmonModelSmd) {
                                    ValveStudioModel valve = ((PixelmonModelSmd)model).theModel;
                                    Field field = ValveStudioModel.class.getDeclaredField("scale");
                                    field.setAccessible(true);
                                    field.setFloat(valve, (float)scale);
                                    sender.func_145747_a((ITextComponent)new TextComponentString("scale changed. This does not effect pokemon already spawned in the world."));
                                    break block21;
                                }
                                sender.func_145747_a((ITextComponent)new TextComponentString("That model is not smd!"));
                            }
                            catch (IllegalArgumentException e3) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("No model by that name found!"));
                            }
                            catch (IllegalAccessException | NoSuchFieldException e4) {
                                e4.printStackTrace();
                            }
                        }
                        break block21;
                    }
                    if (!args[0].equals("dialogue")) break block30;
                    ArrayList<Dialogue> dialogues = new ArrayList<Dialogue>();
                    dialogues.add(Dialogue.builder().setName("Gus").setText("Hello, friend").addChoice(Choice.builder().setText("Hello, Gus").setHandle(e -> e.reply(Dialogue.builder().setName("Gus").setText("Enjoy your day!").build())).build()).addChoice(Choice.builder().setText("You are everything wrong with the world.").setHandle(e -> e.reply(Dialogue.builder().setName("Gus").setText("Wow, ok then.").build())).build()).build());
                    Dialogue.setPlayerDialogueData((EntityPlayerMP)sender, dialogues, true);
                    break block21;
                }
                if (!args[0].equalsIgnoreCase("spawns")) break block31;
                for (EnumPokemon pokemon : EnumPokemon.values()) {
                    SpawnSet set = SetLoader.getDefaultSpawnSetFor(pokemon);
                    if (set == null) continue;
                    set.export("exportDir");
                }
                break block21;
            }
            if (!args[0].equalsIgnoreCase("spawnwiki")) break block21;
            Function<String, String> raiseFirstCap = s -> s.toUpperCase().charAt(0) + s.substring(1).toLowerCase();
            BiFunction<ArrayList, Boolean, String> listToString = (list, cap) -> {
                if (list.isEmpty()) {
                    return "";
                }
                String str = cap != false ? (String)raiseFirstCap.apply(list.get(0).toString()) : list.get(0).toString();
                for (int i = 1; i < list.size(); ++i) {
                    str = str + ", " + (cap != false ? (String)raiseFirstCap.apply(list.get(i).toString()) : list.get(i).toString());
                }
                return str + "\n";
            };
            File file = new File("wikidata.txt");
            try {
                file.createNewFile();
                PrintWriter pw = new PrintWriter(file);
                for (EnumPokemon pokemon : EnumPokemon.values()) {
                    SpawnSet set = (SpawnSet)SetLoader.getSet(pokemon.name);
                    if (set == null) {
                        System.out.println("Empty: " + pokemon.name);
                        continue;
                    }
                    String wikiBit = "|'''#" + pokemon.getNationalPokedexNumber() + "'''\n";
                    wikiBit = wikiBit + "|" + pokemon.name + "\n";
                    ArrayList<LocationType> locations = new ArrayList<LocationType>();
                    ArrayList<String> biomes = new ArrayList<String>();
                    ArrayList<WorldTime> times = new ArrayList<WorldTime>();
                    ArrayList<WeatherType> weathers = new ArrayList<WeatherType>();
                    for (SpawnInfo info : set.spawnInfos) {
                        for (LocationType location : info.locationTypes) {
                            if (locations.contains(location)) continue;
                            locations.add(location);
                        }
                        for (Biome biome : info.condition.biomes) {
                            PixelmonBiomeDictionary.PixelmonBiomeInfo biomeInfo = PixelmonBiomeDictionary.getBiomeInfo(biome);
                            if (biomes.contains(biomeInfo.biomeEnglishName)) continue;
                            biomes.add(biomeInfo.biomeEnglishName);
                        }
                        for (WorldTime time : info.condition.times) {
                            if (times.contains((Object)time)) continue;
                            times.add(time);
                        }
                        for (WeatherType weather : info.condition.weathers) {
                            if (weathers.contains((Object)weather)) continue;
                            weathers.add(weather);
                        }
                    }
                    String locString = listToString.apply(locations, true);
                    if (locString.equals("")) continue;
                    wikiBit = wikiBit + "|" + locString;
                    String biomeString = listToString.apply(biomes, false);
                    if (biomeString.equals("")) continue;
                    wikiBit = wikiBit + "|" + biomeString;
                    String timeString = listToString.apply(times, true);
                    if (timeString.equals("")) continue;
                    wikiBit = wikiBit + "|" + timeString;
                    String weatherString = listToString.apply(weathers, true);
                    if (weatherString.equals("")) continue;
                    wikiBit = wikiBit + "|" + weatherString;
                    wikiBit = wikiBit + "|-\n";
                    pw.write(wikiBit);
                }
                pw.flush();
                pw.close();
                System.out.println("Done");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

