/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.deepstorage.DeepStorage;
import com.pixelmonmod.pixelmon.storage.deepstorage.DeepStorageManager;
import java.util.ArrayList;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class DeepStorageCmd
extends PixelmonCommand {
    public DeepStorageCmd() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "deepstorage";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/deepstorage <collect | view [player]>";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.sendMessage(sender, "Not enough arguments. " + this.func_71518_a(sender), new Object[0]);
            return;
        }
        if (args[0].toLowerCase().equals("collect")) {
            if (!(sender instanceof EntityPlayerMP)) {
                this.sendMessage(sender, "You have to be a player to collect deep storage Pok\u00e9mon. How else would you have any.", new Object[0]);
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (!DeepStorageManager.hasPokemonInDeepStorage(player.func_110124_au())) {
                this.sendMessage(sender, "You don't have any Pok\u00e9mon in deep storage.", new Object[0]);
                return;
            }
            DeepStorage deepStorage = DeepStorageManager.getOrCreateDeepStorage(player.func_110124_au());
            if (deepStorage == null) {
                this.sendMessage(sender, "An unknown problem was encountered while trying to retrieve deep storage.", new Object[0]);
                return;
            }
            PlayerComputerStorage pc = PixelmonStorage.computerManager.getPlayerStorage(player);
            if (pc == null) {
                this.sendMessage(sender, "An unknown problem was encountered loading regular PC storage. Try again.", new Object[0]);
                return;
            }
            ArrayList<NBTTagCompound> retrieved = deepStorage.tryRetrieve();
            ArrayList restored = new ArrayList();
            retrieved.removeIf(nbt -> {
                if (pc.addToComputer((NBTTagCompound)nbt)) {
                    return restored.add(nbt);
                }
                return false;
            });
            if (!retrieved.isEmpty()) {
                this.sendMessage(sender, retrieved.size() + " were unable to be added to the PC due to lack of space. Make room and try again.", new Object[0]);
                retrieved.removeAll(restored);
                for (NBTTagCompound nbt2 : retrieved) {
                    deepStorage.put(nbt2);
                }
            }
            DeepStorageManager.save(player.func_110124_au());
            this.sendMessage(sender, TextFormatting.DARK_GREEN, "Successfully restored " + restored.size() + " Pok\u00e9mon from deep storage!", new Object[0]);
            return;
        }
        if (!args[0].toLowerCase().equals("view")) {
            this.sendMessage(sender, "Unknown argument: " + args[0] + ". " + this.func_71518_a(sender), new Object[0]);
            return;
        }
        if (args.length == 1 && !(sender instanceof EntityPlayerMP)) {
            this.sendMessage(sender, "To view a deep storage, you need to specify a player or be a player.", new Object[0]);
            this.sendMessage(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayerMP player = null;
        if (sender instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)sender;
        }
        if (args.length > 1 && (player = this.getPlayer(args[1])) == null) {
            this.sendMessage(sender, "Unknown player: " + args[1], new Object[0]);
            return;
        }
        if (!DeepStorageManager.hasPokemonInDeepStorage(player.func_110124_au())) {
            this.sendMessage(sender, "No Pok\u00e9mon in deep storage for " + player.func_70005_c_(), new Object[0]);
            return;
        }
        DeepStorage deepStorage = DeepStorageManager.getOrCreateDeepStorage(player.func_110124_au());
        ImmutableList<NBTTagCompound> list = deepStorage.getArchivedPokemon();
        String message = "";
        if (list.isEmpty()) {
            message = "No Pok\u00e9mon in deep storage for " + player.func_70005_c_();
            DeepStorageManager.save(player.func_110124_au());
        } else {
            for (NBTTagCompound nbt3 : list) {
                message = EnumPokemon.hasPokemonAnyCase(nbt3.func_74779_i("Name")) ? message + TextFormatting.DARK_GREEN : message + TextFormatting.GRAY;
                message = message + nbt3.func_74779_i("Name") + TextFormatting.WHITE + ", ";
            }
            message = message.substring(0, message.length() - 2);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }
}

