/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.events.SpectateEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectate;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartSpectate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Spectate
extends PixelmonCommand {
    public Spectate() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "spectate";
    }

    public String func_71518_a(ICommandSender arg0) {
        return "/spectate <playerName>";
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (args.length == 0) {
            if (!BattleRegistry.removeSpectator(player)) {
                this.sendMessage(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
            }
            Pixelmon.network.sendTo((IMessage)new EndSpectate(), player);
        } else if (args.length == 1) {
            BattleControllerBase base;
            EntityPlayerMP target = this.getPlayer(args[0]);
            if (target == null || target.func_145748_c_().equals(sender.func_145748_c_())) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.spectate.self", new Object[0]);
                return;
            }
            if (!BattleRegistry.hasBattle()) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.spectate.nobattle", target.getDisplayNameString());
                return;
            }
            if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.inbattle", new Object[0]);
            }
            if ((base = BattleRegistry.getBattle((EntityPlayer)target)) == null) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.spectate.nobattle", target.getDisplayNameString());
            } else {
                PlayerParticipant watchedPlayer = base.getPlayer(target.func_70005_c_());
                if (watchedPlayer != null && !Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StartSpectate(player, base, target))) {
                    Pixelmon.network.sendTo((IMessage)new StartSpectate(watchedPlayer.player.func_110124_au(), base.rules.battleType), player);
                    Pixelmon.network.sendTo((IMessage)new StartBattle(base.battleIndex, base.getBattleType(watchedPlayer), base.rules), player);
                    ArrayList<PixelmonWrapper> teamList = watchedPlayer.getTeamPokemonList();
                    Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(teamList), player);
                    Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(PixelmonInGui.convertToGUI(teamList), false), player);
                    Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(watchedPlayer.getOpponentData(), true), player);
                    if (base.getTeam(watchedPlayer).size() > 1) {
                        Pixelmon.network.sendTo((IMessage)new SetPokemonTeamData(watchedPlayer.getAllyData()), player);
                    }
                    base.addSpectator(new Spectator(player, target.func_70005_c_()));
                }
            }
        } else {
            this.sendMessage(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? this.tabCompleteUsernames(args) : Collections.emptyList();
    }
}

