/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Teach
extends PixelmonCommand {
    public Teach() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "teach";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/teach <player> <slot> <move>";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        block26: {
            if (args.length < 1) {
                CommandChatHandler.sendFormattedChat(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
            } else if (args.length == 1) {
                this.execute(sender, new String[]{sender.func_70005_c_(), "1", args[0]});
            } else if (args.length == 2) {
                this.execute(sender, new String[]{sender.func_70005_c_(), args[0], args[1]});
            } else if (args.length >= 3) {
                try {
                    EntityPlayerMP player = this.getPlayer(args[0]);
                    if (player == null) {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalidplayer", new Object[0]);
                        return;
                    }
                    String playerName = player.getDisplayNameString();
                    if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.inbattle", new Object[0]);
                        return;
                    }
                    PlayerStorage storage = this.getPlayerStorage(player);
                    if (storage != null) {
                        Attack a;
                        String attackName;
                        NBTTagCompound nbt;
                        block25: {
                            int slot = Integer.parseInt(RegexPatterns.LETTERS.matcher(args[1]).replaceAll(""));
                            if (storage.guiOpened) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.teach.busy", playerName);
                                return;
                            }
                            if (slot < 1 || slot > 6) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.teach.slot", new Object[0]);
                                return;
                            }
                            nbt = storage.getList()[slot - 1];
                            if (nbt == null) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.teach.nothing", playerName);
                                return;
                            }
                            attackName = args[2];
                            for (int i = 3; i < args.length; ++i) {
                                attackName = attackName + ' ' + args[i];
                            }
                            attackName = attackName.replace('_', ' ');
                            a = null;
                            try {
                                int attackIndex = Integer.parseInt(attackName);
                                if (Attack.hasAttack(attackIndex)) {
                                    a = new Attack(attackIndex);
                                }
                            }
                            catch (NumberFormatException e) {
                                if (!Attack.hasAttack(attackName)) break block25;
                                a = new Attack(attackName);
                            }
                        }
                        if (a == null) {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.teach.nomove", attackName);
                            return;
                        }
                        storage.recallAllPokemon();
                        EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt, player.field_70170_p);
                        if (!p.getMoveset().hasAttack(a)) {
                            if (p.getMoveset().size() >= 4) {
                                EntityPlayerMP playerOwner = (EntityPlayerMP)p.func_70902_q();
                                if (playerOwner == null) {
                                    playerOwner = player;
                                }
                                Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(p.getPokemonId(), a.baseAttack.attackIndex, 0, 0), playerOwner);
                                this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.teach.sentmove", playerName, p.getNickname(), a.baseAttack.getLocalizedName());
                            } else {
                                p.getMoveset().add(a);
                                p.update(EnumUpdateType.Moveset);
                                this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.stats.learnedmove", p.getNickname(), a.baseAttack.getLocalizedName());
                            }
                        } else {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.teach.knowsmove", playerName, p.getNickname(), a.baseAttack.getLocalizedName());
                        }
                        break block26;
                    }
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalidplayer", new Object[0]);
                }
                catch (NumberFormatException e) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                }
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return this.tabCompleteUsernames(args);
        }
        if (args.length == 2) {
            return Teach.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        return Collections.emptyList();
    }
}

