/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.reflect.TypeToken;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.EnumForceBattleResult;
import com.pixelmonmod.pixelmon.config.EnumPokelootModes;
import com.pixelmonmod.pixelmon.config.EnumPokelootRate;
import com.pixelmonmod.pixelmon.config.MigrationHandler;
import com.pixelmonmod.pixelmon.config.Node;
import com.pixelmonmod.pixelmon.customStarters.CustomStarters;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationOptions;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import info.pixelmon.repack.ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.text.translation.I18n;

public class PixelmonConfig {
    public static final int MILLI = 1000;
    public static final int SECONDS = 1;
    public static final int MINUTES = 60;
    public static final int HOURS = 3600;
    public static boolean isInMetric = true;
    @Node(category="General", nameOverride="awardPhotos")
    public static boolean awardTokens = false;
    @Node(category="General")
    public static boolean spawnStructures = true;
    @Node(category="General", nameOverride="allowPokemonNicknames")
    public static boolean allowNicknames = true;
    @Node(category="General", nameOverride="allowAnvilAutoreloading")
    public static boolean allowAnvilAutoloading = false;
    @Node(category="General", nameOverride="allowVanillaMobs")
    public static boolean allowNonPixelmonMobs = false;
    @Node(category="General", nameOverride="allowCaptureOutsideBattle")
    public static boolean allowCapturingOutsideBattle = true;
    @Node(category="General", nameOverride="namePlateRange", minValue=0.0)
    public static int nameplateRangeModifier = 1;
    @Node(category="General")
    public static boolean showWildNames = false;
    @Node(category="General", nameOverride="scalePokemonModels", minValue=0.0)
    public static boolean scaleModelsUp = true;
    @Node(category="General", nameOverride="growthScaleModifier", minValue=0.0, maxValue=2.0)
    public static double growthModifier = 1.0;
    @Node(category="General")
    public static boolean pokemonDropsEnabled = true;
    @Node(category="General")
    public static boolean printErrors = true;
    @Node(category="General")
    public static boolean allowRiding = true;
    @Node(category="General")
    public static boolean allowPlanting = true;
    @Node(category="General", minValue=0.0)
    public static int maximumPlants = 32;
    @Node(category="General", nameOverride="allowPvPExperience")
    public static boolean allowPVPExperience = true;
    @Node(category="General")
    public static boolean allowTrainerExperience = true;
    @Node(category="General")
    public static boolean returnHeldItems = true;
    @Node(category="General")
    public static EnumForceBattleResult forceEndBattleResult = EnumForceBattleResult.WINNER;
    @Node(category="General")
    public static boolean cloningMachineEnabled = true;
    @Node(category="General")
    public static int lakeTrioMaxEnchants = 3;
    @Node(category="General", nameOverride="engagePlayerByPokeBall")
    public static boolean pokeBallPlayerEngage = true;
    @Node(category="General", minValue=0.0, maxValue=256.0)
    public static int computerBoxes = 30;
    @Node(category="General", nameOverride="enableWildAggression")
    public static boolean isAggressionAllowed = true;
    @Node(category="General")
    public static boolean allowTMReuse = false;
    @Node(category="General")
    public static boolean writeEntitiesToWorld = false;
    @Node(category="General")
    public static boolean spawnBirdShrines = true;
    @Node(category="General")
    public static boolean reusableBirdShrines = false;
    @Node(category="General", nameOverride="spawnersOpOnly")
    public static boolean opToUseSpawners = true;
    @Node(category="General", nameOverride="needHMToRide")
    public static boolean haveHM = false;
    @Node(category="General", nameOverride="tradersReusable")
    public static boolean reuseTraders = false;
    @Node(category="General")
    public static boolean allowEventMoveTutors = false;
    @Node(category="General", nameOverride="starterOnJoin")
    public static boolean giveStarter = true;
    @Node(category="General")
    public static boolean enablePointToSteer = true;
    @Node(category="General", nameOverride="useSystemTimeForWorldTime")
    public static boolean useSystemWorldTime = false;
    @Node(category="General", nameOverride="systemTimeSyncInterval", minValue=2.0)
    public static int timeUpdateInterval = 30;
    @Node(category="General")
    public static boolean useExternalJSONFilesDrops = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesNPCs = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesRules = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesSpawning = false;
    @Node(category="General")
    public static boolean useExternalJSONFilesStructures = false;
    @Node(category="General")
    public static int chunkSpawnRadius = 6;
    @Node(category="General")
    public static EnumBattleAIMode battleAIWild = EnumBattleAIMode.Random;
    @Node(category="General")
    public static EnumBattleAIMode battleAIBoss = EnumBattleAIMode.Aggressive;
    @Node(category="General")
    public static EnumBattleAIMode battleAITrainer = EnumBattleAIMode.Tactical;
    @Node(category="General", minValue=0.0)
    public static float expModifier = 1.0f;
    @Node(category="General", nameOverride="multiplePhotosOfSamePokemon")
    public static boolean allowMultiplePhotosOfSamePokemon = true;
    @Node(category="General")
    public static boolean allowPayDayMoney = true;
    @Node(category="General")
    public static int pickupRate = 10;
    @Node(category="General")
    public static boolean bedsHealPokemon = true;
    @Node(category="General")
    public static boolean allowPokemonEditors = true;
    @Node(category="General")
    public static boolean dataSaveOnWorldSave = true;
    @Node(category="General")
    public static boolean useDropGUI = true;
    @Node(category="General", minValue=0.0, maxValue=1.0)
    public static float ridingSpeedMultiplier = 1.0f;
    @Node(category="General", minValue=0.10000000149011612, maxValue=1000.0)
    public static float berryTreeGrowthMultiplier = 1.0f;
    @Node(category="General", minValue=1.0)
    public static int maxLevel = 100;
    @Node(category="General", minValue=1.0)
    public static int despawnRadius = 80;
    @Node(category="General")
    public static boolean canPokemonBeHit = false;
    @Node(category="General")
    public static boolean alwaysHaveMegaRing = false;
    @Node(category="Spawning")
    public static int spawnTickRate = 60;
    @Node(category="Spawning", type=Integer.class)
    public static List<Integer> spawnDimensions = Collections.singletonList(0);
    @Node(category="Spawning", nameOverride="shinySpawnRate", minValue=0.0)
    public static float shinyRate = 4096.0f;
    @Node(category="Spawning", minValue=0.0)
    public static int bossSpawnTicks = 1200;
    @Node(category="Spawning", minValue=0.0)
    public static int legendarySpawnTicks = 3000;
    @Node(category="Spawning", minValue=0.0)
    public static int legendaryRepeatSpawnTicks = 96000;
    @Node(category="Spawning", minValue=0.0, maxValue=1.0)
    public static float legendarySpawnChance = 0.3f;
    @Node(category="Spawning")
    public static boolean spawnLevelsByDistance = false;
    @Node(category="Spawning")
    public static int maxLevelByDistance = 60;
    @Node(category="Spawning", minValue=0.0)
    public static int distancePerLevel = 30;
    @Node(category="Spawning", nameOverride="hiddenAbilitySpawnRate", minValue=0.0)
    public static int hiddenAbilityRate = 150;
    @Node(category="Spawning", nameOverride="allowLegendarySpawn")
    public static boolean allowLegendariesSpawn = true;
    @Node(category="Spawning", nameOverride="displayLegendaryGlobalMessage")
    public static boolean doLegendaryEvent = true;
    @Node(category="Spawning")
    public static boolean replaceMCVillagers = true;
    @Node(category="Spawning", nameOverride="spawnPokeMarts")
    public static boolean spawnPokemarts = true;
    @Node(category="Spawning")
    public static boolean increaseVillageSpawnRate = true;
    @Node(category="Spawning")
    public static boolean useRecentLevelMoves = false;
    @Node(category="Spawning")
    public static boolean spawnGyms = true;
    @Node(category="Spawning", minValue=0.0)
    public static int maxSpawnsPerTick = 100;
    @Node(category="Spawning", nameOverride="maxLandPokemon", minValue=0.0)
    public static int maxNumLandPokemon = 40;
    @Node(category="Spawning", nameOverride="maxUndergroundPokemon", minValue=0.0)
    public static int maxNumUndergroundPokemon = 20;
    @Node(category="Spawning", nameOverride="maxWaterPokemon", minValue=0.0)
    public static int maxNumWaterPokemon = 20;
    @Node(category="Spawning", nameOverride="maxFlyingPokemon", minValue=0.0)
    public static int maxNumAirPokemon = 2;
    @Node(category="Spawning", minValue=0.0)
    public static int maxNumNPCs = 4;
    @Node(category="Spawning", minValue=0.0)
    public static int maxNumBosses = 1;
    @Node(category="Spawning")
    public static boolean despawnOnFleeOrLoss = false;
    @Node(category="Better Spawning")
    public static boolean useBetaSpawner = true;
    @Node(category="Better Spawning")
    public static String spawnSetFolder = "default";
    @Node(category="Better Spawning")
    public static int entitiesPerPlayer = 45;
    @Node(category="Better Spawning")
    public static int spawnsPerPass = 2;
    @Node(category="Better Spawning")
    public static float spawnFrequency = 60.0f;
    @Node(category="Better Spawning")
    public static float minimumDistanceBetweenSpawns = 15.0f;
    @Node(category="Better Spawning")
    public static int minimumDistanceFromCentre = 18;
    @Node(category="Better Spawning")
    public static int maximumDistanceFromCentre = 64;
    @Node(category="Better Spawning")
    public static float horizontalTrackFactor = 80.0f;
    @Node(category="Better Spawning")
    public static float verticalTrackFactor = 0.0f;
    @Node(category="Better Spawning")
    public static int horizontalSliceRadius = 10;
    @Node(category="Better Spawning")
    public static int verticalSliceRadius = 25;
    @Node(category="Spawning.Gens")
    public static boolean Gen1 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen2 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen3 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen4 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen5 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen6 = true;
    @Node(category="Spawning.Gens")
    public static boolean Gen7 = true;
    @Node(category="PokeLoot")
    public static boolean spawnNormal = true;
    @Node(category="PokeLoot")
    public static boolean spawnHidden = true;
    @Node(category="PokeLoot")
    public static boolean spawnGrotto = true;
    @Node(category="PokeLoot")
    public static EnumPokelootRate spawnRate = EnumPokelootRate.NORMAL;
    @Node(category="PokeLoot")
    public static EnumPokelootModes spawnMode = EnumPokelootModes.FCFS;
    @Node(category="PokeLoot", nameOverride="timedLootReuseHours")
    public static int lootTime = 24;
    @Node(category="AFKHandler", nameOverride="enableAFKHandler")
    public static boolean afkHandlerOn = false;
    @Node(category="AFKHandler", nameOverride="afkActivateSeconds", minValue=0.0)
    public static int afkTimerActivateSeconds = 90;
    @Node(category="AFKHandler", nameOverride="afkHandlerTurnSeconds", minValue=0.0)
    public static int afkTimerTurnSeconds = 15;
    @Node(category="Graphics", minValue=0.0)
    public static double renderDistanceWeight = 2.0;
    @Node(category="Graphics", nameOverride="lowResTextures")
    public static boolean useLowResTextures = false;
    @Node(category="Graphics", nameOverride="useSmoothShadingOnPokeBalls")
    public static boolean enableSmoothPokeballShading = true;
    @Node(category="Graphics", nameOverride="useSmoothShadingOnPokemon")
    public static boolean enableSmoothPokemonShading = true;
    @Node(category="Graphics", nameOverride="useOriginalPokemonTexturesForStatues")
    public static boolean statuesUseOriginalPokemonTextures = true;
    @Node(category="Graphics", nameOverride="showCurrentAttackTarget")
    public static boolean showTarget = true;
    @Node(category="Graphics")
    public static boolean drawHealthBars = false;
    @Node(category="Graphics")
    public static boolean useBattleCamera = true;
    @Node(category="Graphics")
    public static boolean playerControlCamera = true;
    @Node(category="Breeding")
    public static boolean allowBreeding = true;
    @Node(category="Breeding")
    public static boolean allowDittoDittoBreeding = true;
    @Node(category="Breeding")
    public static boolean allowRandomBreedingEggsToBeLegendary = false;
    @Node(category="Breeding")
    public static boolean allowRandomSpawnedEggsToBeLegendary = false;
    @Node(category="Breeding")
    public static boolean useBreedingEnvironment = true;
    @Node(category="Breeding", nameOverride="breedingEnvironmentCheckSeconds")
    public static int breedingEnviromentCheckSeconds = 500;
    @Node(category="Breeding", minValue=0.0)
    public static int stepsPerEggCycle = 255;
    @Node(category="Breeding", nameOverride="numBreedingStages", minValue=0.0)
    public static int numBreedingLevels = 5;
    @Node(category="Breeding", minValue=20.0)
    public static int breedingTicks = 18000;
    @Node(category="Breeding")
    public static boolean allowRanchExpansion = true;
    @Node(category="PixelUtilities")
    public static boolean scaleGrassBattles = false;
    @Node(category="PixelUtilities")
    public static boolean blocksHaveLegendaries = false;
    @Node(category="PixelUtilities", nameOverride="pokeGiftReusable")
    public static boolean pokegiftMany = false;
    @Node(category="PixelUtilities", nameOverride="pokeGiftHaveEvents")
    public static boolean doPokegiftEvents = true;
    @Node(category="PixelUtilities", nameOverride="eventPokeGiftLoad")
    public static boolean isPokegiftEvent = false;
    @Node(category="PixelUtilities", nameOverride="eventHasLegendaries")
    public static boolean pokegiftEventLegendaries = false;
    @Node(category="PixelUtilities", nameOverride="eventHasShinies")
    public static boolean pokegiftEventShinies = false;
    @Node(category="PixelUtilities", nameOverride="eventMaxPokemon", minValue=0.0)
    public static int pokegiftEventMaxPokes = 1;
    @Node(category="PixelUtilities", nameOverride="eventShinyRate", minValue=0.0)
    public static int pokegiftEventShinyRate = 10;
    @Node(category="PixelUtilities", nameOverride="eventTime")
    public static String customPokegiftEventTime = "D/M";
    @Node(category="PixelUtilities", nameOverride="eventCoords", type=String.class)
    public static List<String> pokegiftEventCoords = Collections.singletonList("notConfigured");
    @Node(category="ExternalMoves")
    public static boolean allowExternalMoves = true;
    @Node(category="ExternalMoves")
    public static boolean allowDestructiveExternalMoves = true;
    @Node(category="Storage")
    public static boolean useAsyncSaving = false;
    @Node(category="Storage")
    public static int asyncInterval = 60;
    @Node(category="Database", nameOverride="saveToExternalDatabase")
    public static boolean saveToDatabase = false;
    @Node(category="Database")
    public static String connectionString = "jdbc:hd://";
    @Node(category="Elevator")
    public static int elevatorSearchRange = 10;
    public static boolean useBattleDimension = false;
    public static boolean allowWildPokemonFleeing = false;
    public static boolean useExternalBlockSpawnFiles = false;
    private static HoconConfigurationLoader configurationLoader;
    private static CommentedConfigurationNode mainNode;

    public static void init(File configFile) {
        configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
        try {
            PixelmonConfig.reload(true);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public static void reload(boolean loadFromDisk) throws IOException {
        if (loadFromDisk) {
            mainNode = (CommentedConfigurationNode)configurationLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
        }
        try {
            CustomStarters.loadConfig(mainNode);
        }
        catch (ObjectMappingException var15) {
            var15.printStackTrace();
        }
        String[] categories = new String[]{"General", "Spawning", "Spawning.Gens", "Better Spawning", "PokeLoot", "AFKHandler", "Graphics", "Breeding", "ExternalMoves", "Database", "PixelUtilities", "Elevator"};
        for (String category : categories) {
            CommentedConfigurationNode categoryNode = mainNode;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            categoryNode.setComment(I18n.func_74838_a((String)("pixelmon.config." + category.toLowerCase() + ".comment")));
        }
        for (Field field : PixelmonConfig.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Node.class) == null) continue;
            Node node = field.getAnnotation(Node.class);
            String category = node.category();
            String name = node.nameOverride().isEmpty() ? field.getName() : node.nameOverride();
            String comment = "pixelmon.config." + name + ".comment";
            CommentedConfigurationNode categoryNode = mainNode;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            CommentedConfigurationNode configNode = categoryNode.getNode(name);
            configNode.setComment(I18n.func_74838_a((String)comment));
            PixelmonConfig.set(field, configNode, node);
        }
        configurationLoader.save(mainNode);
        Pixelmon.LOGGER.info("Checking for migrations..");
        PixelmonConfig.checkMigrations(PixelmonConfig.getConfig());
    }

    private static void set(Field field, CommentedConfigurationNode configNode, Node node) {
        try {
            Class<?> type = field.getType();
            if (type == Boolean.TYPE) {
                boolean value = configNode.getBoolean(field.getBoolean(null));
                field.setBoolean(null, value);
            } else if (type == Integer.TYPE) {
                int value = configNode.getInt(field.getInt(null));
                value = (double)value < node.minValue() ? (int)node.minValue() : ((double)value > node.maxValue() ? (int)node.maxValue() : value);
                field.setInt(null, value);
            } else if (type == Float.TYPE) {
                float value = configNode.getFloat(field.getFloat(null));
                value = (double)value < node.minValue() ? (float)node.minValue() : ((double)value > node.maxValue() ? (float)node.maxValue() : value);
                field.setFloat(null, value);
            } else if (type == Double.TYPE) {
                double value = configNode.getDouble(field.getDouble(null));
                value = value < node.minValue() ? node.minValue() : (value > node.maxValue() ? node.maxValue() : value);
                field.setDouble(null, value);
            } else if (type == String.class) {
                String value = configNode.getString((String)field.get(null));
                field.set(null, value);
            } else if (type == List.class) {
                List value = configNode.getList(TypeToken.of(node.type()), (List)field.get(null));
                field.set(null, value);
            } else if (Enum.class.isAssignableFrom(type)) {
                field.set(null, type.getEnumConstants()[configNode.getInt(((Enum)field.get(null)).ordinal())]);
            } else {
                Pixelmon.LOGGER.error("Cannot read config value " + configNode.getKey());
            }
        }
        catch (ObjectMappingException | IllegalAccessException var7) {
            var7.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            configurationLoader.save(mainNode);
        }
        catch (IOException var1) {
            var1.printStackTrace();
        }
    }

    public static CommentedConfigurationNode getConfig() {
        return mainNode;
    }

    public static void disableEventLoading() {
        isPokegiftEvent = mainNode.getNode("PixelUtilities").getNode("eventPokeGiftLoad").setValue(false).getBoolean();
        PixelmonConfig.saveConfig();
    }

    public static double getGrowthModifier() {
        return growthModifier;
    }

    public static boolean isGenerationEnabled(int generation) {
        switch (generation) {
            case 1: {
                return Gen1;
            }
            case 2: {
                return Gen2;
            }
            case 3: {
                return Gen3;
            }
            case 4: {
                return Gen4;
            }
            case 5: {
                return Gen5;
            }
            case 6: {
                return Gen6;
            }
            case 7: {
                return Gen7;
            }
        }
        return false;
    }

    public static boolean allGenerationsDisabled() {
        return !Gen1 && !Gen2 && !Gen3 && !Gen4 && !Gen5 && !Gen6 && !Gen7;
    }

    public static boolean allGenerationsEnabled() {
        return Gen1 && Gen2 && Gen3 && Gen4 && Gen5 && Gen6 && Gen7;
    }

    public static void checkMigrations(CommentedConfigurationNode configNode) {
        if (configNode.hasMapChildren()) {
            for (CommentedConfigurationNode commentedConfigurationNode : configNode.getChildrenMap().values()) {
                PixelmonConfig.checkMigrations(commentedConfigurationNode);
            }
        }
        MigrationHandler.handleMigration(configNode);
    }
}

