/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.cosmetics;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.cosmetics.Cosmetic;
import com.pixelmonmod.pixelmon.cosmetics.CosmeticType;
import com.pixelmonmod.pixelmon.cosmetics.PlayerCosmetics;
import com.pixelmonmod.pixelmon.enums.EnumCustomModel;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;

public class CosmeticHandler {
    private static final ExecutorService executorService = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private HashMap<UUID, PlayerCosmetics> playerCosmetics = new HashMap();

    public void playerLogin(EntityPlayer player) {
        this.playerCosmetics.put(player.func_110124_au(), new PlayerCosmetics(player.func_110124_au()));
    }

    public void playerLogout(EntityPlayer player) {
        this.playerCosmetics.remove(player.func_110124_au());
    }

    public static void obtainCosmetics(UUID uuid, Consumer<Cosmetic[]> cosmeticConsumer) {
        if (uuid.version() == 3) {
            cosmeticConsumer.accept(new Cosmetic[0]);
            return;
        }
        executorService.submit(() -> {
            String[] elements;
            ArrayList<Cosmetic> cosmetics = new ArrayList<Cosmetic>();
            String response = null;
            try {
                String output;
                URL url = new URL("https://pixelmongenerations.com/cosmetics.php?uuid=" + RegexPatterns.DASH_SYMBOL.matcher(uuid.toString()).replaceAll(""));
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
                response = sb.toString();
            }
            catch (Exception e) {
                Pixelmon.LOGGER.info("Couldn't connect to Generations servers: " + e.getLocalizedMessage());
            }
            if (response == null || response.equalsIgnoreCase("") || response.isEmpty()) {
                cosmeticConsumer.accept(new Cosmetic[0]);
                return;
            }
            for (String element : elements = response.split(",")) {
                CosmeticType type = CosmeticType.getType(element.split(":")[0]);
                String customModel = null;
                String customTexture = null;
                if (element.contains(":")) {
                    String custom = element.split(":")[1];
                    if (custom.contains(";")) {
                        customModel = custom.split(";")[0];
                        customTexture = custom.split(";")[1];
                    } else {
                        customModel = EnumCustomModel.TrainerHat.name();
                        customTexture = custom;
                    }
                }
                if (type == null) continue;
                EnumCustomModel modelEnum = EnumCustomModel.getFromString(customModel);
                cosmetics.add(new Cosmetic(type, customTexture, modelEnum));
            }
            cosmeticConsumer.accept(cosmetics.toArray(new Cosmetic[cosmetics.size()]));
        });
    }

    public PlayerCosmetics getPlayerCosmetics(UUID uniqueID) {
        return this.playerCosmetics.get(uniqueID);
    }
}

