/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.cosmetics;

import com.pixelmonmod.pixelmon.cosmetics.Cosmetic;
import com.pixelmonmod.pixelmon.cosmetics.CosmeticHandler;
import com.pixelmonmod.pixelmon.cosmetics.CosmeticType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PlayerCosmetics {
    private final UUID uuid;
    private Cosmetic backCosmetic;
    private Cosmetic headCosmetic;
    private Cosmetic handCosmetic;
    private Cosmetic[] allCosmetics;

    public boolean hasCosmetic(Cosmetic cosmetic) {
        for (Cosmetic aCosmetic : this.allCosmetics) {
            if (!aCosmetic.equals(cosmetic)) continue;
            return true;
        }
        return false;
    }

    public List<Cosmetic> getCosmeticType(CosmeticType type) {
        ArrayList<Cosmetic> allType = new ArrayList<Cosmetic>();
        for (Cosmetic allCosmetic : this.allCosmetics) {
            if (allCosmetic.getType() != type) continue;
            allType.add(allCosmetic);
        }
        return allType;
    }

    public PlayerCosmetics(UUID uuid) {
        this.uuid = uuid;
        CosmeticHandler.obtainCosmetics(uuid, cosmetics -> {
            this.allCosmetics = cosmetics;
        });
    }

    public Cosmetic getActiveCosmetic(CosmeticType type) {
        switch (type) {
            case Head: {
                return this.headCosmetic;
            }
            case Back: {
                return this.backCosmetic;
            }
            case Hand: {
                return this.handCosmetic;
            }
        }
        return null;
    }

    public void setActiveCosmetic(Cosmetic cosmetic) {
        switch (cosmetic.getType()) {
            case Head: {
                this.headCosmetic = cosmetic;
                break;
            }
            case Back: {
                this.backCosmetic = cosmetic;
                break;
            }
            case Hand: {
                this.handCosmetic = cosmetic;
            }
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Cosmetic[] getAllCosmetics() {
        return this.allCosmetics;
    }

    public void reset(CosmeticType type) {
        switch (type) {
            case Head: {
                this.headCosmetic = null;
            }
            case Back: {
                this.backCosmetic = null;
            }
            case Hand: {
                this.handCosmetic = null;
            }
        }
    }
}

