/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.pokemon.LevelUpMovesEvent;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.AttackCategory;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DatabaseMoves {
    private static ArrayList<Attack> tutorMoveList;

    public static void initializeAllAttacks() {
        block3: {
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES");
                while (rs.next()) {
                    Attack.registerAttack(rs.getInt("MOVEID"), rs.getString("NAME"), rs);
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                e.printStackTrace();
            }
        }
    }

    public static Moveset getInitialMoves(PokemonLink pixelmon, int level) {
        ArrayList<Attack> attackList = DatabaseMoves.getMovesetUpToLevel(pixelmon.getBaseStats().baseFormID, level);
        while (attackList.size() > 4) {
            if (PixelmonConfig.useRecentLevelMoves) {
                attackList.remove(attackList.size() - 1);
                continue;
            }
            RandomHelper.removeRandomElementFromList(attackList);
        }
        if (attackList.isEmpty()) {
            attackList.add(DatabaseMoves.getAttack("Tackle"));
        }
        Moveset moveset = new Moveset(pixelmon);
        moveset.addAll(attackList);
        return moveset;
    }

    public static ArrayList<Attack> getMovesetUpToLevel(int id, int level) {
        return DatabaseMoves.getMovesetUpToLevel(id, level, true);
    }

    public static ArrayList<Attack> getMovesetUpToLevel(int id, int level, boolean removeDuplicates) {
        ArrayList<Attack> attackList = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select LEARNLEVEL, MOVEID from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "' order by LEARNLEVEL desc, LEVELSKILLID desc");
            while (rs.next()) {
                int learnLevel = rs.getInt("LEARNLEVEL");
                int moveID = rs.getInt("MOVEID");
                if (learnLevel > level) continue;
                attackList.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception e) {
            Pixelmon.LOGGER.info("Pixelmon ID =" + id + " has corrupted moves at level " + level + ".");
        }
        if (removeDuplicates) {
            for (int i = 0; i < attackList.size(); ++i) {
                for (int j = i + 1; j < attackList.size(); ++j) {
                    if (attackList.get((int)i).baseAttack.attackIndex != attackList.get((int)j).baseAttack.attackIndex) continue;
                    attackList.remove(j--);
                }
            }
        }
        return attackList;
    }

    public static boolean learnsAttackAtLevel(Entity6CanBattle pokemon, int level) {
        return !DatabaseMoves.getAttacksAtLevel(pokemon, level).isEmpty();
    }

    public static ArrayList<Attack> getAttacksAtLevel(Entity6CanBattle pokemon, int level) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            int id = pokemon.baseStats.id;
            ResultSet rs1 = stat.executeQuery("select MOVEID, LEARNLEVEL from PIXELMONLEVELSKILLS where PIXELMONID=" + id);
            boolean hadResults = false;
            while (rs1.next()) {
                hadResults = true;
                if (rs1.getInt("LEARNLEVEL") != level) continue;
                attacks.add(DatabaseMoves.getAttack(rs1.getInt("MOVEID")));
            }
            rs1.close();
            if (!hadResults) {
                ResultSet rs = stat.executeQuery("select MOVEID from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "' AND LEARNLEVEL='" + level + "'");
                while (rs.next()) {
                    int moveID = rs.getInt("MOVEID");
                    attacks.add(DatabaseMoves.getAttack(moveID));
                }
                rs.close();
            }
        }
        catch (Exception conn) {
            // empty catch block
        }
        LevelUpMovesEvent event = new LevelUpMovesEvent(pokemon, level, attacks);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.attacks;
    }

    public static ArrayList<Attack> getAllAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select MOVEID from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllTMHMAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select MOVEID from PIXELMONTMHMSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllTutorAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select MOVEID from PIXELMONTUTORSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllEggAttacks(Entity6CanBattle pokemon) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select MOVEID from PIXELMONEGGSKILLS where PIXELMONID='" + pokemon.baseStats.baseFormID + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                Attack attack = DatabaseMoves.getAttack(moveID);
                if (attack == null) continue;
                attacks.add(attack);
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllTMHMTutorAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        attacks.addAll(DatabaseMoves.getAllTMHMAttacks(id));
        attacks.addAll(DatabaseMoves.getAllTutorAttacks(id));
        return attacks;
    }

    public static Attack getAttack(String moveName) {
        Attack attack;
        block4: {
            if (Attack.hasAttack(moveName)) {
                return new Attack(moveName);
            }
            attack = null;
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES where NAME='" + moveName + "'");
                if (DatabaseHelper.hasResults(rs)) {
                    attack = new Attack(rs.getInt("MOVEID"), moveName, rs);
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block4;
                e.printStackTrace();
            }
        }
        return attack;
    }

    public static AttackBase getAttackBase(int attackIndex) {
        AttackBase baseAttack;
        block3: {
            baseAttack = null;
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES where MOVEID='" + attackIndex + "'");
                if (DatabaseHelper.hasResults(rs)) {
                    baseAttack = new AttackBase(attackIndex, rs.getString("NAME"), rs);
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                e.printStackTrace();
            }
        }
        return baseAttack;
    }

    public static int getAttackIndex(String moveName) {
        int attackIndex;
        block3: {
            attackIndex = -1;
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select MOVEID from MOVES where NAME='" + moveName + "'");
                if (DatabaseHelper.hasResults(rs)) {
                    attackIndex = rs.getInt("MOVEID");
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                e.printStackTrace();
            }
        }
        return attackIndex;
    }

    public static Attack getAttack(int moveIndex) {
        Attack attack;
        block4: {
            if (Attack.hasAttack(moveIndex)) {
                return new Attack(moveIndex);
            }
            attack = null;
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES where MOVEID='" + moveIndex + "'");
                if (DatabaseHelper.hasResults(rs)) {
                    attack = new Attack(moveIndex, rs.getString("NAME"), rs);
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block4;
                e.printStackTrace();
            }
        }
        return attack;
    }

    public static ArrayList<Attack> getAllTutorAttacks(boolean includeEvents) {
        if (tutorMoveList == null) {
            tutorMoveList = new ArrayList();
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                String query = "";
                query = "select MOVEID from MOVES where TUTORTYPE = 1";
                if (includeEvents) {
                    query = query + " OR TUTORTYPE = 2";
                }
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    int moveID = rs.getInt("MOVEID");
                    tutorMoveList.add(DatabaseMoves.getAttack(moveID));
                }
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tutorMoveList;
    }

    public static boolean CanLearnAttack(int id, String attackName) {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select MOVEID from MOVES where NAME='" + attackName + "'");
            if (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                rs.close();
                return DatabaseMoves.canLearnFromTable(stat, "PIXELMONLEVELSKILLS", id, moveID) || DatabaseMoves.canLearnFromTable(stat, "PIXELMONTMHMSKILLS", id, moveID) || DatabaseMoves.canLearnFromTable(stat, "PIXELMONEGGSKILLS", id, moveID) || DatabaseMoves.canLearnFromTable(stat, "PIXELMONTUTORSKILLS", id, moveID);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean canLearnFromTable(Statement stat, String table, int pokemonID, int moveID) throws SQLException {
        ResultSet skillsRS = stat.executeQuery("select PIXELMONID from " + table + " where PIXELMONID='" + pokemonID + "' AND MOVEID='" + moveID + "'");
        boolean canLearn = skillsRS.next();
        skillsRS.close();
        return canLearn;
    }

    public static AttackCategory[] getAttackCategories() {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from MOVECATEGORIES");
            ArrayList<AttackCategory> list = new ArrayList<AttackCategory>();
            while (rs.next()) {
                list.add(new AttackCategory(rs.getInt("MOVECATEGORYID"), rs.getString("NAME")));
            }
            rs.close();
            AttackCategory[] categories = new AttackCategory[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                categories[i] = (AttackCategory)list.get(i);
            }
            return categories;
        }
        catch (Exception e) {
            if (PixelmonConfig.printErrors) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

