/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.pokemon.BaseStatsLoadEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.database.DatabaseAbilities;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.database.EnumInfoMode;
import com.pixelmonmod.pixelmon.database.EvolutionInfo;
import com.pixelmonmod.pixelmon.database.ExperienceGroup;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Rarity;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.BiomeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.ChanceCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoRockCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.FriendshipCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.GenderCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.HeldItemCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.HighAltitudeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.MoveCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.MoveTypeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.PartyCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.StatRatioCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.TimeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.WeatherCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumEvolutionRock;
import com.pixelmonmod.pixelmon.enums.EnumEvolutionStone;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DatabaseStats {
    public static Optional<BaseStats> getBaseStats(String name) {
        return DatabaseStats.getBaseStats(name, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<BaseStats> getBaseStats(String name, int form) {
        Optional<BaseStats> baseStats;
        ResultSet rs;
        Statement stat;
        block34: {
            Connection conn = null;
            BaseStats store = new BaseStats(name);
            stat = null;
            rs = null;
            String query = "select * from PIXELMON where PIXELMONFULLNAME='" + name + "'";
            query = form != -1 ? query + " and FORM = " + form : query + " order by FORM";
            baseStats = Optional.empty();
            try {
                conn = DatabaseHelper.getConnection();
                stat = conn.createStatement();
                rs = stat.executeQuery(query);
                String error = "";
                boolean hasError = false;
                if (rs.next()) {
                    Optional<EnumPokemon> optional = EnumPokemon.getFromName(name);
                    if (optional.isPresent()) {
                        EnumEggGroup[] eggGroups;
                        store.pokemon = optional.get();
                        store.id = rs.getInt("PIXELMONID");
                        store.hp = rs.getInt("BASEHP");
                        if (rs.wasNull()) {
                            error = error + "[HP]";
                            hasError = true;
                        }
                        store.attack = rs.getInt("BASEATK");
                        if (rs.wasNull()) {
                            error = error + "[ATTACK]";
                            hasError = true;
                        }
                        store.defence = rs.getInt("BASEDEF");
                        if (rs.wasNull()) {
                            error = error + "[DEFENSE]";
                            hasError = true;
                        }
                        store.speed = rs.getInt("BASESPD");
                        if (rs.wasNull()) {
                            error = error + "[SPEED]";
                            hasError = true;
                        }
                        store.spAtt = rs.getInt("BASESPATK");
                        if (rs.wasNull()) {
                            error = error + "[SPATTACK]";
                            hasError = true;
                        }
                        store.spDef = rs.getInt("BASESPDEF");
                        if (rs.wasNull()) {
                            error = error + "[SPDEFENSE]";
                            hasError = true;
                        }
                        if (hasError && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in BaseStats [" + error + "] for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.catchRate = rs.getInt("CATCHRATE");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in CatchRate for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.malePercent = rs.getInt("MALEPERCENT");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in MalePercent for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.canFly = rs.getBoolean("CANFLY");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in CanFly for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.doesHover = rs.getBoolean("DOESHOVER");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in DoesHover for Pok\u00c3\u00a9mon: " + name);
                        }
                        if (store.doesHover) {
                            store.hoverHeight = 1.0f;
                        }
                        store.canSurf = rs.getBoolean("CANSWIM");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in CanSwim for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.height = rs.getFloat("POKEDEXHEIGHT");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in height for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.width = rs.getFloat("POKEDEXWIDTH");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in width for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.length = rs.getFloat("POKEDEXLENGTH");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in Length for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.weight = rs.getFloat("POKEDEXWEIGHT");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in Weight for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.type1 = EnumType.parseTypeFromDBID(rs.getInt("PIXELMONTYPE1ID"));
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in type for Pok\u00c3\u00a9mon: " + name);
                        }
                        rs.getInt("PIXELMONTYPE2ID");
                        if (!rs.wasNull()) {
                            store.type2 = EnumType.parseTypeFromDBID(rs.getInt("PIXELMONTYPE2ID"));
                        }
                        store.baseExp = rs.getInt("BASEEXP");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in BaseExp for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.experienceGroup = ExperienceGroup.getExperienceGroup(rs.getString("EXPERIENCEGROUP"));
                        if ((rs.wasNull() || store.experienceGroup == null) && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in ExperienceGroup for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.nationalPokedexNumber = rs.getInt("NATIONALPOKEDEXNUMBER");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in NationalPok\u00c3\u00a9dexNumber for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.spawnLevel = rs.getInt("MINSPAWNLEVEL");
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in SpawnLevel for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.spawnLevelRange = rs.getInt("MAXSPAWNLEVEL") - store.spawnLevel;
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in SpawnLevelRange for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.isRideable = rs.getBoolean("ISRIDEABLE");
                        store.giScale = rs.getFloat("MODELSCALE");
                        store.aggression = new Aggression(rs.getInt("PERCENTTIMID"), rs.getInt("PERCENTAGRESSIVE"), name);
                        if (rs.wasNull() && PixelmonConfig.printErrors) {
                            Pixelmon.LOGGER.info("Error in Aggression for Pok\u00c3\u00a9mon: " + name);
                        }
                        store.baseFriendship = rs.getInt("BASEFRIENDSHIP");
                        Integer rarityBase = rs.getInt("RARITY");
                        store.evGain = new EVsStore();
                        store.evGain.HP = rs.getInt("EVGAINHP");
                        store.evGain.Attack = rs.getInt("EVGAINATK");
                        store.evGain.Defence = rs.getInt("EVGAINDEF");
                        store.evGain.SpecialAttack = rs.getInt("EVGAINSPATK");
                        store.evGain.SpecialDefence = rs.getInt("EVGAINSPDEF");
                        store.evGain.Speed = rs.getInt("EVGAINSPD");
                        store.maxGroupSize = rs.getInt("MAXGROUPSIZE");
                        store.minGroupSize = rs.getInt("MINGROUPSIZE");
                        store.abilities = DatabaseAbilities.getAbilities(store.id);
                        rs.getInt("EGGGROUP1ID");
                        if (rs.wasNull()) {
                            eggGroups = new EnumEggGroup[]{EnumEggGroup.Undiscovered};
                        } else {
                            rs.getInt("EGGGROUP2ID");
                            eggGroups = rs.wasNull() ? new EnumEggGroup[]{EnumEggGroup.getEggGroupFromIndex(rs.getInt("EGGGROUP1ID"))} : new EnumEggGroup[]{EnumEggGroup.getEggGroupFromIndex(rs.getInt("EGGGROUP1ID")), EnumEggGroup.getEggGroupFromIndex(rs.getInt("EGGGROUP2ID"))};
                        }
                        store.eggGroups = eggGroups;
                        rs.getInt("EGGCYCLES");
                        store.eggCycles = rs.wasNull() ? Integer.valueOf(21) : Integer.valueOf(rs.getInt("EGGCYCLES"));
                        store.form = rs.getInt("FORM");
                        if (rs.wasNull()) {
                            store.form = -1;
                        }
                        DatabaseStats.getBaseFormID(name, store);
                        DatabaseStats.getPixelmonEvolutions(store, stat, name);
                        DatabaseStats.getPixelmonRarity(store, stat, rarityBase);
                        DatabaseStats.getPixelmonSpawnLocations(store, stat);
                        DatabaseStats.getPixelmonSpawnBiomeIDs(store, stat);
                        DatabaseStats.getPixelmonSwimmingParameters(store, stat);
                        DatabaseStats.getPixelmonFlyingParameters(store, stat);
                        DatabaseStats.getPixelmonRidingOffsets(store, stat);
                        baseStats = Optional.of(store);
                    }
                    break block34;
                }
                if (form == -1) break block34;
                baseStats = DatabaseStats.getBaseStats(name, -1);
            }
            catch (Exception var16) {
                try {
                    var16.printStackTrace();
                    Pixelmon.LOGGER.info("Error retrieving stats for Pok\u00c3\u00a9mon: " + name);
                }
                catch (Throwable throwable) {
                    DatabaseHelper.closeResult(stat, rs);
                    throw throwable;
                }
                DatabaseHelper.closeResult(stat, rs);
            }
        }
        DatabaseHelper.closeResult(stat, rs);
        BaseStatsLoadEvent event = new BaseStatsLoadEvent(name, form, baseStats);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getBaseStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBaseFormID(String name, BaseStats store) {
        boolean isMega = false;
        if (store.form > -1) {
            Connection conn = null;
            Statement stat = null;
            ResultSet rs = null;
            try {
                conn = DatabaseHelper.getConnection();
                stat = conn.createStatement();
                String query = "SELECT PIXELMONID FROM PIXELMON WHERE PIXELMONFULLNAME = '" + name + "' AND FORM IS NULL";
                rs = stat.executeQuery(query);
                if (rs.next()) {
                    store.baseFormID = rs.getInt(1);
                    isMega = true;
                }
                DatabaseHelper.closeResult(rs);
            }
            catch (Exception var10) {
                var10.printStackTrace();
            }
            finally {
                DatabaseHelper.closeResult(rs);
            }
        }
        if (!isMega) {
            store.baseFormID = store.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPixelmonRarity(BaseStats store, Statement stat, Integer rarityBase) throws SQLException {
        if (rarityBase == null) {
            store.rarity = new Rarity(0, 0, 0);
        } else {
            ResultSet rs = stat.executeQuery("select * from PIXELMONSPAWNTIMES a JOIN PIXELMON b ON (a.SPAWNTIMEID=b.SPAWNTIMEID) where b.PIXELMONID = '" + store.id + "'");
            float multiplierDay = 0.0f;
            float multiplierDawnDusk = 0.0f;
            float multiplierNight = 0.0f;
            try {
                if (rs.next()) {
                    String strDay = rs.getString("MULTIPLIERDAY");
                    String strDawnDusk = rs.getString("MULTIPLIERDUSKDAWN");
                    String strNight = rs.getString("MULTIPLIERNIGHT");
                    multiplierDay = Float.parseFloat(strDay);
                    multiplierDawnDusk = Float.parseFloat(strDawnDusk);
                    multiplierNight = Float.parseFloat(strNight);
                }
                store.rarity = new Rarity(Math.round((float)rarityBase.intValue() * multiplierDay), Math.round((float)rarityBase.intValue() * multiplierDawnDusk), Math.round((float)rarityBase.intValue() * multiplierNight));
            }
            finally {
                DatabaseHelper.closeResult(rs);
            }
        }
    }

    private static void getPixelmonRidingOffsets(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONRIDE where PIXELMONID='" + store.id + "'");
        try {
            if (rs.next()) {
                rs.getDouble("STANDINGOFFSETX");
                if (!rs.wasNull()) {
                    store.ridingOffsets = new RidingOffsets();
                    store.ridingOffsets.setStandingOffsets(rs.getDouble("STANDINGOFFSETX"), rs.getDouble("STANDINGOFFSETY"), rs.getDouble("STANDINGOFFSETZ"));
                }
                rs.getDouble("MOVINGOFFSETX");
                if (!rs.wasNull()) {
                    if (store.ridingOffsets == null) {
                        store.ridingOffsets = new RidingOffsets();
                    }
                    store.ridingOffsets.setMovingOffsets(rs.getDouble("MOVINGOFFSETX"), rs.getDouble("MOVINGOFFSETY"), rs.getDouble("MOVINGOFFSETZ"));
                }
            }
        }
        finally {
            DatabaseHelper.closeResult(rs);
        }
    }

    private static void getPixelmonSwimmingParameters(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONSWIM where PIXELMONID='" + store.id + "'");
        try {
            if (rs.next()) {
                store.swimmingParameters = new SwimmingParameters(rs.getInt("SWIMDEPTHMIN"), rs.getInt("SWIMDEPTHMAX"), rs.getDouble("SWIMSPEED"), rs.getDouble("SWIMSPEEDDECAY"), rs.getInt("SWIMREFRESHRATE"));
            }
        }
        finally {
            DatabaseHelper.closeResult(rs);
        }
    }

    private static void getPixelmonFlyingParameters(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONFLY where PIXELMONID='" + store.id + "'");
        try {
            if (rs.next()) {
                store.flyingParameters = new FlyingParameters(rs.getInt("FLYHEIGHTMIN"), rs.getInt("FLYHEIGHTMAX"), rs.getFloat("FLYSPEEDMODIFIER"), rs.getInt("FLYREFRESHRATEY"), rs.getInt("FLYREFRESHRATEXZ"), rs.getInt("FLYREFRESHRATESPEED"), rs.getInt("FLIGHTTIMEMIN"), rs.getInt("FLIGHTTIMEMAX"), rs.getInt("FLAPRATE"), rs.getString("LANDINGMATERIALGROUP"));
            }
        }
        finally {
            DatabaseHelper.closeResult(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPixelmonSpawnLocations(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONSPAWNLOCATIONS where PIXELMONID='" + store.id + "'");
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                list.add(rs.getString("LOCATION"));
            }
        }
        finally {
            DatabaseHelper.closeResult(rs);
        }
        store.spawnLocations = SpawnLocation.getSpawnLocations(list);
        if (SpawnLocation.contains(store.spawnLocations, SpawnLocation.Water)) {
            store.canSurf = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPixelmonEvolutions(BaseStats store, Statement stat, String name) throws SQLException {
        String p;
        ArrayList<Evolution> evolutions = new ArrayList<Evolution>();
        ResultSet evRS = stat.executeQuery("SELECT * FROM PIXELMONEVOLUTIONS WHERE PIXELMONFROMID='" + store.id + "'");
        try {
            while (evRS.next()) {
                PokemonSpec evolveInto = null;
                Evolution currentEvolution = null;
                int evolveLevel = evRS.getInt("EVOLVELEVEL");
                int pixelmonToID = evRS.getInt("PIXELMONTOID");
                String evolveCondition = evRS.getString("EVOLVECONDITION");
                int form = -1;
                try {
                    Statement newStatement = DatabaseHelper.getConnection().createStatement();
                    ResultSet formRS = newStatement.executeQuery("SELECT FORM FROM PIXELMON WHERE PIXELMONID=" + pixelmonToID);
                    formRS.next();
                    form = formRS.getObject("FORM") != null ? formRS.getInt("FORM") : -1;
                    formRS.close();
                    newStatement.close();
                }
                catch (Exception newStatement) {
                    // empty catch block
                }
                if (evolveCondition == null) {
                    evolveInto = PokemonSpec.from(EnumPokemon.getFromDBID((int)pixelmonToID).name);
                    if (evolveLevel > 1) {
                        currentEvolution = new LevelingEvolution(store.pokemon, evolveInto, evolveLevel, new EvoCondition[0]);
                    }
                } else {
                    TimeCondition.EnumTime enumTime;
                    String[] splits = evolveCondition.split(":");
                    Optional<EnumPokemon> poke = EnumPokemon.getFromName(splits[splits.length - 1]);
                    PokemonSpec to = evolveInto;
                    if (poke.isPresent() && evolveInto == null) {
                        to = PokemonSpec.from(poke.get().name);
                        if (form != -1) {
                            to.form = form;
                        }
                    }
                    if (splits[0].equalsIgnoreCase("time")) {
                        enumTime = TimeCondition.EnumTime.getTime(splits[1]);
                        currentEvolution = new LevelingEvolution(store.pokemon, to, evolveLevel, new TimeCondition(enumTime));
                    } else if (splits[0].equalsIgnoreCase("weather")) {
                        WeatherType weather = WeatherType.valueOf(splits[1].toUpperCase());
                        if (weather != null) {
                            currentEvolution = new LevelingEvolution(store.pokemon, to, evolveLevel, new WeatherCondition(weather));
                        } else {
                            Pixelmon.LOGGER.error("Bad weather type: " + splits[1] + " for " + store.pokemon.name + " evolution.");
                        }
                    } else if (splits[0].equalsIgnoreCase("highaltitude")) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, evolveLevel, new HighAltitudeCondition());
                    } else if (splits[0].equalsIgnoreCase("friendship")) {
                        if (splits.length > 2) {
                            enumTime = TimeCondition.EnumTime.getTime(splits[1]);
                            currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new FriendshipCondition(), new TimeCondition(enumTime));
                        } else {
                            currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new FriendshipCondition());
                        }
                    } else if (splits[0].equalsIgnoreCase("fairymovefriendshipflowerbiome")) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new FriendshipCondition(), new MoveTypeCondition(EnumType.Fairy), new BiomeCondition(Biomes.field_185444_T, Biomes.field_185441_Q));
                    } else if (splits[0].equalsIgnoreCase("trade")) {
                        currentEvolution = new TradeEvolution(store.pokemon, to, null, new EvoCondition[0]);
                        if (splits.length > 2) {
                            ItemHeld heldItem = PixelmonItemsHeld.getHeldItem(splits[1]);
                            if (heldItem == null) {
                                EnumPokemon withPoke = EnumPokemon.getFromNameAnyCase(splits[1]);
                                if (withPoke == null) {
                                    Pixelmon.LOGGER.error("Can't find item " + splits[1] + " for evolution!");
                                    currentEvolution = null;
                                } else {
                                    ((TradeEvolution)currentEvolution).with = withPoke;
                                }
                            } else {
                                currentEvolution.conditions.add(new HeldItemCondition(PixelmonItemsHeld.getHeldItem(splits[1])));
                            }
                        }
                    } else if (splits[0].equalsIgnoreCase("move")) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new MoveCondition(Integer.parseInt(splits[1])));
                    } else if (EnumEvolutionStone.hasEvolutionStone(splits[0])) {
                        currentEvolution = new InteractEvolution(store.pokemon, to, EnumEvolutionStone.getEvolutionStone(splits[0]).getItem(0), new EvoCondition[0]);
                        if (splits.length > 2) {
                            currentEvolution.conditions.add(new GenderCondition(Gender.getGender(splits[1])));
                        }
                    } else if (EnumEvolutionRock.hasEvolutionRock(splits[0])) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new EvoRockCondition(EnumEvolutionRock.getEvolutionRock(splits[0]), 100));
                    } else if (splits[0].equalsIgnoreCase("levelupgender")) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, evolveLevel, new EvoCondition[0]);
                        Gender gender = splits[1].equalsIgnoreCase("male") ? Gender.Male : Gender.Female;
                        currentEvolution.conditions.add(new GenderCondition(gender));
                    } else if (splits[0].equalsIgnoreCase("levelupbiome")) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new EvoCondition[0]);
                        ArrayList<Biome> biomes = new ArrayList<Biome>();
                        if (splits.length < 4) {
                            String biomeString = splits[1].toLowerCase();
                            for (Biome biome : GameRegistry.findRegistry(Biome.class).getValues()) {
                                if (!biome.getRegistryName().func_110623_a().toLowerCase().replaceAll("_", "").contains(biomeString)) continue;
                                biomes.add(biome);
                            }
                        } else {
                            Biome biome;
                            int level = Integer.parseInt(splits[1]);
                            String biomeString = splits[2].toLowerCase();
                            biome = GameRegistry.findRegistry(Biome.class).getValues().iterator();
                            while (biome.hasNext()) {
                                Biome biome2 = (Biome)biome.next();
                                if (!biome2.getRegistryName().func_110623_a().toLowerCase().replaceAll("_", "").contains(biomeString)) continue;
                                biomes.add(biome2);
                            }
                            currentEvolution.level = level;
                        }
                        currentEvolution.conditions.add(new BiomeCondition(biomes));
                    } else if (splits[0].equalsIgnoreCase("leveluphelditem")) {
                        String itemString = splits[1];
                        try {
                            ItemHeld item = PixelmonItemsHeld.getHeldItem(itemString);
                            if (item == null) {
                                throw new Exception("Can't find item " + itemString + " for evolution!");
                            }
                            TimeCondition timeCond = null;
                            if (splits.length == 4) {
                                String time = splits[2];
                                timeCond = new TimeCondition(TimeCondition.EnumTime.valueOf(time));
                            }
                            if (timeCond != null) {
                                currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new HeldItemCondition(item), timeCond);
                            }
                            currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new HeldItemCondition(item));
                        }
                        catch (Exception var22) {
                            var22.printStackTrace();
                            DatabaseHelper.closeResult(evRS);
                            return;
                        }
                    } else if (splits[0].equalsIgnoreCase("party")) {
                        currentEvolution = new LevelingEvolution(store.pokemon, to, evolveLevel, new EvoCondition[0]);
                        if (EnumType.hasType(splits[1])) {
                            currentEvolution.conditions.add(new PartyCondition(EnumType.valueOf(splits[1])));
                        } else if (EnumPokemon.getFromNameAnyCase(splits[1]) != null) {
                            currentEvolution.conditions.add(new PartyCondition(EnumPokemon.getFromNameAnyCase(splits[1])));
                        }
                    } else if (splits[0].equalsIgnoreCase("random")) {
                        EnumPokemon[] pokemonChoices = new EnumPokemon[splits.length - 1];
                        boolean invalid = false;
                        for (int i = 1; i < splits.length; ++i) {
                            Optional<EnumPokemon> poke2 = EnumPokemon.getFromName(splits[splits.length - i]);
                            if (!poke2.isPresent()) {
                                invalid = true;
                                break;
                            }
                            pokemonChoices[i - 1] = poke2.get();
                        }
                        if (invalid) continue;
                        float chance = 1.0f / (float)pokemonChoices.length;
                        for (int i = 0; i < pokemonChoices.length - 1; ++i) {
                            evolutions.add(new LevelingEvolution(store.pokemon, PokemonSpec.from(pokemonChoices[i].name), evolveLevel, new ChanceCondition(chance)));
                        }
                        currentEvolution = new LevelingEvolution(store.pokemon, PokemonSpec.from(pokemonChoices[pokemonChoices.length - 1].name), evolveLevel, new EvoCondition[0]);
                    } else if (splits[0].equalsIgnoreCase("tyrogue")) {
                        evolutions.add(new LevelingEvolution(store.pokemon, PokemonSpec.from("Hitmonlee"), 20, new StatRatioCondition(StatsType.Attack, StatsType.Defence, 1.0f)));
                        evolutions.add(new LevelingEvolution(store.pokemon, PokemonSpec.from("Hitmonchan"), 20, new StatRatioCondition(StatsType.Defence, StatsType.Attack, 1.0f)));
                        currentEvolution = new LevelingEvolution(store.pokemon, PokemonSpec.from("Hitmontop"), 20, new EvoCondition[0]);
                    } else if (splits[0].equalsIgnoreCase("mantyke")) {
                        to = PokemonSpec.from(EnumPokemon.Mantine.name);
                        currentEvolution = new LevelingEvolution(store.pokemon, to, 1, new PartyCondition(EnumPokemon.Remoraid));
                    } else if (splits[0].equalsIgnoreCase("burmy")) {
                        evolutions.add(new LevelingEvolution(store.pokemon, PokemonSpec.from("Wormadam"), 20, new GenderCondition(Gender.Female)));
                        currentEvolution = new LevelingEvolution(store.pokemon, PokemonSpec.from("Mothim"), 20, new GenderCondition(Gender.Male));
                    }
                    if (evolveInto == null) {
                        evolveInto = to;
                    }
                }
                boolean disableEvolution = false;
                if (evolveInto != null && !PixelmonConfig.allGenerationsEnabled() && store.pokemon.name.equals(evolveInto.name) && Entity3HasStats.isAvailableGeneration(store.nationalPokedexNumber) && !Entity3HasStats.isAvailableGeneration(evolveInto.name)) {
                    disableEvolution = true;
                }
                if (store.pokemon == EnumPokemon.Espurr) {
                    LevelingEvolution male = new LevelingEvolution(EnumPokemon.Espurr, PokemonSpec.from("Meowstic", "f:0"), currentEvolution.level, new GenderCondition(Gender.Male));
                    evolutions.add(male);
                    currentEvolution = new LevelingEvolution(EnumPokemon.Espurr, PokemonSpec.from("Meowstic", "f:1"), male.level, new GenderCondition(Gender.Female));
                }
                if (store.pokemon == EnumPokemon.Cubone) {
                    LevelingEvolution alolan = new LevelingEvolution(EnumPokemon.Cubone, PokemonSpec.from("Marowak", "f:3"), 28, new TimeCondition(TimeCondition.EnumTime.Night));
                    evolutions.add(alolan);
                }
                if (form != -1) {
                    currentEvolution.setForm(form);
                }
                if (disableEvolution) continue;
                evolutions.add(currentEvolution);
            }
        }
        catch (Exception var23) {
            var23.printStackTrace();
        }
        finally {
            DatabaseHelper.closeResult(evRS);
        }
        if (store.pixelmonName.equals("Eevee")) {
            for (int i = 0; i < evolutions.size(); ++i) {
                Evolution e = (Evolution)evolutions.get(i);
                if (!e.to.name.equals("Sylveon")) continue;
                evolutions.remove(i);
                evolutions.add(0, e);
                break;
            }
        }
        Object[] array = evolutions.toArray();
        store.evolutions = new Evolution[array.length];
        for (int i = 0; i < array.length; ++i) {
            store.evolutions[i] = (Evolution)array[i];
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((p = DatabaseStats.getPreEvolution(name, stat)) != null) {
            list.add(p);
            name = p;
        }
        store.preEvolutions = new EnumPokemon[list.size()];
        int i = 0;
        for (String poke : list) {
            store.preEvolutions[i++] = EnumPokemon.getFromName(poke).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPreEvolution(String name, Statement stat) throws SQLException {
        if (!(name.equals("Hitmonlee") || name.equals("Hitmonchan") || name.equals("Hitmontop"))) {
            if (name.equals("Mantine")) {
                return "Mantyke";
            }
            if (!name.equals("Mothim") && !name.equals("Wormadam")) {
                int id = DatabaseStats.getPokemonDBIDFromName(name, stat);
                Integer fromId = null;
                ResultSet rs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where EVOLVECONDITION LIKE '%" + name + "'");
                try {
                    if (rs.next()) {
                        fromId = rs.getInt("PIXELMONFROMID");
                        if (id != fromId) {
                            String string = DatabaseStats.getPokemonNameFromDBID(fromId, stat);
                            return string;
                        }
                        if (name.equalsIgnoreCase("Magmar")) {
                            String string = "Magby";
                            return string;
                        }
                        String string = null;
                        return string;
                    }
                    rs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where PIXELMONTOID='" + id + "'");
                    if (rs.next()) {
                        fromId = rs.getInt("PIXELMONFROMID");
                        if (id == fromId) {
                            String string = null;
                            return string;
                        }
                        String string = DatabaseStats.getPokemonNameFromDBID(fromId, stat);
                        return string;
                    }
                }
                finally {
                    DatabaseHelper.closeResult(rs);
                }
                return null;
            }
            return "Burmy";
        }
        return "Tyrogue";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPokemonDBIDFromName(String name, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select PIXELMONID from PIXELMON where PIXELMONFULLNAME='" + name + "' ORDER BY FORM ASC");
        try {
            if (rs.next()) {
                int n = rs.getInt("PIXELMONID");
                return n;
            }
        }
        finally {
            DatabaseHelper.closeResult(rs);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPokemonNameFromDBID(int id, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select PIXELMONFULLNAME from PIXELMON where PIXELMONID='" + id + "' ORDER BY FORM ASC");
        try {
            if (rs.next()) {
                String string = rs.getString("PIXELMONFULLNAME");
                return string;
            }
        }
        finally {
            DatabaseHelper.closeResult(rs);
        }
        return null;
    }

    private static void getPixelmonSpawnBiomeIDs(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONSPAWNBIOMES WHERE PIXELMONID='" + store.baseFormID + "'");
        PixelmonBiomeDictionary.PixelmonBiomeInfo[] biomes = PixelmonBiomeDictionary.getBiomeInfoList();
        ArrayList<Integer> tempBiomeIDs = new ArrayList<Integer>();
        try {
            block2: while (rs.next()) {
                String dbBiomeName = rs.getString("BIOMENAME");
                for (int i = 0; i < biomes.length; ++i) {
                    if (biomes[i] == null || !biomes[i].isSameNameAs(dbBiomeName)) continue;
                    tempBiomeIDs.add(i);
                    continue block2;
                }
            }
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
        rs.close();
        Integer[] biomeIDs = new Integer[tempBiomeIDs.size()];
        int j = 0;
        for (Integer i : tempBiomeIDs) {
            biomeIDs[j++] = i;
        }
        store.biomeIDs = biomeIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<EvolutionInfo> getEvolveList(int id) {
        ArrayList<EvolutionInfo> list = new ArrayList<EvolutionInfo>();
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            conn = DatabaseHelper.getConnection();
            stat = conn.createStatement();
            rs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where PIXELMONFROMID='" + id + "' AND EVOLVECONDITION IS NOT NULL");
            while (rs.next()) {
                String[] strList;
                String type = rs.getString("EVOLVECONDITION");
                for (String s : strList = type.split(";")) {
                    String[] sSplit = s.split(":");
                    EvolutionInfo i = new EvolutionInfo();
                    if (EnumEvolutionStone.hasEvolutionStone(sSplit[0])) {
                        i.mode = EnumInfoMode.stone;
                        i.evolutionStone = EnumEvolutionStone.getEvolutionStone(sSplit[0]);
                    } else if (EnumEvolutionRock.hasEvolutionRock(sSplit[0])) {
                        i.mode = EnumInfoMode.evolutionRock;
                        i.evolutionRock = EnumEvolutionRock.getEvolutionRock(sSplit[0]);
                    } else if (sSplit[0].equalsIgnoreCase("Friendship")) {
                        i.mode = EnumInfoMode.friendship;
                        if (sSplit.length > 1) {
                            i.extraParam = sSplit[1];
                        }
                    } else if (sSplit[0].equalsIgnoreCase("Trade")) {
                        i.mode = EnumInfoMode.trade;
                        if (sSplit.length > 1) {
                            i.extraParam = sSplit[1];
                        }
                        if (sSplit.length > 2) {
                            i.extraParam2 = sSplit[2];
                        }
                    } else {
                        i.mode = EnumInfoMode.biome;
                        i.extraParam = sSplit[0];
                    }
                    i.pokemonName = sSplit[sSplit.length - 1];
                    list.add(i);
                }
            }
        }
        catch (Exception e) {
            try {
                Pixelmon.LOGGER.info("Error in evolution conditions for " + id + ".");
            }
            catch (Throwable throwable) {
                DatabaseHelper.closeResult(stat, rs);
                throw throwable;
            }
            DatabaseHelper.closeResult(stat, rs);
        }
        DatabaseHelper.closeResult(stat, rs);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDescription(String name) {
        ResultSet rs;
        Statement stat;
        block3: {
            String string;
            stat = null;
            rs = null;
            try {
                Connection con = DatabaseHelper.getConnection();
                stat = con.createStatement();
                rs = stat.executeQuery("select POKEDEXDESCRIPTION from PIXELMON where PIXELMONFULLNAME='" + name + "'");
                if (!rs.next()) break block3;
                string = rs.getString("POKEDEXDESCRIPTION");
            }
            catch (Exception exception) {
                DatabaseHelper.closeResult(stat, rs);
            }
            catch (Throwable throwable) {
                DatabaseHelper.closeResult(stat, rs);
                throw throwable;
            }
            DatabaseHelper.closeResult(stat, rs);
            return string;
        }
        DatabaseHelper.closeResult(stat, rs);
        return "";
    }
}

