/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.debug;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class DebugHelper {
    public static void langCheck(EntityPlayer player) {
        DebugHelper.checkMissingBlockLangEntries();
        DebugHelper.checkMissingItemLangEntries();
        DebugHelper.checkMissingPokemonLangEntries(player.func_130014_f_());
    }

    public static void effectRegistryCheck() {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from MOVES");
            int moveIndex = 0;
            while (rs.next()) {
                Attack attack = new Attack(moveIndex++, rs.getString("NAME"), rs);
                System.out.println(attack.baseAttack.getLocalizedName() + " Index: " + attack.baseAttack.attackIndex + " PPBase: " + attack.ppBase + " Type: " + (Object)((Object)attack.baseAttack.attackType));
            }
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkMissingPokemonLangEntries(World world) {
        for (EnumPokemon pokemon : EnumPokemon.values()) {
            String langEntryName = "pixelmon." + pokemon.name.toLowerCase() + ".name";
            if (!I18n.func_74838_a((String)langEntryName).equals(langEntryName)) continue;
            System.out.println("Pokemon " + pokemon.name + " Doesn't have a lang entry " + langEntryName);
        }
    }

    private static void checkMissingItemLangEntries() {
    }

    private static void checkMissingBlockLangEntries() {
    }
}

