/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetChattingNPCTextures;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditData;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.EntityIndexedNPC;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NPCChatting
extends EntityIndexedNPC {
    private ArrayList<String> chatPages = new ArrayList();
    boolean usingDefaultName = true;
    boolean usingDefaultChat = true;

    public NPCChatting(World world) {
        super(world);
    }

    public void init(GeneralNPCData data) {
        this.npcIndex = data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
        this.npcLocation = SpawnLocation.LandVillager;
    }

    public void init(GymNPCData data) {
        this.npcIndex = "_gym_" + data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
        this.npcLocation = SpawnLocation.LandVillager;
    }

    @Override
    public void init(String name) {
        super.init(name);
        this.setCustomSteveTexture("npcchat1.png");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        BaseTrainer t = this.getBaseTrainer();
        if (!t.textures.isEmpty() && this.getTextureIndex() > -1) {
            if (this.getTextureIndex() >= t.textures.size()) {
                this.setTextureIndex(t.textures.size() - 1);
            }
            return t.textures.get(this.getTextureIndex()).equals("Custom_RP") ? "pixelmon:textures/steve/" + this.getCustomSteveTexture() + ".png" : "pixelmon:textures/steve/" + t.textures.get(this.getTextureIndex()) + ".png";
        }
        return this.getTextureIndex() == -1 ? "pixelmon:textures/steve/" + this.getCustomSteveTexture() : (t != NPCRegistryTrainers.Steve ? "pixelmon:textures/steve/" + t.name.toLowerCase() + ".png" : "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase() + ".png");
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    @Override
    public void func_70024_g(double par1, double par3, double par5) {
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("DefaultName", this.usingDefaultName);
        nbt.func_74757_a("DefaultGreet", this.usingDefaultChat);
        nbt.func_74768_a("chatNum", this.chatPages.size());
        int i = 0;
        for (String page : this.chatPages) {
            nbt.func_74778_a("chat" + i, page);
            ++i;
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.usingDefaultName = nbt.func_74767_n("DefaultName");
        this.usingDefaultChat = nbt.func_74767_n("DefaultGreet");
        int numPages = nbt.func_74762_e("chatNum");
        for (int i = 0; i < numPages; ++i) {
            this.chatPages.add(nbt.func_74779_i("chat" + i));
        }
        if (this.getProfession() != 0) {
            this.initDefaultAI();
        }
    }

    @Override
    public boolean interactWithNPC(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            String loc = playerMP.field_71148_cg;
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemNPCEditor) {
                if (!this.checkOP(player)) {
                    return false;
                }
                Pixelmon.network.sendTo((IMessage)new SetNPCEditData(this.getName(loc), this.getChat(loc)), playerMP);
                Pixelmon.network.sendTo((IMessage)new SetChattingNPCTextures(), playerMP);
                player.openGui((Object)Pixelmon.instance, EnumGui.NPCChatEditor.getIndex().intValue(), player.field_70170_p, this.getId(), 0, 0);
            } else if (!this.getChat(loc).isEmpty()) {
                NPCChatEvent event = new NPCChatEvent(this, player, this.getChat(loc));
                if (Pixelmon.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                Pixelmon.network.sendTo((IMessage)new SetNPCData(this.getName(loc), event.getChat()), (EntityPlayerMP)player);
                player.openGui((Object)Pixelmon.instance, EnumGui.NPCChat.getIndex().intValue(), player.field_70170_p, this.getId(), 0, 0);
            }
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return true;
    }

    @Override
    public ArrayList<String> getChat(String langCode) {
        if (this.usingDefaultChat) {
            int index = this.chatIndex;
            return this.npcIndex.startsWith("_gym_") ? new ArrayList<String>(Arrays.asList(ServerNPCRegistry.getTranslatedGymMemberChat(langCode, this.npcIndex.substring(5), index))) : new ArrayList<String>(Arrays.asList(ServerNPCRegistry.villagers.getTranslatedChat(langCode, this.npcIndex, index)));
        }
        return this.chatPages;
    }

    @Override
    public String getName(String langCode) {
        if (this.usingDefaultName) {
            int index = this.nameIndex;
            return this.npcIndex.startsWith("_gym_") ? ServerNPCRegistry.getTranslatedGymMemberName(langCode, this.npcIndex.substring(5), index) : ServerNPCRegistry.villagers.getTranslatedName(langCode, this.npcIndex, index);
        }
        return this.func_70005_c_();
    }

    public void setChat(ArrayList<String> pages) {
        this.chatPages = pages;
        this.usingDefaultChat = false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.usingDefaultName = false;
    }

    public void cycleTexture(EntityPlayerMP p, ClientNPCData newData) {
        GeneralNPCData data = ServerNPCRegistry.villagers.getData(newData.getID());
        if (data != null) {
            this.init(data);
            this.setCustomSteveTexture(newData.getTexture());
            Pixelmon.network.sendTo((IMessage)new SetNPCEditData(this.getName(p.field_71148_cg), this.getChat(p.field_71148_cg)), p);
        }
    }
}

