/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryShopkeepers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonDropInformation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity8HoldsItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.BossInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class DropItemRegistry {
    private static ArrayList<ItemStack> tier1 = new ArrayList();
    private static ArrayList<ItemStack> tier2 = new ArrayList();
    private static ArrayList<ItemStack> tier3 = new ArrayList();
    private static HashMap<EnumPokemon, PokemonDropInformation> pokemonDrops = new HashMap();
    private static ArrayList<ItemStack> megaDrops = new ArrayList();
    private static ArrayList<ItemStack> shinyMegaDrops = new ArrayList();
    private static ArrayList<BossInfo> bossMap = new ArrayList();
    private static HashMap<EnumPokemon, BossInfo> pokemonToBossInfo = new HashMap();
    private static Set<String> futureDrops = new HashSet<String>();

    public static void registerDropItems() throws FileNotFoundException {
        Pixelmon.LOGGER.info("Registering drops.");
        String path = Pixelmon.modDirectory + "/pixelmon/drops/";
        File dropsDir = new File(path);
        if (PixelmonConfig.useExternalJSONFilesDrops && !dropsDir.isDirectory()) {
            File baseDir = new File(Pixelmon.modDirectory + "/pixelmon");
            if (!baseDir.isDirectory()) {
                baseDir.mkdir();
            }
            Pixelmon.LOGGER.info("Creating drops directory.");
            dropsDir.mkdir();
            DropItemRegistry.extractDropsDir(dropsDir);
        }
        InputStream iStream = !PixelmonConfig.useExternalJSONFilesDrops ? ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/drops/pokechestdrops.json") : new FileInputStream(new File(dropsDir, "pokechestdrops.json"));
        JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        DropItemRegistry.registerTierDrops(json, "tier1", tier1);
        DropItemRegistry.registerTierDrops(json, "tier2", tier2);
        DropItemRegistry.registerTierDrops(json, "tier3", tier3);
        DropItemRegistry.registerPokemonDrops();
        iStream = !PixelmonConfig.useExternalJSONFilesDrops ? ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/drops/bossdrops.json") : new FileInputStream(new File(dropsDir, "bossdrops.json"));
        JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        DropItemRegistry.registerBossDrops(jsonObject);
    }

    private static void registerPokemonDrops() throws FileNotFoundException {
        Pixelmon.LOGGER.info("Registering Pok\u00e9mon drops.");
        String path = Pixelmon.modDirectory + "/pixelmon/drops/";
        File dropsDir = new File(path);
        InputStream iStream = !PixelmonConfig.useExternalJSONFilesDrops ? ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/drops/pokedrops.json") : new FileInputStream(new File(dropsDir, "pokedrops.json"));
        JsonArray json = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonArray();
        DropItemRegistry.registerPokemonDrops(json);
    }

    private static void registerBossDrops(JsonObject jsonObject) {
        DropItemRegistry.registerBossDropArray(jsonObject, "megadrops", megaDrops);
        DropItemRegistry.registerBossDropArray(jsonObject, "shinymegadrops", shinyMegaDrops);
        if (jsonObject.has("bosses")) {
            JsonArray bossArray = jsonObject.get("bosses").getAsJsonArray();
            for (int i = 0; i < bossArray.size(); ++i) {
                JsonObject bossObject = bossArray.get(i).getAsJsonObject();
                EnumPokemon pokemon = EnumPokemon.getFromNameAnyCase(bossObject.get("name").getAsString());
                if (pokemon == null) {
                    Pixelmon.LOGGER.warn("Error in boss information for Pok\u00e9mon " + bossObject.get("name"));
                    continue;
                }
                SpawnLocation spawnLocation = SpawnLocation.getSpawnLocation(bossObject.get("spawnlocation").getAsString());
                JsonArray biomeArray = bossObject.get("biomes").getAsJsonArray();
                String[] biomes = new String[biomeArray.size()];
                for (int j = 0; j < biomeArray.size(); ++j) {
                    biomes[j] = biomeArray.get(j).getAsString();
                }
                BossInfo bossInfo = null;
                if (bossObject.has("flying")) {
                    FlyingParameters flyingParams = new FlyingParameters(bossObject.get("flying").getAsJsonObject());
                    bossInfo = new BossInfo(pokemon, spawnLocation, biomes, flyingParams);
                } else if (bossObject.has("swimming")) {
                    SwimmingParameters swimParams = new SwimmingParameters(bossObject.get("swimming").getAsJsonObject());
                    bossInfo = new BossInfo(pokemon, spawnLocation, biomes, swimParams);
                } else {
                    bossInfo = new BossInfo(pokemon, spawnLocation, biomes);
                }
                pokemonToBossInfo.put(pokemon, bossInfo);
                bossMap.add(bossInfo);
            }
        }
    }

    private static void registerBossDropArray(JsonObject jsonObject, String key, List<ItemStack> dropArray) {
        if (jsonObject.has(key)) {
            JsonArray megaDropsArray = jsonObject.get(key).getAsJsonArray();
            for (int i = 0; i < megaDropsArray.size(); ++i) {
                String itemString = megaDropsArray.get(i).getAsString();
                ItemStack itemStack = DropItemRegistry.parseItem(itemString, "bossdrops.json");
                if (itemStack == null) {
                    if (futureDrops.contains(itemString)) continue;
                    Pixelmon.LOGGER.error("Boss drop item not found: " + itemString);
                    continue;
                }
                dropArray.add(itemStack);
            }
        }
    }

    private static void registerPokemonDrops(JsonArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject pokemonDropObject = jsonArray.get(i).getAsJsonObject();
            String pokemonName = pokemonDropObject.get("pokemon").getAsString();
            Optional<EnumPokemon> pokemon = EnumPokemon.getFromName(pokemonName);
            if (!pokemon.isPresent()) continue;
            PokemonDropInformation drop = new PokemonDropInformation(pokemon.get(), pokemonDropObject);
            pokemonDrops.put(pokemon.get(), drop);
        }
    }

    private static void registerTierDrops(JsonObject json, String tierName, List<ItemStack> tierList) {
        if (json.has(tierName)) {
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)tierName);
            for (int i = 0; i < jsonArray.size(); ++i) {
                String itemName = jsonArray.get(i).getAsString();
                Item item = null;
                ResourceLocation loc = new ResourceLocation(itemName);
                item = (Item)Item.field_150901_e.func_82594_a((Object)loc);
                if (item == null) {
                    Pixelmon.LOGGER.info("Item not found: " + itemName + " in pokechestdrops.json.");
                    continue;
                }
                if (NPCRegistryShopkeepers.shopItems.containsKey(itemName)) {
                    BaseShopItem bItem = NPCRegistryShopkeepers.shopItems.get(itemName);
                    tierList.add(bItem.itemStack);
                    continue;
                }
                tierList.add(new ItemStack(item));
            }
        }
    }

    private static void extractDropsDir(File dropsDir) {
        InputStream istream = ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/drops/pokechestdrops.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/pokechestdrops.json", dropsDir, "pokechestdrops.json");
        istream = ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/drops/pokedrops.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/pokedrops.json", dropsDir, "pokedrops.json");
        istream = ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/drops/bossdrops.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/bossdrops.json", dropsDir, "bossdrops.json");
    }

    public static ItemStack getTier1Drop() {
        return RandomHelper.getRandomElementFromList(tier1);
    }

    public static ItemStack getTier2Drop() {
        return RandomHelper.getRandomElementFromList(tier2);
    }

    public static ItemStack getTier3Drop() {
        return RandomHelper.getRandomElementFromList(tier3);
    }

    public static ArrayList<ItemStack> getDropsForPokemon(Entity8HoldsItems pixelmon) {
        PokemonDropInformation dropInfo = pokemonDrops.get((Object)pixelmon.baseStats.pokemon);
        if (dropInfo == null) {
            return new ArrayList<ItemStack>(0);
        }
        return dropInfo.getDrops(pixelmon);
    }

    public static ItemStack parseItem(String name, String filename) {
        String[] splits = name.split(":");
        int data = 0;
        if (splits.length > 2) {
            data = Integer.parseInt(splits[2]);
            name = splits[0] + ":" + splits[1];
        }
        ResourceLocation location = new ResourceLocation(name);
        Item item = null;
        item = (Item)Item.field_150901_e.func_82594_a((Object)location);
        if (item == null) {
            if (!futureDrops.contains(name)) {
                Pixelmon.LOGGER.info("Item not found: " + name + " in " + filename);
            }
            return null;
        }
        return new ItemStack(item, 1, data);
    }

    public static ArrayList<ItemStack> getBossDrops(Entity8HoldsItems pixelmon, EntityPlayerMP player) {
        EnumPokemon pokemon;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        EnumBossMode bossMode = pixelmon.getBossMode();
        if (bossMode.extraLevels <= EnumBossMode.Rare.extraLevels) {
            DropItemRegistry.addRandomBossDrops(drops, megaDrops, 0.333f);
        } else if (bossMode.extraLevels >= EnumBossMode.Legendary.extraLevels) {
            DropItemRegistry.addRandomBossDrops(drops, shinyMegaDrops, 0.5f);
        }
        Optional<PlayerStorage> storage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (storage.isPresent() && (pokemon = pixelmon.baseStats.pokemon).hasMega()) {
            int form = pixelmon.getForm();
            if (!storage.get().megaData.isMegaItemObtained(pokemon, form)) {
                drops.add(new ItemStack(EnumMegaPokemon.getMega(pokemon).getMegaEvoItems()[form - 1]));
                storage.get().megaData.obtainedItem(pokemon, form, player);
            } else if (RandomHelper.getRandomChance(0.025f)) {
                drops.add(new ItemStack(EnumMegaPokemon.getMega(pokemon).getMegaEvoItems()[form - 1]));
            }
        }
        return drops;
    }

    private static void addRandomBossDrops(List<ItemStack> drops, List<ItemStack> bossDropStore, float candyChance) {
        ItemStack megaDrop;
        if (RandomHelper.getRandomChance(candyChance)) {
            drops.add(new ItemStack(PixelmonItems.rareCandy));
        }
        if ((megaDrop = RandomHelper.getRandomElementFromList(bossDropStore)) == null) {
            return;
        }
        megaDrop = megaDrop.func_77946_l();
        megaDrop.func_190920_e(1);
        drops.add(megaDrop);
    }

    public static ArrayList<BossInfo> getBossPokemon() {
        return bossMap;
    }

    public static BossInfo getBossPokemon(EnumPokemon pokemon) {
        return pokemonToBossInfo.get((Object)pokemon);
    }

    static {
        futureDrops.addAll(Arrays.asList("minecraft:iron_nugget", "minecraft:shulker_shell", "minecraft:totem_of_undying", "pixelmon:cleanse_tag", "pixelmon:clever_wing", "pixelmon:fluffy_tail", "pixelmon:genius_wing", "pixelmon:honey"));
    }
}

