/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumBurmy;
import com.pixelmonmod.pixelmon.enums.forms.EnumCastform;
import com.pixelmonmod.pixelmon.enums.forms.EnumDeoxys;
import com.pixelmonmod.pixelmon.enums.forms.EnumGastrodon;
import com.pixelmonmod.pixelmon.enums.forms.EnumShellos;
import com.pixelmonmod.pixelmon.enums.forms.EnumUnown;
import com.pixelmonmod.pixelmon.enums.forms.EnumWormadam;
import com.pixelmonmod.pixelmon.util.IEncodeable;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class PokemonForm
implements IEncodeable {
    public EnumPokemon pokemon;
    public int form;
    public Gender gender;

    public PokemonForm(EnumPokemon pokemon) {
        this.pokemon = pokemon;
        this.form = -1;
        this.gender = Gender.Male;
    }

    public PokemonForm(EnumPokemon pokemon, int form) {
        this(pokemon);
        this.form = form;
        this.gender = Gender.Male;
    }

    public PokemonForm(EnumPokemon pokemon, int form, Gender gender) {
        this(pokemon, form);
        this.gender = gender;
    }

    public PokemonForm(NBTTagCompound nbt) {
        this(EnumPokemon.getFromName(nbt.func_74779_i("Name")).get(), nbt.func_74762_e("Variant"), Gender.getGender(nbt.func_74765_d("Gender")));
    }

    public PokemonForm(ByteBuf buffer) {
        this.decodeInto(buffer);
    }

    public PokemonForm copy() {
        return new PokemonForm(this.pokemon, this.form, this.gender);
    }

    public static PokemonForm[] convertEnumArray(EnumPokemon ... pokemon) {
        PokemonForm[] pokemonForms = new PokemonForm[pokemon.length];
        for (int i = 0; i < pokemon.length; ++i) {
            pokemonForms[i] = new PokemonForm(pokemon[i]);
        }
        return pokemonForms;
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        buffer.writeInt(this.pokemon.ordinal());
        buffer.writeInt(this.form);
        buffer.writeShort(this.gender.ordinal());
    }

    @Override
    public void decodeInto(ByteBuf buffer) {
        this.pokemon = EnumPokemon.getFromOrdinal(buffer.readInt());
        this.form = buffer.readInt();
        this.gender = Gender.getGender(buffer.readShort());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.form;
        result = 31 * result + (this.pokemon == null ? 0 : this.pokemon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PokemonForm other = (PokemonForm)obj;
        if (this.form != other.form) {
            return false;
        }
        if (this.pokemon != other.pokemon) {
            return false;
        }
        return this.gender == other.gender;
    }

    public static Optional<PokemonForm> getFromName(String name) {
        switch (name) {
            case "Farfetch'd": {
                return Optional.of(new PokemonForm(EnumPokemon.Farfetchd));
            }
            case "Ho-Oh": {
                return Optional.of(new PokemonForm(EnumPokemon.Hooh));
            }
            case "Mime Jr.": {
                return Optional.of(new PokemonForm(EnumPokemon.MimeJr));
            }
            case "Mr. Mime": {
                return Optional.of(new PokemonForm(EnumPokemon.MrMime));
            }
            case "Nidoran\u2640": {
                return Optional.of(new PokemonForm(EnumPokemon.Nidoranfemale));
            }
            case "Nidoran\u2642": {
                return Optional.of(new PokemonForm(EnumPokemon.Nidoranmale));
            }
            case "Porygon-Z": {
                return Optional.of(new PokemonForm(EnumPokemon.PorygonZ));
            }
        }
        Optional<EnumPokemon> pokemon = EnumPokemon.getFromName(name);
        if (pokemon.isPresent()) {
            return Optional.of(new PokemonForm(pokemon.get()));
        }
        String megaPrefix = "Mega ";
        if (name.startsWith(megaPrefix)) {
            EnumPokemon enumPokemon;
            String nameEnd = name.substring(megaPrefix.length());
            if (nameEnd.equals("Charizard X")) {
                return Optional.of(new PokemonForm(EnumPokemon.Charizard, 1));
            }
            if (nameEnd.equals("Charizard Y")) {
                return Optional.of(new PokemonForm(EnumPokemon.Charizard, 2));
            }
            pokemon = EnumPokemon.getFromName(nameEnd);
            if (pokemon.isPresent() && (enumPokemon = pokemon.get()) != EnumPokemon.Charizard && enumPokemon.hasMega()) {
                return Optional.of(new PokemonForm(enumPokemon, 1));
            }
        } else {
            String[] hyphenSplit = name.split("-");
            if (hyphenSplit.length == 2) {
                pokemon = EnumPokemon.getFromName(hyphenSplit[0]);
                String formName = hyphenSplit[1];
                if (pokemon.isPresent()) {
                    EnumPokemon enumPokemon = pokemon.get();
                    int formIndex = -1;
                    try {
                        switch (enumPokemon) {
                            case Burmy: {
                                formIndex = EnumBurmy.valueOf(formName).ordinal();
                                break;
                            }
                            case Castform: {
                                formIndex = EnumCastform.getFromName(formName).ordinal();
                                break;
                            }
                            case Deoxys: {
                                formIndex = EnumDeoxys.valueOf(formName).ordinal();
                                break;
                            }
                            case Gastrodon: {
                                formIndex = EnumGastrodon.valueOf(formName).ordinal();
                                break;
                            }
                            case Shellos: {
                                formIndex = EnumShellos.valueOf(formName).ordinal();
                                break;
                            }
                            case Unown: {
                                formIndex = EnumUnown.getFromName(formName).ordinal();
                                break;
                            }
                            case Wormadam: {
                                formIndex = EnumWormadam.valueOf(formName).ordinal();
                            }
                        }
                        if (formIndex != -1) {
                            return Optional.of(new PokemonForm(enumPokemon, formIndex));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return this.pokemon.name + (this.form > 0 ? Integer.valueOf(this.form) : "");
    }

    public String getLocalizedName() {
        String baseName = Entity1Base.getLocalizedName(this.pokemon);
        if (this.form == -1) {
            return baseName;
        }
        if (this.form > 0 && this.pokemon.hasMega()) {
            if (this.pokemon == EnumPokemon.Charizard) {
                baseName = baseName + " " + (this.form == 2 ? "Y" : "X");
            }
            return I18n.func_135052_a((String)"pixelmon.mega.name", (Object[])new Object[]{baseName});
        }
        String formName = "";
        switch (this.pokemon) {
            case Burmy: {
                formName = EnumBurmy.getFromIndex(this.form).name();
                break;
            }
            case Castform: {
                formName = EnumCastform.getFromIndex(this.form).name();
                break;
            }
            case Deoxys: {
                formName = EnumDeoxys.getFromIndex(this.form).name();
                break;
            }
            case Gastrodon: {
                formName = EnumGastrodon.getFromIndex(this.form).name();
                break;
            }
            case Shellos: {
                formName = EnumShellos.getFromIndex(this.form).name();
                break;
            }
            case Unown: {
                formName = EnumUnown.getFromIndex(this.form).name();
                break;
            }
            case Wormadam: {
                formName = EnumWormadam.getFromIndex(this.form).name();
            }
        }
        String formTranslate = I18n.func_135052_a((String)("pixelmon.form." + formName.toLowerCase() + ".name"), (Object[])new Object[0]);
        if (formTranslate.startsWith("pixelmon.")) {
            formTranslate = formName;
        }
        return String.format("%s-%s", baseName, formTranslate);
    }
}

