/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ShopItemWithVariation {
    private float variation;
    private ShopItem shopItem;

    public ShopItemWithVariation(ShopItem shopItem, float variation) {
        this.shopItem = shopItem;
        this.variation = variation;
    }

    public ShopItemWithVariation(ShopItem item) {
        this(item, item.canPriceVary() ? ShopItemWithVariation.getVariation() : 1.0f);
    }

    private static float getVariation() {
        float rand = RandomHelper.getRandomNumberBetween(0.0f, 1.0f);
        float variation = 1.0f;
        if ((double)rand > 0.75) {
            variation = 1.1f;
        } else if ((double)rand < 0.25) {
            variation = 0.9f;
        }
        return variation;
    }

    public void writeToNBT(NBTTagList list) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ItemName", this.shopItem.getBaseItem().id);
        tag.func_74776_a("ItemVar", this.variation);
        list.func_74742_a((NBTBase)tag);
    }

    public static ShopItemWithVariation getFromNBT(String npcIndex, NBTTagCompound tag) {
        ShopItem item = ServerNPCRegistry.shopkeepers.getItem(npcIndex, tag.func_74779_i("ItemName"));
        if (item == null) {
            return null;
        }
        return new ShopItemWithVariation(item, tag.func_74760_g("ItemVar"));
    }

    public void writeToBuffer(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.shopItem.getBaseItem().id);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.shopItem.getBaseItem().itemStack);
        buffer.writeInt((int)((float)this.getBaseShopItem().buy * this.variation));
        buffer.writeInt((int)((float)this.getBaseShopItem().sell * this.variation));
    }

    public ItemStack getItem() {
        return this.shopItem.getItem();
    }

    public BaseShopItem getBaseShopItem() {
        return this.shopItem.getBaseItem();
    }

    public boolean canSell() {
        return this.shopItem.getBaseItem().sell != -1;
    }

    public int getBuyCost() {
        return (int)((float)this.getBaseShopItem().buy * this.variation);
    }

    public int getSellCost() {
        return (int)((float)this.getBaseShopItem().sell * this.variation);
    }
}

