/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.blocks.ranch.BreedingConditions;
import com.pixelmonmod.pixelmon.blocks.ranch.RanchBounds;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityRanchBase;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity9HasSounds;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.BreedingParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.ParticleEffects;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumBreedingStrength;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumForms;
import com.pixelmonmod.pixelmon.enums.forms.EnumRotom;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.EnumIsisHourglassType;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.ItemIsisHourglass;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Entity10CanBreed
extends Entity9HasSounds {
    public boolean isEgg = false;
    public boolean isRandomEgg = false;
    public EnumEggGroup group = EnumEggGroup.Undiscovered;
    public Integer eggCycles = 21;
    public boolean isInRanchBlock = false;
    public ParticleEffects[] breedingParticleEffects = null;
    private int lastBreedingLevels = -1;
    public EnumBreedingStrength breedingStrength = EnumBreedingStrength.NONE;
    public long lastBreedingTime;
    public int[] eggMoves = new int[0];
    int breedingCheckCount = 0;

    public Entity10CanBreed(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwNumBreedingLevels, (Object)-1);
    }

    @Override
    public void init(String name) {
        super.init(name);
    }

    public int getNumBreedingLevels() {
        return (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwNumBreedingLevels);
    }

    public void setNumBreedingLevels(int newValue) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwNumBreedingLevels, (Object)newValue);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.getNumBreedingLevels() != this.lastBreedingLevels) {
                this.breedingParticleEffects = this.getBreedingParticleEffects();
                this.lastBreedingLevels = this.getNumBreedingLevels();
            }
            if (this.breedingParticleEffects != null) {
                for (ParticleEffects breedingParticleEffect : this.breedingParticleEffects) {
                    breedingParticleEffect.onUpdate();
                }
            }
        }
    }

    @Override
    public boolean func_70692_ba() {
        return this.blockOwner == null && super.func_70692_ba();
    }

    public void setRanchBlockOwner(TileEntityRanchBase tileEntityRanchBase) {
        this.blockOwner = tileEntityRanchBase;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.isInRanchBlock) {
            nbt.func_74772_a("lastBreedingTime", this.lastBreedingTime);
        }
        nbt.func_74757_a("isEgg", this.isEgg);
        nbt.func_74757_a("isRandomEgg", this.isRandomEgg);
        nbt.func_74768_a("eggGroupID", this.group.getIndex().intValue());
        nbt.func_74768_a("eggCycles", this.eggCycles.intValue());
        nbt.func_74776_a("lastEggXCoord", (float)this.field_70165_t);
        nbt.func_74776_a("lastEggZCoord", (float)this.field_70161_v);
        nbt.func_74757_a("isInRanch", this.isInRanchBlock);
        nbt.func_74777_a("BreedingInteractions", (short)this.getNumBreedingLevels());
        nbt.func_74783_a("EggMoves", this.eggMoves);
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
        tags.put("lastBreedingTime", Long.class);
        tags.put("isEgg", Boolean.class);
        tags.put("isRandomEgg", Boolean.class);
        tags.put("eggGroupID", Integer.class);
        tags.put("eggCycles", Integer.class);
        tags.put("lastEggXCoord", Float.class);
        tags.put("lastEggZCoord", Float.class);
        tags.put("isInRanch", Boolean.class);
        tags.put("BreedingInteractions", Short.class);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player instanceof EntityPlayerMP) {
            if (!this.isInRanchBlock) {
                return super.func_184645_a(player, hand);
            }
            ItemStack itemStack = player.func_184586_b(hand);
            if (this.func_70902_q() == player && hand != EnumHand.OFF_HAND) {
                if (super.func_184645_a(player, hand)) {
                    return true;
                }
                this.blockOwner.updateStatus();
                if (this.blockOwner instanceof TileEntityRanchBlock) {
                    TileEntityRanchBlock ranch = (TileEntityRanchBlock)this.blockOwner;
                    if (this.blockOwner.getEntityCount() > 1) {
                        Item item;
                        if (itemStack != null && (item = itemStack.func_77973_b()) instanceof ItemIsisHourglass && ((ItemIsisHourglass)item).type == EnumIsisHourglassType.Silver) {
                            if (this.breedingStrength == EnumBreedingStrength.NONE) {
                                return false;
                            }
                            if (ranch.getFirstBreedingPartner((EntityPixelmon)this) == null) {
                                return false;
                            }
                            int numBreedingLevels = this.getNumBreedingLevels();
                            if (numBreedingLevels >= PixelmonConfig.numBreedingLevels) {
                                return false;
                            }
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("ranch.hourglass.upgrade", new Object[]{this.getNickname()}));
                            this.setNumBreedingLevels(numBreedingLevels + 1);
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.field_71071_by.func_174925_a(item, itemStack.func_77960_j(), 1, itemStack.func_77978_p());
                            }
                            return super.func_184645_a(player, hand);
                        }
                        EntityPixelmon otherPixelmon = ranch.getFirstBreedingPartner((EntityPixelmon)this);
                        if (otherPixelmon != null) {
                            if (this.breedingStrength == EnumBreedingStrength.NONE) {
                                this.refreshBreedingStrength();
                            }
                            if (this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.maxaffection", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                            } else {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.level" + this.breedingStrength.ordinal(), new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.notcompatible", new Object[]{this.getNickname()}));
                        }
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.nopartner", new Object[]{this.getNickname()}));
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        try {
            if (nbt.func_74764_b("isEgg")) {
                this.isEgg = nbt.func_74767_n("isEgg");
                this.isRandomEgg = nbt.func_74767_n("isRandomEgg");
                this.group = EnumEggGroup.getEggGroupFromIndex(nbt.func_74762_e("eggGroupID"));
                this.eggCycles = nbt.func_74762_e("eggCycles");
            } else {
                this.isEgg = false;
                this.isRandomEgg = false;
                this.group = EnumEggGroup.getRandomEggGroup(this.getSpecies());
                this.eggCycles = 21;
            }
            if (nbt.func_74764_b("isInRanch")) {
                this.isInRanchBlock = nbt.func_74767_n("isInRanch");
            }
            if (nbt.func_74764_b("lastBreedingTime")) {
                this.lastBreedingTime = nbt.func_74763_f("lastBreedingTime");
            }
            if (nbt.func_74764_b("BreedingInteractions")) {
                this.setNumBreedingLevels(nbt.func_74765_d("BreedingInteractions"));
            }
            this.eggMoves = nbt.func_74759_k("EggMoves");
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
    }

    public void makeEntityIntoRandomEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        EnumPokemon pokemon = EnumPokemon.randomPoke(PixelmonConfig.allowRandomBreedingEggsToBeLegendary);
        this.baseStats = null;
        super.init(pokemon.name);
        this.isRandomEgg = true;
        this.isEgg = true;
        this.getLvl().setLevel(1);
        this.setAbilitySlot(this.baseStats.abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0);
        this.setAbility(this.baseStats.abilities[this.getAbilitySlot()]);
        this.stats.IVs = Entity10CanBreed.getIVsForEgg(pixelmon1, pixelmon2);
        this.setNature(Entity10CanBreed.getNatureForEgg(pixelmon1, pixelmon2));
        this.setGrowth(Entity10CanBreed.getEggGrowth(pixelmon1, pixelmon2));
        this.setIsShiny(this.getIfEggIsShiny(pixelmon1, pixelmon2));
        this.group = Entity10CanBreed.getRandomEggGroupForPokemon(pokemon);
        Optional<BaseStats> optional = Entity10CanBreed.getBaseStats(pokemon);
        Integer tempCycles = optional.isPresent() ? optional.get().eggCycles : null;
        this.eggCycles = tempCycles != null && tempCycles != 0 ? tempCycles : Integer.valueOf(21);
    }

    public void makeEntityIntoEgg() {
        super.init(this.getPokemonName());
        this.isEgg = true;
        this.group = this.getRandomEggGroupForPokemon();
        this.getLvl().setLevel(1);
        Integer tempCycles = this.baseStats.eggCycles;
        this.eggCycles = tempCycles != null && tempCycles != 0 ? tempCycles : Integer.valueOf(21);
    }

    public void makeEntityIntoEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (Entity10CanBreed.canBreed(pixelmon1, pixelmon2)) {
            if (pixelmon1.isPokemon(EnumPokemon.Ditto) && pixelmon2.isPokemon(EnumPokemon.Ditto) && PixelmonConfig.allowDittoDittoBreeding) {
                this.makeEntityIntoRandomEgg(pixelmon1, pixelmon2);
            } else {
                boolean shouldBeAlolanEgg = false;
                int alolanChance = -1;
                if (pixelmon1.hasForms() || pixelmon2.hasForms()) {
                    if (pixelmon1.getFormEnum() == EnumForms.Alolan) {
                        if (pixelmon2.getFormEnum() == EnumForms.Alolan) {
                            shouldBeAlolanEgg = true;
                        } else if (pixelmon1.getItemHeld() == PixelmonItemsHeld.everStone) {
                            if (pixelmon2.getItemHeld() == PixelmonItemsHeld.everStone) {
                                if (pixelmon1.getGender() == Gender.Female) {
                                    shouldBeAlolanEgg = true;
                                } else if (pixelmon2.getGender() == Gender.Female) {
                                    shouldBeAlolanEgg = false;
                                }
                            } else {
                                shouldBeAlolanEgg = true;
                            }
                        } else {
                            alolanChance = 20;
                        }
                    }
                    if (!shouldBeAlolanEgg && pixelmon2.getFormEnum() == EnumForms.Alolan) {
                        if (pixelmon1.getItemHeld() == PixelmonItemsHeld.everStone) {
                            if (pixelmon2.getItemHeld() == PixelmonItemsHeld.everStone) {
                                if (pixelmon1.getGender() == Gender.Female) {
                                    shouldBeAlolanEgg = false;
                                    alolanChance = -1;
                                } else if (pixelmon2.getGender() == Gender.Female) {
                                    shouldBeAlolanEgg = true;
                                }
                            }
                        } else if (pixelmon2.getItemHeld() == PixelmonItemsHeld.everStone) {
                            if (pixelmon2.getGender() == Gender.Female) {
                                shouldBeAlolanEgg = true;
                            } else {
                                shouldBeAlolanEgg = false;
                                alolanChance = -1;
                            }
                        } else {
                            alolanChance = 20;
                        }
                    }
                    if (!shouldBeAlolanEgg) {
                        if (pixelmon1.isPokemon(EnumPokemon.Ditto)) {
                            if (pixelmon2.getFormEnum() == EnumForms.Alolan && pixelmon2.getItemHeld() == PixelmonItemsHeld.everStone) {
                                shouldBeAlolanEgg = true;
                            }
                        } else if (pixelmon2.isPokemon(EnumPokemon.Ditto) && pixelmon1.getFormEnum() == EnumForms.Alolan && pixelmon1.getItemHeld() == PixelmonItemsHeld.everStone) {
                            shouldBeAlolanEgg = true;
                        }
                    }
                }
                EnumPokemon pokemon = Entity10CanBreed.getPokemonInEggName(pixelmon1, pixelmon2);
                this.baseStats = null;
                super.init(pokemon.name);
                this.isEgg = true;
                this.group = Entity10CanBreed.getEggGroupForPair(pixelmon1, pixelmon2);
                this.getLvl().setLevel(1);
                Integer tempCycles = this.baseStats.eggCycles;
                this.eggCycles = tempCycles != null && tempCycles != 0 ? tempCycles : Integer.valueOf(21);
                if (shouldBeAlolanEgg) {
                    this.setForm(EnumForms.Alolan.getForm());
                } else if (alolanChance != -1 && RandomHelper.getRandomChance(alolanChance)) {
                    this.setForm(EnumForms.Alolan.getForm());
                }
                if (pokemon == EnumPokemon.Rotom && (pixelmon1.isPokemon(EnumPokemon.Ditto) || pixelmon2.isPokemon(EnumPokemon.Ditto))) {
                    this.setForm(EnumRotom.NORMAL.getForm());
                }
                this.stats.IVs = Entity10CanBreed.getIVsForEgg(pixelmon1, pixelmon2);
                this.setNature(Entity10CanBreed.getNatureForEgg(pixelmon1, pixelmon2));
                this.caughtBall = Entity10CanBreed.getMotherPokeball(pixelmon1, pixelmon2);
                this.setGrowth(Entity10CanBreed.getEggGrowth(pixelmon1, pixelmon2));
                this.setAbilitySlot(Entity10CanBreed.getEggAbilitySlot(this.baseStats.abilities, pixelmon1, pixelmon2));
                this.setAbility(this.baseStats.abilities[this.getAbilitySlot()]);
                this.setIsShiny(this.getIfEggIsShiny(pixelmon1, pixelmon2));
                Moveset moveset = this.getEggMoveset(this, pokemon, pixelmon1, pixelmon2);
                Moveset thisMoveset = this.getMoveset();
                thisMoveset.set(0, moveset.get(0));
                thisMoveset.set(1, moveset.get(1));
                thisMoveset.set(2, moveset.get(2));
                thisMoveset.set(3, moveset.get(3));
            }
            this.updateStats();
        } else {
            Pixelmon.LOGGER.info("Error occurred in breeding; incompatible pair passed to Egg initialization.");
        }
    }

    public static EnumNature getNatureForEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        boolean isEverstone2;
        boolean isEverstone1 = pixelmon1.getItemHeld() == PixelmonItemsHeld.everStone;
        boolean bl = isEverstone2 = pixelmon2.getItemHeld() == PixelmonItemsHeld.everStone;
        return isEverstone1 && isEverstone2 ? (RandomHelper.getRandomChance() ? pixelmon1.getNature() : pixelmon2.getNature()) : (isEverstone1 ? pixelmon1.getNature() : (isEverstone2 ? pixelmon2.getNature() : EnumNature.getRandomNature()));
    }

    public static boolean canLearnVoltTackle(EnumPokemon pokemon, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pokemon != EnumPokemon.Pichu) {
            return false;
        }
        ItemStack heldItem1 = pixelmon1.func_184614_ca();
        ItemStack heldItem2 = pixelmon2.func_184614_ca();
        return heldItem1 != null && heldItem1.func_77973_b() == PixelmonItemsHeld.lightBall || heldItem2 != null && heldItem2.func_77973_b() == PixelmonItemsHeld.lightBall;
    }

    public boolean getIfEggIsShiny(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        float intDifferentTrainerFactor = 1.0f;
        if (!pixelmon1.originalTrainer.equalsIgnoreCase(pixelmon2.originalTrainer)) {
            intDifferentTrainerFactor = 2.0f;
        }
        return PixelmonConfig.shinyRate != 0.0f && this.field_70146_Z.nextFloat() < intDifferentTrainerFactor / PixelmonConfig.shinyRate;
    }

    public static EnumPokeballs getMotherPokeball(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        return pixelmon1.gender == Gender.Female && pixelmon1.caughtBall != EnumPokeballs.MasterBall && pixelmon1.caughtBall != EnumPokeballs.CherishBall ? pixelmon1.caughtBall : (pixelmon2.gender == Gender.Female && pixelmon2.caughtBall != EnumPokeballs.MasterBall && pixelmon2.caughtBall != EnumPokeballs.CherishBall ? pixelmon2.caughtBall : EnumPokeballs.PokeBall);
    }

    public static Integer getEggAbilitySlot(String[] abilities, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        EntityPixelmon inheritParent;
        boolean is1Ditto = pixelmon1.isPokemon(EnumPokemon.Ditto);
        boolean is2Ditto = pixelmon2.isPokemon(EnumPokemon.Ditto);
        int intPercent = 80;
        if (!is1Ditto && !is2Ditto) {
            inheritParent = pixelmon1.gender == Gender.Female ? pixelmon1 : pixelmon2;
        } else {
            if (is1Ditto && is2Ditto) {
                return Entity10CanBreed.getRandomNormalAbilitySlot(abilities);
            }
            EntityPixelmon entityPixelmon = inheritParent = is1Ditto ? pixelmon2 : pixelmon1;
            if (inheritParent.gender == Gender.Male) {
                intPercent = 60;
            }
        }
        if (RandomHelper.getRandomChance(intPercent)) {
            int currentSlot = inheritParent.getAbilitySlot();
            return abilities[currentSlot] != null ? currentSlot : 0;
        }
        return Entity10CanBreed.getRandomNormalAbilitySlot(abilities);
    }

    public static IVStore getIVsForEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        ArrayList<String> masterStatsList = new ArrayList<String>(Arrays.asList("HP1", "ATK1", "DEF1", "SPATK1", "SPDEF1", "SPD1", "HP2", "ATK2", "DEF2", "SPATK2", "SPDEF2", "SPD2"));
        ArrayList<String> strStatsToInherit = new ArrayList<String>();
        IVStore newIVs = IVStore.CreateNewIVs();
        int intNumberToInherit = 3;
        ItemHeld heldItem1 = pixelmon1.getItemHeld();
        ItemHeld heldItem2 = pixelmon2.getItemHeld();
        if (heldItem1 == PixelmonItemsHeld.destinyKnot || heldItem2 == PixelmonItemsHeld.destinyKnot) {
            intNumberToInherit = 5;
        }
        boolean skipSecondHeldItem = false;
        if (heldItem1 != NoItem.noItem) {
            if (heldItem1 == PixelmonItemsHeld.powerWeight) {
                strStatsToInherit.add("HP1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerBracer) {
                strStatsToInherit.add("ATK1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerBelt) {
                strStatsToInherit.add("DEF1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerLens) {
                strStatsToInherit.add("SPATK1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerBand) {
                strStatsToInherit.add("SPDEF1");
                --intNumberToInherit;
            } else if (heldItem1 == PixelmonItemsHeld.powerAnklet) {
                strStatsToInherit.add("SPD1");
                --intNumberToInherit;
            }
            if (heldItem2 != NoItem.noItem && heldItem1 == heldItem2) {
                if (RandomHelper.getRandomChance()) {
                    skipSecondHeldItem = true;
                } else {
                    strStatsToInherit = new ArrayList();
                }
            }
        }
        if (!strStatsToInherit.isEmpty()) {
            for (String strStat : strStatsToInherit) {
                masterStatsList.remove(strStat);
                if (strStat.contains("1")) {
                    masterStatsList.remove(RegexPatterns.NUMBER_ONE.matcher(strStat).replaceAll("2"));
                    continue;
                }
                masterStatsList.remove(RegexPatterns.NUMBER_TWO.matcher(strStat).replaceAll("1"));
            }
        }
        if (!skipSecondHeldItem && heldItem2 != NoItem.noItem) {
            if (heldItem2 == PixelmonItemsHeld.powerWeight) {
                strStatsToInherit.add("HP2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerBracer) {
                strStatsToInherit.add("ATK2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerBelt) {
                strStatsToInherit.add("DEF2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerLens) {
                strStatsToInherit.add("SPATK2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerBand) {
                strStatsToInherit.add("SPDEF2");
                --intNumberToInherit;
            } else if (heldItem2 == PixelmonItemsHeld.powerAnklet) {
                strStatsToInherit.add("SPD2");
                --intNumberToInherit;
            }
        }
        if (!strStatsToInherit.isEmpty()) {
            for (String strStat : strStatsToInherit) {
                masterStatsList.remove(strStat);
                if (strStat.contains("1")) {
                    masterStatsList.remove(RegexPatterns.NUMBER_ONE.matcher(strStat).replaceAll("2"));
                    continue;
                }
                masterStatsList.remove(RegexPatterns.NUMBER_TWO.matcher(strStat).replaceAll("1"));
            }
        }
        for (int i = 0; i < intNumberToInherit; ++i) {
            String strStat;
            strStat = RandomHelper.getRandomElementFromList(masterStatsList);
            strStatsToInherit.add(strStat);
            masterStatsList.remove(strStat);
            if (strStat.contains("1")) {
                masterStatsList.remove(RegexPatterns.NUMBER_ONE.matcher(strStat).replaceAll("2"));
                continue;
            }
            masterStatsList.remove(RegexPatterns.NUMBER_TWO.matcher(strStat).replaceAll("1"));
        }
        for (String strStat : strStatsToInherit) {
            if (strStat.equalsIgnoreCase("HP1")) {
                newIVs.HP = pixelmon1.stats.IVs.HP;
                continue;
            }
            if (strStat.equalsIgnoreCase("ATK1")) {
                newIVs.Attack = pixelmon1.stats.IVs.Attack;
                continue;
            }
            if (strStat.equalsIgnoreCase("DEF1")) {
                newIVs.Defence = pixelmon1.stats.IVs.Defence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPATK1")) {
                newIVs.SpAtt = pixelmon1.stats.IVs.SpAtt;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPDEF1")) {
                newIVs.SpDef = pixelmon1.stats.IVs.SpDef;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPD1")) {
                newIVs.Speed = pixelmon1.stats.IVs.Speed;
                continue;
            }
            if (strStat.equalsIgnoreCase("HP2")) {
                newIVs.HP = pixelmon2.stats.IVs.HP;
                continue;
            }
            if (strStat.equalsIgnoreCase("ATK2")) {
                newIVs.Attack = pixelmon2.stats.IVs.Attack;
                continue;
            }
            if (strStat.equalsIgnoreCase("DEF2")) {
                newIVs.Defence = pixelmon2.stats.IVs.Defence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPATK2")) {
                newIVs.SpAtt = pixelmon2.stats.IVs.SpAtt;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPDEF2")) {
                newIVs.SpDef = pixelmon2.stats.IVs.SpDef;
                continue;
            }
            if (!strStat.equalsIgnoreCase("SPD2")) continue;
            newIVs.Speed = pixelmon2.stats.IVs.Speed;
        }
        return newIVs;
    }

    public Moveset getEggMoveset(Entity10CanBreed eggPokemon, EnumPokemon pokemonSpecies, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        ArrayList<Attack> possibleEggMoves = DatabaseMoves.getAllEggAttacks(eggPokemon);
        ArrayList<Attack> lvl0Moves = DatabaseMoves.getAttacksAtLevel(eggPokemon, 0);
        ArrayList<Attack> levelupMoves = Entity10CanBreed.getLevelupMoves(eggPokemon, pixelmon1, pixelmon2);
        EntityPixelmon father = Entity10CanBreed.returnFather(pixelmon1, pixelmon2);
        ArrayList<Attack> fathersTMHMTutorMoves = Entity10CanBreed.getFathersTMHMTutorMoves(eggPokemon, father);
        ArrayList<Attack> fathersEggMoves = Entity10CanBreed.getEggMoves(eggPokemon, father, possibleEggMoves);
        ArrayList<Attack> mothersEggMoves = Entity10CanBreed.getEggMoves(eggPokemon, Entity10CanBreed.returnMother(pixelmon1, pixelmon2), possibleEggMoves);
        boolean canLearnVoltTackle = Entity10CanBreed.canLearnVoltTackle(pokemonSpecies, pixelmon1, pixelmon2);
        ArrayList<Attack> masterAttackList = new ArrayList<Attack>();
        if (canLearnVoltTackle) {
            Attack voltTackle = new Attack("Volt Tackle");
            masterAttackList.add(voltTackle);
            possibleEggMoves.add(voltTackle);
        }
        Entity10CanBreed.addAttacksToList(masterAttackList, mothersEggMoves);
        Entity10CanBreed.addAttacksToList(masterAttackList, fathersEggMoves);
        Entity10CanBreed.addAttacksToList(masterAttackList, fathersTMHMTutorMoves);
        Entity10CanBreed.addAttacksToList(masterAttackList, levelupMoves);
        Entity10CanBreed.addAttacksToList(masterAttackList, lvl0Moves);
        Moveset moveset = Entity10CanBreed.getFirstFourMoves(eggPokemon, masterAttackList);
        ArrayList<Attack> knownEggMoves = new ArrayList<Attack>(4);
        for (Attack move : moveset) {
            if (move == null || !possibleEggMoves.contains(move)) continue;
            knownEggMoves.add(move);
        }
        int numEggMoves = knownEggMoves.size();
        this.eggMoves = new int[numEggMoves];
        for (int i = 0; i < numEggMoves; ++i) {
            this.eggMoves[i] = ((Attack)knownEggMoves.get((int)i)).baseAttack.attackIndex;
        }
        return moveset;
    }

    public static ArrayList<Attack> getEggMoves(Entity6CanBattle pokemon, EntityPixelmon pixelmon1, ArrayList<Attack> allEggMoves) {
        ArrayList<Attack> eggMoves = new ArrayList<Attack>();
        if (pixelmon1 != null) {
            ArrayList<Attack> allBabyEggMoves = DatabaseMoves.getAllEggAttacks(pokemon);
            ArrayList<Attack> allParentsMoves = new ArrayList<Attack>(Arrays.asList(pixelmon1.getMoveset().attacks));
            eggMoves.addAll(allParentsMoves.stream().filter(attack -> Entity10CanBreed.listContains(allBabyEggMoves, attack)).collect(Collectors.toList()));
        }
        return eggMoves;
    }

    private static void addAttacksToList(ArrayList<Attack> masterList, ArrayList<Attack> addList) {
        for (Attack attack : addList) {
            if (masterList.contains(attack)) continue;
            masterList.add(attack);
        }
    }

    private static boolean listContains(ArrayList<Attack> list, Attack attack) {
        return list.contains(attack);
    }

    public static ArrayList<Attack> getFathersTMHMTutorMoves(Entity6CanBattle pokemon, EntityPixelmon pixelmon1) {
        ArrayList<Attack> tmhmTutorMoves = new ArrayList<Attack>();
        if (pixelmon1 != null) {
            ArrayList<Attack> allBabyTMHMTutorMoves = DatabaseMoves.getAllTMHMTutorAttacks(pokemon.baseStats.baseFormID);
            ArrayList<Attack> allFathersMoves = new ArrayList<Attack>(Arrays.asList(pixelmon1.getMoveset().attacks));
            tmhmTutorMoves.addAll(allFathersMoves.stream().filter(attack -> Entity10CanBreed.listContains(allBabyTMHMTutorMoves, attack)).collect(Collectors.toList()));
        }
        return tmhmTutorMoves;
    }

    public static EntityPixelmon returnFather(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        boolean is1Ditto = pixelmon1.isPokemon(EnumPokemon.Ditto);
        boolean is2Ditto = pixelmon2.isPokemon(EnumPokemon.Ditto);
        return !is1Ditto && !is2Ditto ? (pixelmon1.gender == Gender.Male ? pixelmon1 : pixelmon2) : (is1Ditto && pixelmon2.gender != Gender.Female ? pixelmon2 : (is2Ditto && pixelmon1.gender != Gender.Female ? pixelmon1 : null));
    }

    public static EntityPixelmon returnMother(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        boolean is1Ditto = pixelmon1.isPokemon(EnumPokemon.Ditto);
        boolean is2Ditto = pixelmon1.isPokemon(EnumPokemon.Ditto);
        return !is1Ditto && !is2Ditto ? (pixelmon1.gender == Gender.Female ? pixelmon1 : pixelmon2) : (is1Ditto && pixelmon2.gender != Gender.Male ? pixelmon2 : (is2Ditto && pixelmon1.gender != Gender.Male ? pixelmon1 : null));
    }

    public static ArrayList<Attack> getLevelupMoves(Entity6CanBattle pokemon, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        ArrayList<Attack> allBabyAttacks = DatabaseMoves.getAllAttacks(pokemon.baseStats.baseFormID);
        ArrayList<Attack> pixelmon1Attacks = new ArrayList<Attack>(Arrays.asList(pixelmon1.getMoveset().attacks));
        ArrayList<Attack> pixelmon2Attacks = new ArrayList<Attack>(Arrays.asList(pixelmon2.getMoveset().attacks));
        ArrayList levelupMoves = (ArrayList)allBabyAttacks.stream().filter(attack -> Entity10CanBreed.listContains(pixelmon1Attacks, attack) && Entity10CanBreed.listContains(pixelmon2Attacks, attack)).collect(Collectors.toList());
        return levelupMoves;
    }

    public static Moveset getFirstFourMoves(Entity6CanBattle pokemon, ArrayList<Attack> masterAttackList) {
        Moveset moveset = new Moveset(pokemon);
        moveset.set(0, DatabaseMoves.getAttack("Tackle"));
        moveset.set(1, null);
        moveset.set(2, null);
        moveset.set(3, null);
        if (!masterAttackList.isEmpty()) {
            for (int i = 0; i < Math.min(4, masterAttackList.size()); ++i) {
                if (masterAttackList.get(i) == null) continue;
                moveset.set(i, masterAttackList.get(i));
            }
        }
        return moveset;
    }

    public static boolean canBreed(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        boolean is1Ditto = pixelmon1.isPokemon(EnumPokemon.Ditto);
        boolean is2Ditto = pixelmon2.isPokemon(EnumPokemon.Ditto);
        EnumPokemon species1 = pixelmon1.getSpecies();
        EnumPokemon species2 = pixelmon2.getSpecies();
        if (!is1Ditto && !is2Ditto) {
            if (pixelmon1.gender == pixelmon2.gender) {
                return false;
            }
            if (pixelmon1.gender != Gender.None && pixelmon2.gender != Gender.None) {
                EnumEggGroup[] groupsMother;
                EnumEggGroup[] groupsFather;
                if (pixelmon1.gender == Gender.Male) {
                    groupsFather = EnumEggGroup.getEggGroups(species1);
                    groupsMother = EnumEggGroup.getEggGroups(species2);
                } else {
                    groupsFather = EnumEggGroup.getEggGroups(species2);
                    groupsMother = EnumEggGroup.getEggGroups(species1);
                }
                if (groupsFather != null && groupsMother != null) {
                    EnumEggGroup[] var16 = groupsFather;
                    int var9 = groupsFather.length;
                    for (int var17 = 0; var17 < var9; ++var17) {
                        EnumEggGroup groupFather = var16[var17];
                        EnumEggGroup[] var12 = groupsMother;
                        int var13 = groupsMother.length;
                        for (int var14 = 0; var14 < var13; ++var14) {
                            EnumEggGroup groupMother = var12[var14];
                            if (groupFather != groupMother || groupMother == EnumEggGroup.Undiscovered) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        if (is1Ditto && is2Ditto) {
            return PixelmonConfig.allowDittoDittoBreeding;
        }
        EnumEggGroup[] groupsFather = is1Ditto ? EnumEggGroup.getEggGroups(species2) : EnumEggGroup.getEggGroups(species1);
        EnumEggGroup[] groupsMother = groupsFather;
        int var8 = groupsFather.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            EnumEggGroup groupNonDitto = groupsMother[var9];
            if (groupNonDitto != EnumEggGroup.Undiscovered) continue;
            return false;
        }
        return true;
    }

    public static EnumPokemon getPokemonInEggName(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        boolean inherit1;
        boolean is1Ditto = pixelmon1.isPokemon(EnumPokemon.Ditto);
        boolean is2Ditto = pixelmon2.isPokemon(EnumPokemon.Ditto);
        ItemStack item1 = pixelmon1.func_184614_ca();
        ItemStack item2 = pixelmon2.func_184614_ca();
        if (!is1Ditto && !is2Ditto) {
            inherit1 = pixelmon2.gender == Gender.Male;
        } else {
            if (is1Ditto && is2Ditto) {
                return EnumPokemon.randomPoke(PixelmonConfig.allowRandomBreedingEggsToBeLegendary);
            }
            inherit1 = is2Ditto;
        }
        return inherit1 ? Entity10CanBreed.getEggForm(pixelmon1, item1, item2) : Entity10CanBreed.getEggForm(pixelmon2, item2, item1);
    }

    public static EnumPokemon getEggForm(EntityPixelmon parentForEggLine, ItemStack itemParentForEggLine, ItemStack itemOtherParent) {
        if (parentForEggLine.isPokemon(EnumPokemon.Nidoranfemale, EnumPokemon.Nidoranmale, EnumPokemon.Nidorino, EnumPokemon.Nidoking)) {
            EnumPokemon[] eggForms = new EnumPokemon[]{EnumPokemon.Nidoranfemale, EnumPokemon.Nidoranmale};
            return RandomHelper.getRandomElementFromArray(eggForms);
        }
        if (parentForEggLine.isPokemon(EnumPokemon.Illumise, EnumPokemon.Volbeat)) {
            EnumPokemon[] eggForms = new EnumPokemon[]{EnumPokemon.Illumise, EnumPokemon.Volbeat};
            return RandomHelper.getRandomElementFromArray(eggForms);
        }
        if (parentForEggLine.isPokemon(EnumPokemon.Manaphy)) {
            return EnumPokemon.Phione;
        }
        Item itemTypeParent = null;
        if (itemParentForEggLine != null) {
            itemTypeParent = itemParentForEggLine.func_77973_b();
        }
        Item itemTypeOther = null;
        if (itemOtherParent != null) {
            itemTypeOther = itemOtherParent.func_77973_b();
        }
        return Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.seaIncense, EnumPokemon.Azurill, EnumPokemon.Marill, EnumPokemon.Azumarill) ? EnumPokemon.Marill : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.laxIncense, EnumPokemon.Wynaut, EnumPokemon.Wobbuffet) ? EnumPokemon.Wobbuffet : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.roseIncense, EnumPokemon.Budew, EnumPokemon.Roselia, EnumPokemon.Roserade) ? EnumPokemon.Roselia : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.pureIncense, EnumPokemon.Chingling, EnumPokemon.Chimecho) ? EnumPokemon.Chimecho : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.rockIncense, EnumPokemon.Bonsly, EnumPokemon.Sudowoodo) ? EnumPokemon.Sudowoodo : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.oddIncense, EnumPokemon.MimeJr, EnumPokemon.MrMime) ? EnumPokemon.MrMime : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.luckIncense, EnumPokemon.Happiny, EnumPokemon.Chansey, EnumPokemon.Blissey) ? EnumPokemon.Chansey : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.waveIncense, EnumPokemon.Mantyke, EnumPokemon.Mantine) ? EnumPokemon.Mantine : (Entity10CanBreed.checkIncense(itemTypeParent, itemTypeOther, parentForEggLine, PixelmonItemsHeld.fullIncense, EnumPokemon.Munchlax, EnumPokemon.Snorlax) ? EnumPokemon.Snorlax : Entity10CanBreed.getBasicPokemonForm(parentForEggLine.baseStats.pokemon)))))))));
    }

    private static boolean checkIncense(Item itemTypeParent, Item itemTypeOther, EntityPixelmon parentForEggLine, Item neededItem, EnumPokemon baby, EnumPokemon ... parents) {
        return parentForEggLine.isPokemon(parents) && (itemTypeParent != neededItem && itemTypeOther != neededItem || parentForEggLine.isAvailableGeneration() && !Entity10CanBreed.isAvailableGeneration(baby));
    }

    public static EnumPokemon getBasicPokemonForm(EnumPokemon pokemon) {
        try {
            Optional<BaseStats> optional = DatabaseStats.getBaseStats(pokemon.name);
            if (optional.isPresent()) {
                BaseStats store = optional.get();
                if (store.preEvolutions != null && store.preEvolutions.length > 0) {
                    EnumPokemon preEvolution = store.preEvolutions[0];
                    return !Entity10CanBreed.isAvailableGeneration(preEvolution) && Entity10CanBreed.isAvailableGeneration(pokemon) ? pokemon : Entity10CanBreed.getBasicPokemonForm(preEvolution);
                }
                return pokemon;
            }
            throw new IllegalStateException("Could not load stats from database!");
        }
        catch (Exception var4) {
            Pixelmon.LOGGER.error("Error getting basic Pok\u00c3\u00a9mon form for " + pokemon.name + ".");
            var4.printStackTrace();
            return pokemon;
        }
    }

    public String getEggDescripion() {
        return Entity10CanBreed.getEggDescription(this.eggCycles);
    }

    public static String getEggDescription(Integer cycles) {
        return cycles < 5 ? I18n.func_74838_a((String)"pixelmon.egg.stage1") : (cycles < 10 ? I18n.func_74838_a((String)"pixelmon.egg.stage2") : (cycles < 40 ? I18n.func_74838_a((String)"pixelmon.egg.stage3") : I18n.func_74838_a((String)"pixelmon.egg.stage4")));
    }

    public EnumEggGroup getRandomEggGroupForPokemon() {
        return Entity10CanBreed.getRandomEggGroupForPokemon(this.getSpecies());
    }

    public static EnumEggGroup getRandomEggGroupForPokemon(EnumPokemon pokemon) {
        EnumEggGroup[] eggGroups = EnumEggGroup.getEggGroups(pokemon);
        try {
            return eggGroups[RandomHelper.rand.nextInt(eggGroups.length)];
        }
        catch (Exception var3) {
            Pixelmon.LOGGER.error("Error finding Egg Group for Pok\u00c3\u00a9mon: " + pokemon.name + ".");
            var3.printStackTrace();
            return null;
        }
    }

    public static EnumEggGroup getEggGroupForPair(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        EnumEggGroup[] groups1 = EnumEggGroup.getEggGroups(pixelmon1.getSpecies());
        EnumEggGroup[] groups2 = EnumEggGroup.getEggGroups(pixelmon2.getSpecies());
        ArrayList<EnumEggGroup> groupsEgg = new ArrayList<EnumEggGroup>();
        EnumEggGroup[] var5 = groups1;
        int var6 = groups1.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            EnumEggGroup group1 = var5[var7];
            EnumEggGroup[] var9 = groups2;
            int var10 = groups2.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                EnumEggGroup group2 = var9[var11];
                if (group1 != group2 || group2 == EnumEggGroup.Undiscovered) continue;
                groupsEgg.add(group2);
            }
        }
        if (groupsEgg.isEmpty()) {
            return EnumEggGroup.Undiscovered;
        }
        return (EnumEggGroup)((Object)RandomHelper.getRandomElementFromList(groupsEgg));
    }

    public static EnumGrowth getEggGrowth(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        int ordinal;
        double averageOrdinal = (pixelmon1.getGrowth().scaleOrdinal + pixelmon2.getGrowth().scaleOrdinal) / 2;
        if ((double)((int)averageOrdinal) != averageOrdinal) {
            double d = averageOrdinal = RandomHelper.getRandomChance() ? Math.floor(averageOrdinal) : Math.ceil(averageOrdinal);
        }
        if ((ordinal = (int)averageOrdinal) <= 0) {
            ordinal = 1;
        }
        if (ordinal >= 8) {
            ordinal = 7;
        }
        int rand = RandomHelper.getRandomNumberBetween(ordinal - 1, ordinal + 1);
        return EnumGrowth.getGrowthFromScaleOrdinal(rand);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.isInRanchBlock && super.func_70097_a(source, amount);
    }

    public void resetBreedingLevel() {
        this.setNumBreedingLevels(0);
        this.lastBreedingTime = this.field_70170_p.func_82737_E();
    }

    public boolean readyToMakeEgg() {
        return this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels;
    }

    public ParticleEffects[] getBreedingParticleEffects() {
        ArrayList<BreedingParticles> effects = new ArrayList<BreedingParticles>();
        if (this.getNumBreedingLevels() > 0) {
            effects.add(new BreedingParticles(this));
        }
        return !effects.isEmpty() ? effects.toArray(new ParticleEffects[effects.size()]) : null;
    }

    public void updateBreeding() {
        if (this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) {
            this.setNumBreedingLevels(PixelmonConfig.numBreedingLevels);
        } else {
            this.refreshBreedingStrength();
            TileEntityRanchBase ranch = ((RanchBounds)this.blockOwner.getBounds()).ranch;
            if (this.breedingStrength == EnumBreedingStrength.NONE) {
                this.lastBreedingTime = this.field_70170_p.func_82737_E();
                if (this.getNumBreedingLevels() > 0) {
                    BreedEvent.BreedingLevelChanged event = new BreedEvent.BreedingLevelChanged(this.func_184753_b(), ranch, (EntityPixelmon)this, this.getNumBreedingLevels(), this.getNumBreedingLevels() - 1);
                    Pixelmon.EVENT_BUS.post((Event)event);
                    this.setNumBreedingLevels(event.getNewLevel());
                }
            } else {
                long currentTime = this.field_70170_p.func_82737_E();
                int breedingTicks = PixelmonConfig.breedingTicks;
                BreedEvent.BreedingTicks ticksEvent = new BreedEvent.BreedingTicks(this.func_184753_b(), ranch, (EntityPixelmon)this, breedingTicks);
                Pixelmon.EVENT_BUS.post((Event)ticksEvent);
                breedingTicks = ticksEvent.getBreedingTicks();
                while ((float)(currentTime - this.lastBreedingTime) - (float)breedingTicks / this.breedingStrength.value >= 0.0f) {
                    BreedEvent.BreedingLevelChanged levelChangedEvent = new BreedEvent.BreedingLevelChanged(this.func_184753_b(), ranch, (EntityPixelmon)this, this.getNumBreedingLevels(), this.getNumBreedingLevels() + 1);
                    Pixelmon.EVENT_BUS.post((Event)levelChangedEvent);
                    this.setNumBreedingLevels(levelChangedEvent.getNewLevel());
                    this.lastBreedingTime = (long)((float)this.lastBreedingTime + (float)breedingTicks / this.breedingStrength.value);
                }
                if (this.getNumBreedingLevels() == PixelmonConfig.numBreedingLevels && this.blockOwner != null) {
                    this.blockOwner.updateStatus();
                }
            }
        }
    }

    public void refreshBreedingStrength() {
        float breedingStrengthFloat = -1.0f;
        if (PixelmonConfig.useBreedingEnvironment) {
            BreedingConditions conditions = ((RanchBounds)this.blockOwner.getBounds()).getContainingBreedingConditions(this.field_70170_p);
            breedingStrengthFloat = conditions.getBreedingStrength(this.type);
        } else {
            breedingStrengthFloat = 2.0f;
        }
        RanchBounds bounds = (RanchBounds)this.blockOwner.getBounds();
        TileEntityRanchBase ranch = bounds.ranch;
        BreedEvent.EnvironmentStrength strengthEvent = new BreedEvent.EnvironmentStrength(this.func_184753_b(), ranch, (EntityPixelmon)this, bounds, breedingStrengthFloat);
        Pixelmon.EVENT_BUS.post((Event)strengthEvent);
        this.breedingStrength = EnumBreedingStrength.of(strengthEvent.breedingStrength);
    }
}

