/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public abstract class Entity1Base
extends EntityTameable {
    private EnumPokemon species;
    public EnumPokeballs caughtBall;
    public EntityPokeBall hitByPokeball = null;
    @Deprecated
    public Gender gender;
    public boolean isInBall = false;
    public boolean isFainted = false;
    public boolean isInitialised = false;
    public String originalTrainer = "";
    public boolean canDespawn = true;
    protected int entityAge = 0;
    protected EnumBossMode serverBossMode;

    public Entity1Base(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwName, (Object)"");
        this.field_70180_af.func_187214_a(EntityPixelmon.dwNickname, (Object)"");
        this.field_70180_af.func_187214_a(EntityPixelmon.dwPokemonID1, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwPokemonID2, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwBossMode, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwNature, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwGrowth, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwSpawnLocation, (Object)-1);
    }

    protected void init(String name) {
        this.setName(name);
        if (this.getBossMode() == null) {
            this.setBoss(EnumBossMode.NotBoss);
        }
        if (this.getNature() == null) {
            this.setNature(EnumNature.getRandomNature());
        }
        if (this.getGrowth() == null) {
            this.setGrowth(EnumGrowth.getRandomGrowth());
        }
    }

    public EnumPokemon getSpecies() {
        return this.species;
    }

    public String getPokemonName() {
        return (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwName);
    }

    public String getLocalizedName() {
        return Entity1Base.getLocalizedName(this.getPokemonName());
    }

    public String getLocalizedDescription() {
        return Entity1Base.getLocalizedDescription(this.getPokemonName());
    }

    public String getNickname() {
        String nickname = (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwNickname);
        if (!PixelmonConfig.allowNicknames || nickname.isEmpty()) {
            return this.getLocalizedName();
        }
        return nickname;
    }

    public String getEscapedNickname() {
        return Matcher.quoteReplacement(this.getNickname());
    }

    public void setNickname(String nickname) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwNickname, (Object)nickname);
    }

    public boolean hasNickname() {
        return !((String)this.field_70180_af.func_187225_a(EntityPixelmon.dwNickname)).equals("");
    }

    public int[] getPokemonId() {
        return new int[]{(Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwPokemonID1), (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwPokemonID2)};
    }

    public void setPokemonId(int[] id) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwPokemonID1, (Object)id[0]);
        this.field_70180_af.func_187227_b(EntityPixelmon.dwPokemonID2, (Object)id[1]);
    }

    public EnumBossMode getBossMode() {
        if (!this.field_70170_p.field_72995_K) {
            return this.serverBossMode;
        }
        return EnumBossMode.getMode((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwBossMode));
    }

    public void setBoss(EnumBossMode mode) {
        this.serverBossMode = mode;
        this.field_70180_af.func_187227_b(EntityPixelmon.dwBossMode, (Object)mode.index);
    }

    public boolean isBossPokemon() {
        return this.getBossMode().isBossPokemon();
    }

    public EnumNature getNature() {
        return EnumNature.getNatureFromIndex((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwNature));
    }

    public void setNature(EnumNature nature) {
        if (nature != null) {
            this.field_70180_af.func_187227_b(EntityPixelmon.dwNature, (Object)nature.index);
        }
    }

    public EnumGrowth getGrowth() {
        return EnumGrowth.getGrowthFromIndex((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwGrowth));
    }

    public void setGrowth(EnumGrowth growth) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwGrowth, (Object)growth.index);
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.field_70180_af.func_187227_b(EntityPixelmon.dwGender, (Object)gender.ordinal());
    }

    public Gender getGender() {
        int gender = (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwGender);
        return Gender.getGender((short)gender);
    }

    public SpawnLocation getSpawnLocation() {
        return SpawnLocation.getFromIndex((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwSpawnLocation));
    }

    public void setSpawnLocation(SpawnLocation spawnLocation) {
        if (spawnLocation == null) {
            spawnLocation = SpawnLocation.Land;
        }
        this.field_70180_af.func_187227_b(EntityPixelmon.dwSpawnLocation, (Object)spawnLocation.ordinal());
    }

    public boolean hasOwner() {
        return this.func_184753_b() != null;
    }

    public boolean belongsTo(EntityPlayer player) {
        return this.func_70902_q() == player;
    }

    public void update(EnumUpdateType ... types) {
        Optional<PlayerStorage> storage;
        if (this.isInitialised && (storage = this.getStorage()).isPresent()) {
            storage.get().updateAndSendToClient((EntityPixelmon)this, types);
        }
    }

    public Optional<PlayerStorage> getStorage() {
        EntityPlayerMP owner = PixelmonStorage.pokeBallManager.getPlayerFromUUID(this.field_70170_p.func_73046_m(), this.func_184753_b());
        return PixelmonStorage.pokeBallManager.getPlayerStorage(owner);
    }

    public String func_70005_c_() {
        return this.getLocalizedName();
    }

    public void setName(String name) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwName, (Object)name);
        this.species = EnumPokemon.getFromName(name).orElse(null);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.55);
    }

    public boolean func_70094_T() {
        if (super.func_70094_T()) {
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(1, 0, 0)).func_177230_c().func_149688_o(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(1, 0, 0))) == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v);
            }
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(-1, 0, 0)).func_177230_c().func_149688_o(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(-1, 0, 0))) == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v);
            }
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, 1, 0)).func_177230_c().func_149688_o(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, 1, 0))) == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
            }
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c().func_149688_o(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0))) == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
            }
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, 0, 1)).func_177230_c().func_149688_o(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, 0, 1))) == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0);
            }
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, 0, -1)).func_177230_c().func_149688_o(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, 0, -1))) == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0);
            }
            return true;
        }
        return false;
    }

    public boolean func_70104_M() {
        return true;
    }

    public int func_70874_b() {
        return 0;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void func_70106_y() {
        Optional<PlayerStorage> storage;
        if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K && (storage = this.getStorage()).isPresent()) {
            storage.get().retrieve((EntityPixelmon)this);
        }
        super.func_70106_y();
    }

    public void func_70071_h_() {
        ++this.entityAge;
        super.func_70071_h_();
        if (!this.isInitialised) {
            this.init(this.getPokemonName());
            this.isInitialised = true;
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("pixelmonID1", ((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwPokemonID1)).intValue());
        nbt.func_74768_a("pixelmonID2", ((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwPokemonID2)).intValue());
        nbt.func_74778_a("Name", (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwName));
        nbt.func_74778_a("Nickname", (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwNickname));
        if (this.caughtBall != null) {
            nbt.func_74768_a("CaughtBall", this.caughtBall.ordinal());
        }
        nbt.func_74777_a("Gender", (short)this.getGender().ordinal());
        nbt.func_74757_a("IsInBall", this.isInBall);
        nbt.func_74757_a("IsFainted", this.isFainted);
        nbt.func_74777_a("BossMode", (short)((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwBossMode)).intValue());
        nbt.func_74777_a("Nature", (short)((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwNature)).intValue());
        nbt.func_74777_a("Growth", (short)((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwGrowth)).intValue());
        nbt.func_74778_a("originalTrainer", this.originalTrainer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (!nbt.func_74764_b("pixelmonID1")) {
            if (this.func_70902_q() != null) {
                this.func_174812_G();
            }
            nbt.func_74768_a("pixelmonID1", -1);
            nbt.func_74768_a("pixelmonID2", -1);
        }
        this.field_70180_af.func_187227_b(EntityPixelmon.dwPokemonID1, (Object)nbt.func_74762_e("pixelmonID1"));
        this.field_70180_af.func_187227_b(EntityPixelmon.dwPokemonID2, (Object)nbt.func_74762_e("pixelmonID2"));
        this.setName(nbt.func_74779_i("Name"));
        if (!this.isInitialised) {
            this.init(this.getPokemonName());
        }
        this.isInitialised = true;
        if (nbt.func_74764_b("Nickname")) {
            this.field_70180_af.func_187227_b(EntityPixelmon.dwNickname, (Object)nbt.func_74779_i("Nickname"));
        }
        if (nbt.func_74764_b("CaughtBall")) {
            this.caughtBall = EnumPokeballs.getFromIndex(nbt.func_74762_e("CaughtBall"));
        }
        if (nbt.func_74764_b("IsMale")) {
            this.setGender(nbt.func_74767_n("IsMale") ? Gender.Male : Gender.Female);
        }
        this.setGender(Gender.getGender(nbt.func_74765_d("Gender")));
        if (this instanceof EntityPixelmon && ((EntityPixelmon)this).baseStats.malePercent < 0) {
            this.setGender(Gender.None);
        }
        this.isInBall = nbt.func_74767_n("IsInBall");
        this.isFainted = nbt.func_74767_n("IsFainted");
        if (nbt.func_74764_b("BossMode")) {
            this.setBoss(EnumBossMode.getMode(nbt.func_74765_d("BossMode")));
        } else {
            this.setBoss(EnumBossMode.NotBoss);
        }
        if (nbt.func_74764_b("Nature")) {
            this.field_70180_af.func_187227_b(EntityPixelmon.dwNature, (Object)nbt.func_74765_d("Nature"));
        } else {
            this.setNature(EnumNature.getRandomNature());
        }
        if (nbt.func_74764_b("Growth")) {
            this.field_70180_af.func_187227_b(EntityPixelmon.dwGrowth, (Object)nbt.func_74765_d("Growth"));
        } else {
            this.setGrowth(EnumGrowth.Ordinary);
        }
        if (nbt.func_74764_b("originalTrainer")) {
            this.originalTrainer = nbt.func_74779_i("originalTrainer");
        }
    }

    public void getNBTTags(HashMap<String, Class> tags) {
        tags.put("pixelmonID1", Integer.class);
        tags.put("pixelmonID2", Integer.class);
        tags.put("Name", String.class);
        tags.put("Nickname", String.class);
        tags.put("CaughtBall", Integer.class);
        tags.put("Gender", Short.class);
        tags.put("IsFainted", Boolean.class);
        tags.put("BossMode", Short.class);
        tags.put("Nature", Short.class);
        tags.put("Growth", Short.class);
        tags.put("originalTrainer", String.class);
        tags.put("PixelmonOrder", Integer.class);
        tags.put("BoxNumber", Integer.class);
    }

    public static String getLocalizedDescription(String name) {
        return I18n.func_74838_a((String)("pixelmon." + name.toLowerCase() + ".description"));
    }

    public static String getLocalizedName(String name) {
        return I18n.func_74838_a((String)("pixelmon." + name.toLowerCase() + ".name"));
    }

    public static String getLocalizedName(EnumPokemon pokemon) {
        return Entity1Base.getLocalizedName(pokemon.name);
    }
}

