/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.DatabaseAbilities;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity2HasModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.BossInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FriendShip;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.TickHandlerBase;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.forms.EnumForms;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class Entity3HasStats
extends Entity2HasModel {
    public static final EnumMap<EnumPokemon, BaseStats> baseStatsStore1 = new EnumMap(EnumPokemon.class);
    public static final Map<String, BaseStats> baseStatsFormStore = new HashMap<String, BaseStats>();
    public Stats stats;
    public BaseStats baseStats;
    public FriendShip friendship;
    public ArrayList<EnumType> type = new ArrayList();
    public float length;
    public boolean doesLevel = true;
    public ExtraStats extraStats = null;
    public boolean isMega;
    public Level level;
    public String oldName;
    public int oldForm = -1;
    public AbilityBase ability;
    public Integer abilitySlot;
    public TickHandlerBase tickHandler;
    public FlyingParameters bossFlyingParameters = null;
    public SwimmingParameters bossSwimmingParameters = null;

    public Entity3HasStats(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwScale, (Object)1000);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwForm, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwGender, (Object)2);
        this.stats = new Stats();
        if (this instanceof EntityPixelmon) {
            this.level = new Level((EntityPixelmon)this);
            this.friendship = new FriendShip((EntityPixelmon)this);
        }
        this.field_70180_af.func_187214_a(EntityPixelmon.dwMaxHP, (Object)10);
    }

    @Override
    protected void init(String name) {
        super.init(name);
        this.oldName = name;
        this.oldForm = this.getForm();
        if (this.baseStats == null) {
            Optional<BaseStats> optBs = Entity3HasStats.getBaseStats(name, this.getForm());
            if (!optBs.isPresent()) {
                Pixelmon.LOGGER.error("Cannot find base stats for " + name + " with form " + this.getForm());
            }
            this.baseStats = optBs.orElse(null);
        }
        if (this.baseStats == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        } else {
            this.extraStats = this.getExtraStats(name);
            this.stats.IVs = EnumPokemon.legendaries.contains(name) ? IVStore.CreateNewIVs3Perfect() : IVStore.CreateNewIVs();
            this.setType();
            this.length = this.baseStats.length;
            if (!this.field_70170_p.field_72995_K && (this.gender == null || this.getGender() == Gender.Male && this.baseStats.malePercent <= 0 || this.getGender() == Gender.Female && (this.baseStats.malePercent == 100 || this.baseStats.malePercent < 0) || this.getGender() == Gender.None && this.baseStats.malePercent >= 0)) {
                this.chooseRandomGender();
            }
            this.field_70178_ae = this.type.contains((Object)EnumType.Fire);
            if (!(this instanceof EntityStatue) && this.level.getLevel() == -1) {
                int spawnLevelRange = this.baseStats.spawnLevelRange;
                int spawnLevel = this.baseStats.spawnLevel;
                if (spawnLevelRange <= 0) {
                    this.level.setLevel(spawnLevel);
                } else {
                    this.level.setLevel(spawnLevel + this.field_70146_Z.nextInt(spawnLevelRange));
                }
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.stats.HP);
                this.func_70606_j(this.stats.HP);
            }
            if (this.getAbility() == null) {
                this.giveAbility();
            }
            if (this.getForm() == -1 && this.hasForms() && PixelmonModelRegistry.getModel(this.getSpecies(), this.getFormEnum()) == null) {
                this.setForm(Entity3HasStats.getRandomForm(this.getSpecies()));
                if (this.func_70902_q() != null) {
                    this.update(EnumUpdateType.Name, EnumUpdateType.Stats, EnumUpdateType.Texture);
                }
            }
            this.func_70105_a(this.baseStats.width, this.baseStats.height + this.baseStats.hoverHeight);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this instanceof EntityPixelmon) {
                this.tickHandler = TickHandlerBase.getTickHandler((EntityPixelmon)this);
            }
        }
    }

    public int getCatchRate() {
        float c = this.baseStats.catchRate;
        return (int)c;
    }

    public Level getLvl() {
        return this.level;
    }

    private ExtraStats getExtraStats(String name) {
        return ExtraStats.getExtraStats(name);
    }

    float getMoveSpeed() {
        return 0.3f + (1.0f - (200.0f - (float)this.stats.Speed) / 200.0f) * 0.3f;
    }

    private void setType() {
        this.type.clear();
        this.type.add(this.baseStats.type1);
        if (this.baseStats.type2 != EnumType.Mystery) {
            this.type.add(this.baseStats.type2);
        }
    }

    @Override
    public void evolve(PokemonSpec evolveTo) {
        super.evolve(evolveTo);
        int form = this.getForm();
        if (evolveTo.form != null) {
            form = evolveTo.form;
        }
        float oldHp = this.stats.HP;
        float oldHealth = this.func_110143_aJ();
        if (!Entity3HasStats.getBaseStats(evolveTo.name, form).isPresent()) {
            return;
        }
        this.baseStats = Entity3HasStats.getBaseStats(evolveTo.name, form).get();
        if (evolveTo.form != null) {
            this.setForm(evolveTo.form, false);
        } else if (this.getForm() == -1) {
            this.setForm(0, false);
        }
        this.setType();
        String[] oldAbilities = DatabaseAbilities.getAbilities(this.getPokemonName());
        String[] newAbilities = this.baseStats.abilities;
        Integer newSlot = this.getAbilitySlot();
        if (this.getAbilitySlot() == 0 && oldAbilities[1] == null && newAbilities[1] != null) {
            newSlot = RandomHelper.getRandomNumberBetween(0, 1);
        }
        if (this.getAbilitySlot() == 1 && newAbilities[1] == null) {
            newSlot = 0;
        }
        this.setAbilitySlot(newSlot);
        String chosenAbility = newAbilities[newSlot];
        this.setAbility(chosenAbility);
        if (!this.hasForms() && this.getForm() > -1) {
            this.setForm(-1);
        }
        this.updateStats();
        float newHealth = this.stats.HP;
        if (oldHp != 0.0f) {
            newHealth = oldHealth / oldHp * (float)this.stats.HP;
        }
        this.func_70606_j((int)Math.ceil(newHealth));
        Optional<PlayerStorage> storage = this.getStorage();
        if (storage.isPresent()) {
            Pokedex pokedex = storage.get().pokedex;
            pokedex.set(Pokedex.nameToID(this.getPokemonName()), EnumPokedexRegisterStatus.caught);
            pokedex.sendToPlayer((EntityPlayerMP)pokedex.owner);
        }
        if (this.func_70902_q() != null) {
            this.update(EnumUpdateType.Name, EnumUpdateType.Stats);
        }
    }

    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        this.updateHealth();
    }

    public void updateHealth() {
        if (this.stats != null && this.func_110143_aJ() > this.func_110138_aP()) {
            super.func_70606_j(this.func_110138_aP());
        }
        if (this.func_110143_aJ() < 0.0f) {
            super.func_70606_j(0.0f);
        }
        if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K) {
            this.update(EnumUpdateType.HP);
        }
    }

    public float getPixelmonScale() {
        return (float)((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwScale)).intValue() / 1000.0f;
    }

    public void setPixelmonScale(float scale) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwScale, (Object)((int)(scale * 1000.0f)));
    }

    public void updateStats() {
        if (this.level != null) {
            this.stats.setLevelStats(this.getNature(), this.baseStats, this.level.getLevel());
            this.field_70180_af.func_187227_b(EntityPixelmon.dwMaxHP, (Object)this.stats.HP);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.stats.HP);
            this.updateHealth();
        }
    }

    public AbilityBase getAbility() {
        return this.ability;
    }

    public void setAbility(AbilityBase newAbility) {
        this.ability = newAbility;
    }

    public void setAbility(String abilityName) {
        block2: {
            try {
                Optional<AbilityBase> abilityOptional = AbilityBase.getAbility(abilityName);
                this.ability = abilityOptional.orElseGet(() -> new ComingSoon(abilityName));
            }
            catch (Exception exception) {
                Pixelmon.LOGGER.info("Entity3HasStats.setAbility() is erroring and it is weird.");
                if (!PixelmonConfig.printErrors) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void giveAbility() {
        String abilityName = "";
        if (this.getSpecies() == EnumPokemon.Greninja || this.oldName.equalsIgnoreCase("Greninja")) {
            this.abilitySlot = 0;
            abilityName = this.baseStats.abilities[this.abilitySlot];
            this.setAbility(abilityName);
            return;
        }
        if (this.baseStats.abilities != null && (PixelmonConfig.hiddenAbilityRate <= 0 || this.baseStats.abilities[2] == null || RandomHelper.getRandomNumberBetween(1, PixelmonConfig.hiddenAbilityRate) != 1)) {
            this.abilitySlot = this.baseStats.abilities[1] != null ? Integer.valueOf(RandomHelper.getRandomNumberBetween(0, 1)) : Integer.valueOf(0);
            abilityName = this.baseStats.abilities[this.abilitySlot];
            this.setAbility(abilityName);
        } else {
            this.abilitySlot = 2;
            if (this.baseStats.abilities != null) {
                if (this.baseStats.abilities[this.abilitySlot] != null) {
                    abilityName = this.baseStats.abilities[this.abilitySlot];
                    this.setAbility(abilityName);
                } else {
                    this.ability = new ComingSoon(abilityName);
                }
            }
        }
    }

    public Integer getAbilitySlot() {
        return this.abilitySlot;
    }

    public void setAbilitySlot(Integer slot) {
        this.abilitySlot = Math.max(0, Math.min(2, slot));
    }

    public void giveAbilitySlot() {
        Integer slot = DatabaseAbilities.getSlotForAbility(this.baseStats.id, this.ability.getName());
        this.abilitySlot = slot == null ? Integer.valueOf(0) : slot;
    }

    public void setRandomAbilityUniform() {
        String[] abilities;
        ArrayList<String> randomAbilities = new ArrayList<String>();
        for (String ability : abilities = this.baseStats.abilities) {
            if (ability == null) continue;
            randomAbilities.add(ability);
        }
        if (!randomAbilities.isEmpty()) {
            this.setAbility((String)RandomHelper.getRandomElementFromList(randomAbilities));
        }
    }

    public static String getAbility(EnumPokemon species, int form, int slot) {
        Optional<BaseStats> optBs = EntityPixelmon.getBaseStats(species, form);
        if (optBs.isPresent()) {
            BaseStats bs = optBs.get();
            return bs.abilities[slot] != null ? bs.abilities[slot] : bs.abilities[0];
        }
        return "SwiftSwim";
    }

    public int getForm() {
        return (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwForm);
    }

    public IEnumForm getFormEnum() {
        return Gender.mfModels.contains((Object)this.getSpecies()) ? this.getGender() : this.getSpecies().getFormEnum(this.getForm());
    }

    public void setForm(int form) {
        this.setForm(form, true);
    }

    public void setForm(int form, boolean update) {
        boolean needsUpdate = true;
        if (this.baseStats != null) {
            boolean formChange = false;
            if (!this.hasForms() && !this.isMega) {
                if (this.baseStats.pokemon.hasMega() && this instanceof EntityStatue) {
                    int numForms = EnumMegaPokemon.getMega((EnumPokemon)this.baseStats.pokemon).numMegaForms;
                    if (form > numForms || form == 0 || form < -1) {
                        form = -1;
                    }
                    formChange = true;
                } else {
                    form = -1;
                }
            } else {
                formChange = true;
            }
            if (formChange) {
                this.baseStats = Entity3HasStats.getBaseStats(this.baseStats.pokemon, form).get();
                this.setType();
                if (this.isMega) {
                    this.setAbility(this.baseStats.abilities[form > -1 ? 0 : this.getAbilitySlot()]);
                } else {
                    this.setAbility(EntityPixelmon.getAbility(this.getSpecies(), form, this.getAbilitySlot()));
                }
                needsUpdate = true;
            }
        }
        this.field_70180_af.func_187227_b(EntityPixelmon.dwForm, (Object)form);
        if (this instanceof EntityPixelmon && update && needsUpdate) {
            this.updateStats();
            this.update(EnumUpdateType.Stats);
            EntityPixelmon pokemon = (EntityPixelmon)this;
            if (pokemon.battleController != null) {
                pokemon.battleController.updateFormChange(pokemon);
            }
        }
    }

    public boolean hasForms() {
        return this.baseStats != null && Entity3HasStats.hasForms(this.baseStats.pokemon);
    }

    public int getNumForms() {
        return this.hasForms() ? Entity3HasStats.getNumForms(this.baseStats.pokemon) : 0;
    }

    public int getFormIncludeTransformed() {
        return this.transformed ? this.transformedForm : this.getForm();
    }

    public int getPartyPosition() {
        Optional<PlayerStorage> storage = this.getStorage();
        return storage.map(playerStorage -> playerStorage.getPosition(this.getPokemonId())).orElse(-1);
    }

    public boolean isAvailableGeneration() {
        return Entity3HasStats.isAvailableGeneration(this.getPokemonName());
    }

    public void chooseRandomGender() {
        this.setGender(Entity3HasStats.getRandomGender(this.baseStats));
    }

    public SpawnLocation getDefaultSpawnLocation() {
        return this.baseStats != null && this.baseStats.spawnLocations != null && this.baseStats.spawnLocations.length > 0 ? this.baseStats.spawnLocations[0] : SpawnLocation.Land;
    }

    public FlyingParameters getFlyingParameters() {
        BossInfo info;
        if (this.bossFlyingParameters != null) {
            return this.bossFlyingParameters;
        }
        if (this.isBossPokemon() && this.baseStats.pokemon.hasMega() && (info = DropItemRegistry.getBossPokemon(this.baseStats.pokemon)) != null) {
            this.bossFlyingParameters = info.flyingParameters;
            return this.bossFlyingParameters;
        }
        return this.baseStats.flyingParameters;
    }

    public SwimmingParameters getSwimmingParameters() {
        BossInfo info;
        if (this.bossSwimmingParameters != null) {
            return this.bossSwimmingParameters;
        }
        if (this.isBossPokemon() && this.baseStats.pokemon.hasMega() && (info = DropItemRegistry.getBossPokemon(this.baseStats.pokemon)) != null) {
            this.bossSwimmingParameters = info.swimmingParameters;
            return this.bossSwimmingParameters;
        }
        return this.baseStats.swimmingParameters;
    }

    public BaseStats initializeBaseStatsIfNull() {
        if (this.baseStats == null) {
            String name = this.func_70005_c_();
            this.baseStats = Entity3HasStats.getBaseStats(name, this.getForm()).orElse(null);
            if (this.baseStats == null) {
                this.baseStats = Entity3HasStats.getBaseStats(name).orElse(null);
            }
            if (this.baseStats == null) {
                this.baseStats = Entity3HasStats.getBaseStats(EnumPokemon.Bulbasaur).orElse(null);
            }
        }
        return this.baseStats;
    }

    public void func_70645_a(DamageSource cause) {
        boolean showDeathMessages = this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
        this.field_70170_p.func_82736_K().func_82764_b("showDeathMessages", "false");
        super.func_70645_a(cause);
        this.field_70170_p.func_82736_K().func_82764_b("showDeathMessages", showDeathMessages ? "true" : "false");
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this instanceof EntityStatue) {
            return false;
        }
        if (source.func_76364_f() == this.func_70902_q()) {
            this.friendship.hurtByOwner();
        }
        return super.func_70097_a(source, amount);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.baseStats != null) {
            if (this.getSpawnLocation() == SpawnLocation.Water) {
                return;
            }
            if (this.baseStats.canFly) {
                return;
            }
        }
        super.func_180430_e(distance, damageMultiplier);
    }

    public boolean func_70648_aU() {
        return this.baseStats == null || this.getSpawnLocation() == SpawnLocation.Water || this.baseStats.type1 == EnumType.Water || this.baseStats.type2 == EnumType.Water;
    }

    public void func_70107_b(double x, double y, double z) {
        float scaleFactor;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        float scale = 1.0f;
        float f = scaleFactor = PixelmonConfig.scaleModelsUp ? 1.3f : 1.0f;
        if (this.isInitialised) {
            scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        }
        if (this.baseStats != null) {
            float halfWidth = this.baseStats.width * scale / 2.0f;
            this.func_174826_a(new AxisAlignedBB(x - (double)halfWidth, y, z - (double)halfWidth, x + (double)halfWidth, y + (double)this.baseStats.height * (double)scale + (double)this.baseStats.hoverHeight, z + (double)halfWidth));
        } else {
            float halfWidth = this.field_70130_N * scale / 2.0f;
            this.func_174826_a(new AxisAlignedBB(x - (double)halfWidth, y, z - (double)halfWidth, x + (double)halfWidth, y - this.func_70033_W() + (double)this.field_70131_O * (double)scale, z + (double)halfWidth));
        }
    }

    public int func_70641_bl() {
        return this.field_70146_Z.nextInt(this.baseStats.maxGroupSize - this.baseStats.minGroupSize + 1) + this.baseStats.minGroupSize;
    }

    @Override
    public void func_70071_h_() {
        if (!(this instanceof EntityStatue)) {
            if (!((Entity10CanBreed)this).isInRanchBlock && this.func_70902_q() != null && !this.field_70170_p.field_72995_K) {
                this.friendship.tick();
            }
            if (this.hasOwner() && this.func_70902_q() == null && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.field_70759_as = this.field_70177_z;
        }
        if (this.tickHandler != null) {
            this.tickHandler.tick(this.field_70170_p);
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.getForm() != this.oldForm) {
                this.baseStats = Entity3HasStats.getBaseStats(this.baseStats.pokemon, this.getForm()).get();
                this.oldForm = this.getForm();
            }
            if (!this.oldName.equals(this.getPokemonName())) {
                this.isInitialised = false;
                this.baseStats = Entity3HasStats.getBaseStats(this.getPokemonName()).get();
                this.oldName = this.getPokemonName();
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (!(this instanceof EntityStatue)) {
            if (!this.isMega) {
                this.stats.writeToNBT(nbt);
            }
            this.level.writeToNBT(nbt);
            this.friendship.writeToNBT(nbt);
            nbt.func_74757_a("DoesLevel", this.doesLevel);
            if (this.extraStats != null) {
                this.extraStats.writeToNBT(nbt);
            }
            if (this.ability != null && !this.isMega) {
                String abilityName = this.ability.getName();
                if (abilityName.equals("Coming Soon")) {
                    nbt.func_74778_a("Ability", ((ComingSoon)this.ability).getTrueAbility());
                } else {
                    nbt.func_74778_a("Ability", abilityName);
                }
            }
            if (this.abilitySlot != null) {
                nbt.func_74768_a("AbilitySlot", this.abilitySlot.intValue());
            }
        }
        if (!this.isMega) {
            int form = this.getForm();
            nbt.func_74768_a("Variant", form);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)nbt.func_74762_e("StatsHP"));
        super.func_70037_a(nbt);
        if (!(this instanceof EntityStatue)) {
            block16: {
                this.stats.readFromNBT(nbt);
                this.friendship.readFromNBT(nbt);
                boolean bl = this.doesLevel = !nbt.func_74764_b("DoesLevel") || nbt.func_74767_n("DoesLevel");
                if (this.extraStats != null) {
                    this.extraStats.readFromNBT(nbt);
                }
                try {
                    if (!nbt.func_74764_b("Ability")) break block16;
                    String abilityName = nbt.func_74779_i("Ability");
                    try {
                        this.ability = AbilityBase.getAbility(abilityName).get();
                    }
                    catch (Exception exception) {
                        if (abilityName.equals("ComingSoon")) {
                            if (nbt.func_74764_b("AbilitySlot")) {
                                int tempAbilitySlot = nbt.func_74762_e("AbilitySlot");
                                if (this.baseStats.abilities != null && this.baseStats.abilities[tempAbilitySlot] != null) {
                                    abilityName = this.baseStats.abilities[tempAbilitySlot];
                                    this.setAbility(abilityName);
                                }
                            }
                            break block16;
                        }
                        this.giveAbility();
                    }
                }
                catch (Exception exception) {
                    System.out.println("Didn't have an Ability; giving it one.");
                    this.giveAbility();
                }
            }
            try {
                if (nbt.func_74764_b("AbilitySlot")) {
                    this.abilitySlot = nbt.func_74762_e("AbilitySlot");
                } else {
                    this.giveAbilitySlot();
                }
            }
            catch (Exception exception) {
                System.out.println("Didn't have an Ability slot; giving it one.");
                this.giveAbilitySlot();
            }
            if (nbt.func_74764_b("primaryType")) {
                this.type.clear();
                this.type.add(EnumType.parseOrNull(nbt.func_74765_d("primaryType")));
                if (nbt.func_74764_b("secondaryType") && nbt.func_74765_d("secondaryType") != -1) {
                    this.type.add(EnumType.parseOrNull(nbt.func_74765_d("secondaryType")));
                }
            }
        }
        if (nbt.func_74764_b("Variant")) {
            this.setForm(nbt.func_74762_e("Variant"), false);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.55);
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
        this.stats.getNBTTags(tags);
        this.level.getNBTTags(tags);
        this.friendship.getNBTTags(tags);
        ExtraStats.getNBTTags(tags);
        tags.put("DoesLevel", Boolean.class);
        tags.put("Ability", String.class);
        tags.put("AbilitySlot", Integer.class);
        tags.put("Health", Float.class);
        tags.put("Variant", Integer.class);
    }

    public static BaseStats getBaseStats(int index) {
        Optional<EnumPokemon> pokemon = EnumPokemon.getFromDex(index);
        return pokemon.map(enumPokemon -> Entity3HasStats.getBaseStats(enumPokemon).orElse(null)).orElse(null);
    }

    public static Optional<BaseStats> getBaseStats(String name) {
        return Entity3HasStats.getBaseStats(name, -1);
    }

    public static Optional<BaseStats> getBaseStats(EnumPokemon pokemon) {
        return Entity3HasStats.getBaseStats(pokemon, -1);
    }

    public static Optional<BaseStats> getBaseStats(String name, int form) {
        EnumPokemon pokemon = EnumPokemon.getFromNameAnyCase(name);
        return Entity3HasStats.getBaseStats(pokemon, form);
    }

    public static Optional<BaseStats> getBaseStats(EnumPokemon pokemon, int form) {
        Optional<BaseStats> optional;
        if (pokemon == null) {
            return Optional.empty();
        }
        BaseStats baseStats = Entity3HasStats.getBaseStatsFromStore(pokemon, form);
        BaseStats noForm = null;
        if (baseStats != null) {
            if (baseStats.form == form || form == -1) {
                return Optional.of(baseStats);
            }
            noForm = baseStats;
        }
        if (!(optional = DatabaseStats.getBaseStats(pokemon.name, form)).isPresent()) {
            if (noForm != null) {
                return Optional.of(noForm);
            }
            if (form > -1) {
                optional = DatabaseStats.getBaseStats(pokemon.name);
            }
            return optional;
        }
        baseStats = optional.get();
        if (form == -1 && !baseStatsStore1.containsKey((Object)pokemon)) {
            baseStatsStore1.put(pokemon, baseStats);
        } else {
            String storename = pokemon.name + pokemon.getFormEnum(form).getForm();
            if (!baseStatsFormStore.containsKey(storename)) {
                baseStatsFormStore.put(storename, baseStats);
            }
        }
        return Optional.of(baseStats);
    }

    private static BaseStats getBaseStatsFromStore(EnumPokemon pokemon, int form) {
        return form == -1 ? baseStatsStore1.get((Object)pokemon) : baseStatsFormStore.get(pokemon.name + pokemon.getFormEnum(form).getForm());
    }

    public static boolean hasForms(EnumPokemon pokemon) {
        return pokemon.getNumForms(false) > 0;
    }

    public static boolean hasForms(String name) {
        Optional<EnumPokemon> pokemon = EnumPokemon.getFromName(name);
        return pokemon.isPresent() && Entity3HasStats.hasForms(pokemon.get());
    }

    public static int getNumForms(String name) {
        Optional<EnumPokemon> pokemon = EnumPokemon.getFromName(name);
        return pokemon.map(Entity3HasStats::getNumForms).orElse(0);
    }

    public static int getNumForms(EnumPokemon pokemon) {
        return Entity3HasStats.hasForms(pokemon) ? pokemon.getNumForms(false) : 0;
    }

    public static int getRandomForm(EnumPokemon pokemon) {
        return Entity3HasStats.hasForms(pokemon) ? (pokemon.getFormEnum(0) instanceof EnumForms ? (int)EnumForms.NoForm.getForm() : RandomHelper.rand.nextInt(Entity3HasStats.getNumForms(pokemon))) : -1;
    }

    public static boolean isAvailableGeneration(String name) {
        int dexNumber = Entity3HasStats.getPokedexNumber(name);
        return dexNumber != -1 && Entity3HasStats.isAvailableGeneration(dexNumber);
    }

    public static boolean isAvailableGeneration(EnumPokemon pokemon) {
        return Entity3HasStats.isAvailableGeneration(pokemon.getNationalPokedexInteger());
    }

    public static boolean isAvailableGeneration(int dexNumber) {
        return dexNumber >= 722 && dexNumber <= 807 && PixelmonConfig.Gen7 || (dexNumber <= 151 ? PixelmonConfig.Gen1 : (dexNumber <= 251 ? PixelmonConfig.Gen2 : (dexNumber <= 386 ? PixelmonConfig.Gen3 : (dexNumber <= 493 ? PixelmonConfig.Gen4 : (dexNumber <= 649 ? PixelmonConfig.Gen5 : dexNumber <= 721 && PixelmonConfig.Gen6)))));
    }

    public static Gender getRandomGender(BaseStats baseStats) {
        return baseStats.malePercent < 0 ? Gender.None : (RandomHelper.rand.nextInt(100) < baseStats.malePercent ? Gender.Male : Gender.Female);
    }

    protected static int getRandomNormalAbilitySlot(String[] abilities) {
        return abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0;
    }

    public static int getPokedexNumber(String name) {
        Optional<EnumPokemon> pokemon = EnumPokemon.getFromName(name);
        return pokemon.map(EnumPokemon::getNationalPokedexInteger).orElse(-1);
    }
}

