/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.Transform;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.ParticleEffects;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumForms;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Entity4Textures
extends Entity3HasStats {
    public float maxScale = 1.25f;
    public float hoverTimer;
    private ParticleEffects[] particleEffects;
    private static final String textureFileType = ".png";
    ResourceLocation lastTexture;
    boolean exists = true;
    public String transformedTexture = null;
    public int evolvingVal = 0;
    public int evoAnimTicks = 0;
    public EvolutionStage evoStage = null;
    public int fadeCount = 0;
    private boolean fadeDirection = true;
    public float heightDiff;
    public float widthDiff;
    public float lengthDiff;

    public Entity4Textures(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwTextures, (Object)0);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwCustomTexture, (Object)"");
    }

    @Override
    protected void init(String name) {
        super.init(name);
        if (this.field_70170_p != null) {
            if (!this.field_70170_p.field_72995_K && PixelmonConfig.shinyRate > 0.0f && this.field_70146_Z.nextFloat() < 1.0f / PixelmonConfig.shinyRate) {
                this.setIsShiny(true);
            }
            if (this.field_70170_p.field_72995_K) {
                this.particleEffects = ParticleEffects.getParticleEffects(this);
            }
        }
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (this.baseStats.pokemon == EnumPokemon.Magikarp) {
            this.setSpecialTexture(EnumSpecialTexture.Roasted.id);
            this.update(EnumUpdateType.Texture);
        } else {
            super.func_70077_a(lightningBolt);
        }
    }

    public ResourceLocation getTexture() {
        if (this.transformedTexture != null) {
            return new ResourceLocation(this.transformedTexture);
        }
        ResourceLocation location = this.getRealTexture();
        if (this.lastTexture == null || !this.lastTexture.equals((Object)location)) {
            this.lastTexture = location;
            this.exists = Pixelmon.proxy.resourceLocationExists(location);
        }
        return this.exists ? location : Entity4Textures.getOGTexture(this.getSpecies(), this.getSpecies().getFormEnum(this.getForm()), this.getGender(), this.getIsShiny());
    }

    public ResourceLocation getTextureNoCheck() {
        return this.transformedTexture != null ? new ResourceLocation(this.transformedTexture) : this.getRealTexture();
    }

    public ResourceLocation getRealTexture() {
        EnumPokemon pokemon = this.getSpecies();
        return Entity4Textures.getTextureFor(pokemon, pokemon.getFormEnum(this.getForm()), this.getGender(), this.getSpecialTexture(), this.getIsShiny());
    }

    public String getRealTextureNoCheck() {
        return this.getRealTexture().toString();
    }

    public void transformTexture(String transformedTexture) {
        this.transformedTexture = transformedTexture;
    }

    public boolean getIsShiny() {
        return ((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures) >> 16 & 0xFF) == 1;
    }

    public void setIsShiny(boolean isShiny) {
        int oldValue = (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures);
        boolean isRed = (oldValue >> 8 & 0xFF) == 1;
        int specTex = oldValue & 0xFF;
        int dataValue = this.getIntValue(isShiny, isRed, specTex);
        this.field_70180_af.func_187227_b(EntityPixelmon.dwTextures, (Object)dataValue);
    }

    private int getIntValue(boolean isShiny, boolean isRed, int specTex) {
        int value = isShiny ? 1 : 0;
        value = (value << 8) + (isRed ? 1 : 0);
        value = (value << 8) + specTex;
        return value;
    }

    public boolean getIsRed() {
        return ((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures) >> 8 & 0xFF) == 1;
    }

    public void setIsRed(boolean isRed) {
        int oldValue = (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures);
        boolean isShiny = (oldValue >> 16 & 0xFF) == 1;
        int specTex = oldValue & 0xFF;
        int dataValue = this.getIntValue(isShiny, isRed, specTex);
        this.field_70180_af.func_187227_b(EntityPixelmon.dwTextures, (Object)dataValue);
    }

    public int getSpecialTextureIndex() {
        return (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures) & 0xFF;
    }

    public String getSpecialTexture() {
        EnumSpecialTexture enumm = EnumSpecialTexture.fromIndex(this.getSpecialTextureIndex());
        return enumm == EnumSpecialTexture.None ? (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwCustomTexture) : enumm.toString();
    }

    public void setSpecialTexture(int specTex) {
        int oldValue = (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures);
        boolean isShiny = (oldValue >> 16 & 0xFF) == 1;
        boolean isRed = (oldValue >> 8 & 0xFF) == 1;
        int dataValue = this.getIntValue(isShiny, isRed, specTex);
        this.field_70180_af.func_187227_b(EntityPixelmon.dwTextures, (Object)dataValue);
    }

    @Override
    public void evolve(PokemonSpec evolveTo) {
        super.evolve(evolveTo);
        if (this.getSpecialTextureIndex() == EnumSpecialTexture.Roasted.id) {
            this.setSpecialTexture(EnumSpecialTexture.Zombie.id);
            this.update(EnumUpdateType.Texture);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.particleEffects != null) {
                for (ParticleEffects particleEffect : this.particleEffects) {
                    particleEffect.onUpdate();
                }
            }
            this.tickEvolveAnimation();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("IsShiny", this.getIsShiny());
        nbt.func_74777_a("specialTexture", (short)this.getSpecialTextureIndex());
        if (!((String)this.field_70180_af.func_187225_a(EntityPixelmon.dwCustomTexture)).isEmpty()) {
            nbt.func_74778_a("CustomTexture", (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwCustomTexture));
        } else {
            nbt.func_82580_o("CustomTexture");
        }
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
        tags.put("IsShiny", Boolean.class);
        tags.put("specialTexture", Short.class);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setIsShiny(nbt.func_74767_n("IsShiny"));
        this.setSpecialTexture(nbt.func_74765_d("specialTexture"));
        this.field_70180_af.func_187227_b(EntityPixelmon.dwCustomTexture, (Object)nbt.func_74779_i("CustomTexture"));
    }

    public void transformServer(EnumPokemon transformedModel, int form, String texture) {
        this.transformServer(transformedModel, form);
        this.transformTexture(texture);
        this.updateTransformed();
    }

    @Override
    public void cancelTransform() {
        super.cancelTransform();
        this.transformedTexture = null;
        this.updateTransformed();
    }

    public void updateTransformed() {
        Transform transform = this.transformed ? new Transform(this.func_145782_y(), this.transformedModel, this.transformedTexture, this.transformedForm) : new Transform(this.func_145782_y(), this.baseStats.pokemon, this.getRealTextureNoCheck(), this.getForm());
        Pixelmon.network.sendToAll((IMessage)transform);
    }

    public boolean isEvolving() {
        return this.evoStage != null && this.evoStage != EvolutionStage.End;
    }

    public void setEvolutionAnimationStage(EvolutionStage stage) {
        if (stage == EvolutionStage.End) {
            this.evoStage = null;
            this.func_70105_a(this.baseStats.width, this.baseStats.height + this.baseStats.hoverHeight);
        } else {
            this.evoStage = stage;
            this.evoAnimTicks = 0;
            if (stage == EvolutionStage.PreChoice) {
                this.fadeCount = 20;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickEvolveAnimation() {
        ++this.evoAnimTicks;
        if (this.evoStage != null) {
            ++this.evoAnimTicks;
            if (this.evoStage == EvolutionStage.Choice) {
                if (this.fadeDirection) {
                    ++this.fadeCount;
                    if (this.fadeCount >= 20) {
                        this.fadeDirection = false;
                    }
                } else {
                    --this.fadeCount;
                    if (this.fadeCount <= 0) {
                        this.fadeDirection = true;
                    }
                }
            } else if (this.evoStage == EvolutionStage.PreAnimation) {
                if (this.fadeDirection) {
                    if (this.fadeCount < 20) {
                        ++this.fadeCount;
                    }
                } else if (this.fadeCount > 0 && this.fadeCount <= 0) {
                    this.fadeDirection = true;
                }
            }
            if (this.evoStage == EvolutionStage.Choice || this.evoStage == EvolutionStage.PreAnimation) {
                Random random = this.func_70681_au();
                int numEffects = random.nextInt(10);
                for (int i = 0; i < numEffects; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)((random.nextFloat() * 2.2f - 1.0f) * this.baseStats.width), this.field_70163_u + (double)((random.nextFloat() * 2.2f - 1.0f) * this.baseStats.height), this.field_70161_v + (double)((random.nextFloat() * 2.2f - 1.0f) * this.baseStats.length), 255.0, 255.0, 255.0, new int[0]);
                }
            }
            if (this.evoStage == EvolutionStage.PreAnimation || this.evoStage == EvolutionStage.PostAnimation) {
                if (this.evoStage == EvolutionStage.PreAnimation) {
                    if (this.evoAnimTicks > EvolutionStage.PreAnimation.ticks) {
                        --this.evoAnimTicks;
                    }
                } else {
                    if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks) {
                        --this.evoAnimTicks;
                    }
                    if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks - 21 && this.fadeCount > 0) {
                        --this.fadeCount;
                    }
                }
                int ticks = this.evoAnimTicks;
                if (this.evoStage == EvolutionStage.PostAnimation) {
                    ticks += EvolutionStage.PreAnimation.ticks;
                }
                float length = this.baseStats.length + (float)ticks / 200.0f * this.lengthDiff;
                float height = this.baseStats.height + (float)ticks / 200.0f * this.heightDiff;
                float width = this.baseStats.width + (float)ticks / 200.0f * this.widthDiff;
                Random random = this.func_70681_au();
                int numEffects = random.nextInt(50);
                for (int i = 0; i < numEffects; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)((random.nextFloat() * 2.2f - 1.0f) * width), this.field_70163_u + (double)((random.nextFloat() * 2.2f - 1.0f) * height), this.field_70161_v + (double)((random.nextFloat() * 2.2f - 1.0f) * length), 255.0, 255.0, 255.0, new int[0]);
                }
            }
        }
    }

    @Override
    public void setBoss(EnumBossMode mode) {
        super.setBoss(mode);
        if (this.serverBossMode.isBossPokemon() && this.baseStats.pokemon.hasMega()) {
            int numMegas = EnumMegaPokemon.getMega((EnumPokemon)this.baseStats.pokemon).numMegaForms;
            int form = 1;
            if (numMegas > 1) {
                form = RandomHelper.getRandomNumberBetween(1, numMegas);
            }
            this.isMega = true;
            this.setForm(form);
            this.setIsShiny(mode.extraLevels >= EnumBossMode.Legendary.extraLevels);
        }
    }

    public static ResourceLocation getTextureFor(EnumPokemon pokemon, IEnumForm form, Gender gender, String specialTexture, boolean shiny) {
        String path = "textures/pokemon/";
        String folder = "";
        String prefix = "";
        if (shiny) {
            folder = "pokemon-shiny/";
            prefix = "shiny";
        }
        if (specialTexture != null && !specialTexture.isEmpty()) {
            if (pokemon.hasSpecialTexture() && EnumSpecialTexture.fromName(specialTexture) != EnumSpecialTexture.None) {
                EnumSpecialTexture enumm = EnumSpecialTexture.fromName(specialTexture);
                if (form == EnumForms.NoForm && pokemon.getSpecialTexture() == enumm) {
                    folder = "pokemon-" + enumm.name().toLowerCase() + "/";
                }
            } else {
                folder = "custom-" + specialTexture + "/";
            }
        }
        String mf = EnumPokemon.mfTextured.contains((Object)pokemon) ? (gender == Gender.Male ? "male" : "female") : "";
        return new ResourceLocation("pixelmon", path + folder + prefix + pokemon.name.toLowerCase() + form.getFormSuffix() + mf + textureFileType);
    }

    public static ResourceLocation getOGTexture(EnumPokemon pokemon, IEnumForm form, Gender gender, boolean shiny) {
        String mf = EnumPokemon.mfTextured.contains((Object)pokemon) ? (gender == Gender.Male ? "male" : "female") : "";
        return new ResourceLocation("pixelmon", "textures/pokemon/" + (shiny ? "pokemon-shiny/shiny" : "") + pokemon.name.toLowerCase() + form.getFormSuffix() + mf + textureFileType);
    }
}

