/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.StatusPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity5Rideable;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.EntityLink;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.enums.forms.EnumBurmy;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class Entity6CanBattle
extends Entity5Rideable {
    public StatusPersist status = NoStatus.noStatus;
    private Moveset moveset = new Moveset(this);
    public BattleControllerBase battleController;
    protected NPCTrainer trainer;
    private PixelmonWrapper pixelmonWrapper;
    public boolean hasNPCTrainer;

    public Entity6CanBattle(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwTrainerName, (Object)"");
    }

    @Override
    public boolean func_70692_ba() {
        if (this.battleController != null) {
            return false;
        }
        return super.func_70692_ba();
    }

    public void loadMoveset() {
        this.moveset = Moveset.loadMoveset(new EntityLink(this));
    }

    public void loadMoveset(String ... moves) {
        this.loadMoveset();
        int j = 0;
        for (String move : moves) {
            Attack attack = DatabaseMoves.getAttack(move);
            if (this.moveset.add(attack)) continue;
            this.moveset.set(j++, attack);
        }
    }

    public void setMoveset(Moveset moveset) {
        this.moveset = moveset;
    }

    public Moveset getMoveset() {
        return this.moveset;
    }

    public void StartBattle(BattleParticipant p1, BattleParticipant p2) {
        this.StartBattle(p1, p2, EnumBattleType.Single);
    }

    public void StartBattle(BattleParticipant p1, BattleParticipant p2, EnumBattleType battleType) {
        this.StartBattle(p1, p2, new BattleRules(battleType));
    }

    public void StartBattle(BattleParticipant p1, BattleParticipant p2, BattleRules rules) {
        if (this.moveset.isEmpty()) {
            this.loadMoveset();
        }
        for (BattleParticipant p : new BattleParticipant[]{p1, p2}) {
            if (p.countAblePokemon() > 0) continue;
            return;
        }
        try {
            p1.startedBattle = true;
            this.battleController = new BattleControllerBase(p1, p2, rules);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endBattle() {
        if (this.baseStats.pokemon == EnumPokemon.Burmy) {
            this.setForm(EnumBurmy.getFromType(TerrainExamine.getTerrain(this.pixelmonWrapper)).ordinal());
        }
        this.battleController = null;
        this.pixelmonWrapper = null;
    }

    public void setTrainer(NPCTrainer trainer) {
        this.trainer = trainer;
        this.field_70180_af.func_187227_b(EntityPixelmon.dwTrainerName, (Object)trainer.func_70005_c_());
    }

    public NPCTrainer getTrainer() {
        return this.trainer;
    }

    public String getTrainerName() {
        return (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwTrainerName);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getBossMode() != EnumBossMode.NotBoss && source.field_76373_n.equals("mob") && !(source.func_76364_f() instanceof EntityPixelmon)) {
                return false;
            }
            if (source.field_76373_n.equals("player") || source.field_76373_n.equals("arrow")) {
                if (!PixelmonConfig.canPokemonBeHit) {
                    return false;
                }
                amount *= 3.0f;
            }
            if (!(this.battleController == null && !this.isEvolving() || source != DamageSource.field_76367_g && source != DamageSource.field_76369_e && source != DamageSource.field_76379_h && source != DamageSource.field_76372_a && source != DamageSource.field_76368_d && source != DamageSource.field_76371_c && source != DamageSource.field_76370_b && source != DamageSource.field_82729_p && source != DamageSource.field_82728_o)) {
                return false;
            }
            boolean flag = super.func_70097_a(source, amount);
            if (this.battleController == null) {
                this.updateHealth();
            }
            if (this.func_110143_aJ() <= 0.0f) {
                this.func_70645_a(source);
            }
            Entity entity = source.func_76364_f();
            if (this.battleController == null && this.func_70902_q() != null) {
                this.update(EnumUpdateType.HP);
            }
            if (this.isValidTarget(entity)) {
                this.func_70624_b((EntityLivingBase)((EntityLiving)entity));
            }
            return flag;
        }
        return false;
    }

    public ArrayList<Attack> getAttacksAtLevel(int level) {
        return DatabaseMoves.getAttacksAtLevel(this, level);
    }

    public boolean learnsAttackAtLevel(int level) {
        return DatabaseMoves.learnsAttackAtLevel(this, level);
    }

    protected boolean isValidTarget(Entity entity) {
        return entity instanceof EntityPixelmon;
    }

    public boolean hasStatus() {
        return this.status != NoStatus.noStatus;
    }

    public boolean removeStatus(StatusType s) {
        if (this.status.type == s) {
            EntityLivingBase owner = this.func_70902_q();
            if (owner != null) {
                ChatHandler.sendChat((Entity)owner, this.status.getCureMessage(), this.getNickname());
            }
            this.clearStatus();
            return true;
        }
        return false;
    }

    public boolean removeStatuses(StatusType ... statuses) {
        for (StatusType status : statuses) {
            if (!this.removeStatus(status)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStatus(StatusType ... statuses) {
        for (StatusType status : statuses) {
            if (status != this.status.type) continue;
            return true;
        }
        return false;
    }

    public void clearStatus() {
        this.status = NoStatus.noStatus;
    }

    public void removeStatus(StatusBase e) {
        if (this.status.type == e.type) {
            this.clearStatus();
        }
    }

    public void sendStatusPacket(int statusID) {
        if (this.battleController != null && !this.battleController.simulateMode) {
            int[] pokemonID = this.getPokemonId();
            this.battleController.participants.stream().filter(p -> p.getType() == ParticipantType.Player).forEach(p -> Pixelmon.network.sendTo((IMessage)new StatusPacket(pokemonID, statusID), ((PlayerParticipant)p).player));
            this.battleController.spectators.forEach(spectator -> spectator.sendMessage(new StatusPacket(pokemonID, statusID)));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.moveset.writeToNBT(nbt);
        if (nbt.func_74764_b("StatusCount")) {
            int numStatuses = nbt.func_74765_d("StatusCount");
            for (int i = 0; i < numStatuses; ++i) {
                nbt.func_82580_o("Status" + i);
            }
            nbt.func_82580_o("StatusCount");
        }
        if (this.hasStatus()) {
            this.status.writeToNBT(nbt);
        } else {
            nbt.func_82580_o("Status");
        }
        if (this.trainer != null) {
            nbt.func_74757_a("HasNPCTrainer", true);
        }
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
        this.moveset.getNBTTags(tags);
        tags.put("Status", Integer.class);
        tags.put("StatusSleepTurns", Integer.class);
        tags.put("HasNPCTrainer", Boolean.class);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.moveset.readFromNBT(nbt);
        this.status = StatusPersist.readStatusFromNBT(nbt);
        if (nbt.func_74764_b("HasNPCTrainer")) {
            this.hasNPCTrainer = nbt.func_74767_n("HasNPCTrainer");
        }
    }

    @Override
    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        if (this.battleController != null) {
            this.battleController.updatePokemonHealth((EntityPixelmon)this);
        }
    }

    public BattleParticipant getParticipant() {
        if (this.battleController == null) {
            return null;
        }
        for (BattleParticipant p : this.battleController.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.pokemon != this) continue;
                return p;
            }
        }
        return null;
    }

    public PixelmonWrapper getPixelmonWrapper() {
        if (this.battleController == null) {
            return null;
        }
        if (this.pixelmonWrapper != null && this.pixelmonWrapper.bc != null) {
            return this.pixelmonWrapper;
        }
        for (BattleParticipant bp : this.battleController.participants) {
            if (bp.controlledPokemon == null) continue;
            for (PixelmonWrapper pw : bp.controlledPokemon) {
                if (pw.pokemon != this) continue;
                this.pixelmonWrapper = pw;
                return pw;
            }
        }
        return null;
    }

    public void setPixelmonWrapper(PixelmonWrapper newWrapper) {
        this.pixelmonWrapper = newWrapper;
    }

    public int getPercentMaxHealth(float percent) {
        return Entity6CanBattle.getPercentMaxHealth(percent, this.func_110138_aP());
    }

    public static int getPercentMaxHealth(float percent, float maxHealth) {
        return Math.max(1, (int)(maxHealth * percent / 100.0f));
    }

    public boolean hasFullHealth() {
        return this.func_110143_aJ() >= this.func_110138_aP();
    }

    public void healEntityBy(int i) {
        if ((float)i + this.func_110143_aJ() > this.func_110138_aP()) {
            i = (int)(this.func_110138_aP() - this.func_110143_aJ());
        }
        if (i != 0) {
            this.func_70606_j(this.func_110143_aJ() + (float)i);
        }
    }

    public void healByPercent(float percent) {
        this.healEntityBy(this.getPercentMaxHealth(percent));
    }

    @Override
    public int getPartyPosition() {
        PixelmonWrapper pw;
        int partyPosition = super.getPartyPosition();
        if (partyPosition == -1 && (pw = this.getPixelmonWrapper()) != null) {
            partyPosition = pw.getPartyPosition();
        }
        return partyPosition;
    }
}

