/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.PixelmonInteraction;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Entity8HoldsItems
extends Entity7HasAI {
    public ItemStack heldItem;
    private DropItemHelper dropItemHelper = new DropItemHelper(this);
    private PixelmonInteraction interaction;
    public int numInteractions;
    boolean dropped = false;

    public Entity8HoldsItems(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwNumInteractions, (Object)0);
    }

    @Override
    protected void init(String name) {
        super.init(name);
        this.interaction = PixelmonInteraction.getInteraction(this);
    }

    public int getNumInteractions() {
        return (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwNumInteractions);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.interaction != null && this.interaction.processInteract((EntityPixelmon)this, player, hand, player.func_184586_b(hand))) {
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.interaction != null) {
            this.interaction.tick();
        }
    }

    public void setHeldItem(ItemStack newHeldItem) {
        HeldItemChangedEvent event = new HeldItemChangedEvent(this.func_70902_q(), this.getPokemonId(), Optional.of((EntityPixelmon)this), Optional.empty(), newHeldItem);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.heldItem = event.newHeldItem == null ? ItemStack.field_190927_a : event.newHeldItem;
    }

    public ItemStack func_184614_ca() {
        if (this.heldItem == null) {
            return ItemStack.field_190927_a;
        }
        return this.heldItem;
    }

    public ItemHeld getItemHeld() {
        return ItemHeld.getItemHeld(this.func_184614_ca());
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        ItemHeld.writeHeldItemToNBT(nbt, this.heldItem);
        if (this.interaction != null) {
            this.interaction.writeEntityToNBT(nbt);
        }
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
        tags.put("NumInteractions", Short.class);
        tags.put("InteractionCount", Short.class);
        tags.put("HeldItemName", String.class);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.heldItem = ItemHeld.readHeldItemFromNBT(nbt);
        if (this.interaction != null) {
            this.interaction.readEntityFromNBT(nbt);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        EntityPixelmon pix;
        if (cause.func_76364_f() instanceof EntityPixelmon && this.getBossMode() != EnumBossMode.NotBoss && !this.field_70170_p.field_72995_K) {
            pix = (EntityPixelmon)cause.func_76364_f();
            if (pix.func_70902_q() != null && !this.dropped) {
                this.dropItemHelper.dropBossItems((EntityPlayerMP)pix.func_70902_q());
                this.dropped = true;
            } else if (pix.battleController != null && !this.dropped) {
                pix.battleController.participants.stream().filter(p -> p instanceof PlayerParticipant).forEach(p -> {
                    this.dropItemHelper.dropBossItems(((PlayerParticipant)p).player);
                    this.dropped = true;
                });
            }
        }
        if (cause.func_76364_f() instanceof EntityPixelmon && this.getBossMode() == EnumBossMode.NotBoss && !this.field_70170_p.field_72995_K) {
            pix = (EntityPixelmon)cause.func_76364_f();
            if (pix.func_70902_q() != null && !this.dropped) {
                this.dropItemHelper.dropNormalItems((EntityPlayerMP)pix.func_70902_q());
                this.dropped = true;
            } else if (pix.battleController != null && !this.dropped) {
                pix.battleController.participants.stream().filter(p -> p instanceof PlayerParticipant && p.team != this.getPixelmonWrapper().getParticipant().team).forEach(p -> {
                    this.dropItemHelper.dropNormalItems(((PlayerParticipant)p).player);
                    this.dropped = true;
                });
            }
        }
        super.func_70645_a(cause);
    }

    protected Item func_146068_u() {
        return this.dropItemHelper.getDropItem();
    }
}

