/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonUpdateEvent;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.blocks.spawning.TileEntityPixelmonSpawner;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.AIHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPixelmon
extends Entity10CanBreed {
    public static final DataParameter<String> dwName = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> dwNickname = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> dwPokemonID1 = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwPokemonID2 = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwExp = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> dwTrainerName = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> dwTextures = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> dwCustomTexture = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> dwScale = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwMaxHP = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwBossMode = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwNature = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwGrowth = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwNumInteractions = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwForm = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwGender = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwLevel = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwTransformation = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwSpawnLocation = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> dwNumBreedingLevels = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean playerOwned = false;
    public List<NBTTagCompound> embeddedPokemon = new ArrayList<NBTTagCompound>();
    public int legendaryTicks = -1;
    public int despawnCounter = -1;
    public static int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 15 * TICKSPERSECOND;
    public static int intMaxTicksToDespawn = 180 * TICKSPERSECOND;
    public boolean getTimings = false;
    public long startTime = 0L;
    public static ArrayList<IInteraction> interactionList = new ArrayList();
    int despawnTick = 0;
    public boolean canMove = true;
    public boolean stopRender = false;
    public TileEntityPixelmonSpawner spawner = null;
    public ArrayList<UUID> cameraCapturedPlayers = new ArrayList();

    public EntityPixelmon(World world) {
        super(world);
        if (world != null && world.field_72995_K) {
            EntityPixelmon.func_184227_b((double)PixelmonConfig.renderDistanceWeight);
        }
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(false);
    }

    @Override
    public void init(String name) {
        super.init(name);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.WATER_CREATURE && this.getSpawnLocation() == SpawnLocation.Water) {
            return true;
        }
        return type == EnumCreatureType.CREATURE;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            super.func_70645_a(cause);
            if (this.func_70902_q() != null) {
                if (this.battleController == null) {
                    this.isFainted = true;
                }
                this.func_70606_j(0.0f);
                this.catchInPokeball();
            } else {
                if (cause.func_76346_g() instanceof EntityPlayerMP && PixelmonConfig.canPokemonBeHit) {
                    ArrayList<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
                    for (ItemStack stack : items) {
                        DropItemHelper.dropItemOnGround(this.func_174791_d(), (EntityPlayerMP)cause.func_76346_g(), stack, false, false);
                    }
                }
                this.func_70106_y();
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack;
        if (player instanceof EntityPlayerMP && hand == EnumHand.MAIN_HAND && (itemstack = player.func_184586_b(hand)) != ItemStack.field_190927_a) {
            for (IInteraction i : interactionList) {
                if (!i.processInteract(this, player, hand, itemstack)) continue;
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void catchInPokeball() {
        this.isInBall = true;
        if (this.getFormEnum().isTemporary()) {
            this.setForm(this.getFormEnum().getDefaultFromTemporary().getForm(), true);
        }
        this.unloadEntity();
    }

    public void releaseFromPokeball() {
        Optional<PlayerStorage> optstorage;
        if (this.hasOwner()) {
            this.aggression = EnumAggression.passive;
            if (this.getSpecialTextureIndex() == EnumSpecialTexture.Online.id && (optstorage = this.getStorage()).isPresent()) {
                optstorage.get().getExtraData().checkPokemon(this);
            }
        }
        this.field_70128_L = false;
        try {
            this.field_70170_p.func_72838_d((Entity)this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.isInBall = false;
        if (!this.field_70170_p.field_72995_K && this.hasOwner() && (optstorage = this.getStorage()).isPresent()) {
            optstorage.get().setInWorld(this, true);
        }
    }

    public void clearAttackTarget() {
        this.func_70604_c(null);
        this.func_70624_b(null);
    }

    public boolean func_70601_bi() {
        AxisAlignedBB aabb = this.func_70046_E();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int wDepth = (int)Math.floor(aabb.field_72340_a);
        while ((double)wDepth < Math.ceil(aabb.field_72336_d)) {
            int y = (int)Math.floor(aabb.field_72338_b);
            while ((double)y < Math.ceil(aabb.field_72337_e)) {
                int z = (int)Math.floor(aabb.field_72339_c);
                while ((double)z < Math.ceil(aabb.field_72334_f)) {
                    if (this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(wDepth, y, z)).func_185904_a().func_76220_a()) {
                        return false;
                    }
                    ++z;
                }
                ++y;
            }
            ++wDepth;
        }
        if (this.getSpawnLocation() == SpawnLocation.Water) {
            if (this.getSwimmingParameters() == null) {
                this.baseStats.swimmingParameters = EntityPixelmon.getBaseStats((String)"Magikarp").get().swimmingParameters;
            }
            if ((wDepth = WorldHelper.getWaterDepth(this.func_180425_c(), this.field_70170_p)) > this.getSwimmingParameters().depthRangeStart && wDepth < this.getSwimmingParameters().depthRangeEnd) {
                return true;
            }
            double prevPosY = this.field_70163_u;
            this.field_70163_u -= (double)(this.getSwimmingParameters().depthRangeStart + this.field_70146_Z.nextInt(this.getSwimmingParameters().depthRangeEnd - this.getSwimmingParameters().depthRangeStart));
            wDepth = WorldHelper.getWaterDepth(this.func_180425_c(), this.field_70170_p);
            if (wDepth > this.getSwimmingParameters().depthRangeStart && wDepth < this.getSwimmingParameters().depthRangeEnd) {
                this.field_70163_u = prevPosY;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean embed(EntityPixelmon p) {
        NBTTagCompound nbt = new NBTTagCompound();
        p.func_70014_b(nbt);
        return this.embeddedPokemon.add(nbt);
    }

    public boolean embed(NBTTagCompound p) {
        return this.embeddedPokemon.add(p);
    }

    public void func_110159_bB() {
    }

    @Override
    public boolean func_70692_ba() {
        return this.legendaryTicks <= 0 && super.func_70692_ba();
    }

    public EntityLivingBase func_70902_q() {
        return !this.hasOwner() ? null : super.func_70902_q();
    }

    protected void func_70623_bb() {
        Event.Result result;
        if (this.func_104002_bU()) {
            this.field_70173_aa = 0;
        } else if ((this.entityAge & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.entityAge = 0;
            } else {
                this.func_70106_y();
            }
        } else {
            EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entityplayer != null) {
                double d0 = entityplayer.field_70165_t - this.field_70165_t;
                double d2 = entityplayer.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.func_70106_y();
                }
                if (d3 <= 2000.0) {
                    this.entityAge = 0;
                }
            }
            if (this.entityAge > 600 && this.field_70146_Z.nextInt(500) == 0 && this.func_70692_ba()) {
                this.func_70106_y();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70071_h_() {
        try {
            if (Pixelmon.freeze) {
                return;
            }
            if (Pixelmon.EVENT_BUS.post((Event)new PixelmonUpdateEvent(this, TickEvent.Phase.START))) {
                return;
            }
            if (this.field_70163_u < 0.0 && !this.field_70170_p.field_72995_K) {
                if (this.battleController == null) {
                    this.func_70106_y();
                } else {
                    this.field_70163_u = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                }
            }
            if ((this.hasNPCTrainer || this.trainer != null) && this.battleController == null) {
                this.func_70106_y();
            }
            if (this.canDespawn && !this.field_70170_p.field_72995_K) {
                this.despawnTick = (this.despawnTick + 1) % 60;
                if (this.despawnTick == 0) {
                    if (this.legendaryTicks > 0 || this.battleController != null && this.battleController.containsParticipantType(PlayerParticipant.class) || this.func_70902_q() != null || this.baseStats == null || this.blockOwner != null) {
                        return;
                    }
                    if (this.playersNearby() && this.despawnCounter != 0) {
                        this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
                    } else {
                        if (this.battleController != null) {
                            this.battleController.endBattleWithoutXP();
                        }
                        this.func_70106_y();
                    }
                }
                this.checkForRarityDespawn();
                if (this.legendaryTicks >= 0 && this.battleController == null) {
                    --this.legendaryTicks;
                    if (this.legendaryTicks == 0) {
                        this.func_70106_y();
                    }
                }
            }
            if (this.playerOwned && this.func_70902_q() == null) {
                this.func_70106_y();
            }
            super.func_70071_h_();
            Pixelmon.EVENT_BUS.post((Event)new PixelmonUpdateEvent(this, TickEvent.Phase.END));
        }
        catch (Exception var2) {
            Pixelmon.LOGGER.error("Error in ticking Pixelmon entity.");
            var2.printStackTrace();
        }
    }

    private void checkForRarityDespawn() {
        if (!(this.legendaryTicks > 0 || this.battleController != null && this.battleController.containsParticipantType(PlayerParticipant.class) || this.func_70902_q() != null || this.baseStats == null || this.blockOwner != null)) {
            if (this.despawnCounter > 0) {
                --this.despawnCounter;
            } else if (this.despawnCounter == 0) {
                if (!this.playersNearby()) {
                    if (this.battleController != null) {
                        this.battleController.endBattleWithoutXP();
                    }
                    this.func_70106_y();
                }
            } else {
                this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
            }
        }
    }

    private boolean playersNearby() {
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            double distancex = player.field_70165_t - this.field_70165_t;
            double distancey = player.field_70163_u - this.field_70163_u;
            double distancez = player.field_70161_v - this.field_70161_v;
            double distancesquared = distancex * distancex + distancey * distancey + distancez * distancez;
            if (!(distancesquared < (double)(PixelmonConfig.despawnRadius * PixelmonConfig.despawnRadius))) continue;
            return true;
        }
        return false;
    }

    public boolean func_70039_c(NBTTagCompound par1nbtTagCompound) {
        return !this.field_70128_L && !this.hasOwner() && this.blockOwner == null && (!this.func_70692_ba() || PixelmonConfig.writeEntitiesToWorld) && super.func_70039_c(par1nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.func_70902_q() != null) {
            nbt.func_186854_a("pixelmonOwnerUUID", this.func_184753_b());
        }
        if (this.getSpawnLocation() == null) {
            this.setSpawnLocation(SpawnLocation.Land);
        }
        NBTTagList embeddedP = new NBTTagList();
        for (NBTTagCompound n : this.embeddedPokemon) {
            embeddedP.func_74742_a((NBTBase)n);
        }
        nbt.func_74782_a("embeddedPokemon", (NBTBase)embeddedP);
        nbt.func_74768_a("pixelmonType", this.getSpawnLocation().ordinal());
        if (this.legendaryTicks > 0) {
            nbt.func_74768_a("legendaryTicks", this.legendaryTicks);
            nbt.func_74772_a("legendaryTime", this.field_70170_p.func_82737_E());
        }
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
        tags.put("pixelmonOwnerUUID", String.class);
        tags.put("pixelmonType", Integer.class);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        try {
            super.func_70037_a(nbt);
            if (nbt.func_74764_b("pixelmonOwnerUUID")) {
                this.func_184754_b(nbt.func_186857_a("pixelmonOwnerUUID"));
            }
            if (nbt.func_74764_b("embeddedPokemon")) {
                NBTTagList embeddedP = (NBTTagList)nbt.func_74781_a("embeddedPokemon");
                this.embeddedPokemon = new ArrayList<NBTTagCompound>();
                for (int i = 0; i < embeddedP.func_74745_c(); ++i) {
                    this.embeddedPokemon.add(embeddedP.func_150305_b(i));
                }
            }
            float h = this.func_110143_aJ();
            this.level.readFromNBT(nbt);
            this.func_70606_j(h);
            if (nbt.func_74764_b("pixelmonType")) {
                this.setSpawnLocation(SpawnLocation.getFromIndex(nbt.func_74762_e("pixelmonType")));
            } else if (this.baseStats.spawnLocations[0] == SpawnLocation.Land) {
                this.setSpawnLocation(SpawnLocation.Land);
            } else {
                this.setSpawnLocation(SpawnLocation.Water);
            }
            this.aiHelper = new AIHelper(this.getPokemonName(), this, this.field_70714_bg);
            if (nbt.func_74764_b("legendaryTicks")) {
                this.legendaryTicks = nbt.func_74762_e("legendaryTicks");
                long lastTime = nbt.func_74763_f("legendaryTime");
                this.legendaryTicks = (int)((long)this.legendaryTicks - (this.field_70170_p.func_82737_E() - lastTime));
                if (this.legendaryTicks <= 0) {
                    this.func_70106_y();
                }
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }

    @Override
    public void unloadEntity() {
        super.unloadEntity();
        this.field_70170_p.func_72900_e((Entity)this);
        this.clearAttackTarget();
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    public EnumPokemon[] getPreEvolutions() {
        return this.baseStats.preEvolutions;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.func_70902_q() == player;
    }

    public void startEvolution(Evolution evolution) {
        Optional<PlayerStorage> optstorage = this.getStorage();
        if (optstorage.isPresent()) {
            optstorage.get().guiOpened = true;
            new EvolutionQuery(this, evolution);
        }
    }

    public boolean isLoaded() {
        return this.isLoaded(false);
    }

    public boolean isLoaded(boolean checkChunk) {
        boolean isLoaded = true;
        if (checkChunk) {
            isLoaded = this.field_70170_p.func_175697_a(this.func_180425_c(), 1);
        }
        if (isLoaded) {
            isLoaded = this.field_70170_p.func_73045_a(this.func_145782_y()) != null;
        }
        return isLoaded;
    }

    public <T extends Evolution> ArrayList<T> getEvolutions(Class<T> type) {
        ArrayList<Evolution> evolutions = new ArrayList<Evolution>();
        for (Evolution evo : this.baseStats.evolutions) {
            if (evo == null || !type.isInstance(evo)) continue;
            evolutions.add(evo);
        }
        return evolutions;
    }

    public boolean testTradeEvolution(EnumPokemon with) {
        if (this.isEgg) {
            return false;
        }
        ArrayList<TradeEvolution> tradeEvolutions = this.getEvolutions(TradeEvolution.class);
        for (TradeEvolution tradeEvolution : tradeEvolutions) {
            if (!tradeEvolution.canEvolve(this, with)) continue;
            return tradeEvolution.doEvolution(this);
        }
        return false;
    }

    public boolean testLevelEvolution(int level) {
        ArrayList<LevelingEvolution> levelingEvolutions = this.getEvolutions(LevelingEvolution.class);
        for (LevelingEvolution levelingEvolution : levelingEvolutions) {
            if (!levelingEvolution.canEvolve(this, level)) continue;
            return levelingEvolution.doEvolution(this);
        }
        return false;
    }

    public boolean testInteractEvolution(ItemStack stack) {
        ArrayList<InteractEvolution> interactingEvolutions = this.getEvolutions(InteractEvolution.class);
        for (InteractEvolution interactingEvolution : interactingEvolutions) {
            if (!interactingEvolution.canEvolve(this, stack)) continue;
            return interactingEvolution.doEvolution(this);
        }
        return false;
    }

    public void setSpawnerParent(TileEntityPixelmonSpawner spawner) {
        this.spawner = spawner;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        if (!this.field_70122_E && this.field_70163_u > 64.0) {
            double d3 = this.field_70165_t - x;
            double d4 = this.field_70161_v - z;
            double d5 = d3 * d3 + d4 * d4;
            return this.func_70112_a(d5);
        }
        double d3 = this.field_70165_t - x;
        double d4 = this.field_70163_u - y;
        double d5 = this.field_70161_v - z;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.func_70112_a(d6);
    }

    public void playPixelmonSound() {
        if (this.baseStats.hasSoundForGender(this.gender)) {
            this.func_70642_aH();
        }
    }

    public boolean isPokemon(String ... matches) {
        String[] var2 = matches;
        int var3 = matches.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String match = var2[var4];
            if (!this.getPokemonName().equalsIgnoreCase(match)) continue;
            return true;
        }
        return false;
    }

    public boolean isPokemon(EnumPokemon ... pokemon) {
        EnumPokemon[] var2 = pokemon;
        int var3 = pokemon.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            EnumPokemon p = var2[var4];
            if (this.baseStats.pokemon != p) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getRealNickname() {
        return super.getNickname();
    }
}

