/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.enums.EnumType;

public class DrySkin
extends AbilityBase {
    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (pokemon.bc == null) {
            return;
        }
        Weather weather = pokemon.bc.globalStatusController.getWeather();
        if (weather instanceof Rainy && !pokemon.hasFullHealth()) {
            pokemon.bc.sendToAll("pixelmon.abilities.dryskinrain", pokemon.getNickname());
            pokemon.healByPercent(12.5f);
        }
        if (weather instanceof Sunny && pokemon.isAlive()) {
            pokemon.bc.sendToAll("pixelmon.abilities.dryskinsun", pokemon.getNickname());
            pokemon.doBattleDamage(pokemon, pokemon.getPercentMaxHealth(12.5f), DamageTypeEnum.ABILITY);
        }
    }

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (a.baseAttack.attackType == EnumType.Water) {
            if (pokemon.hasFullHealth()) {
                user.bc.sendToAll("pixelmon.abilities.dryskinnegate", pokemon.getNickname());
            } else {
                int healAmount = pokemon.getPercentMaxHealth(25.0f);
                pokemon.healEntityBy(healAmount);
                user.bc.sendToAll("pixelmon.abilities.dryskinrain", pokemon.getNickname());
                a.moveResult.weightMod -= pokemon.getHealPercent(healAmount);
            }
            return false;
        }
        return true;
    }

    @Override
    public int modifyDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper pokemon, Attack a) {
        if (a.baseAttack.attackType == EnumType.Fire) {
            return (int)((double)damage * 1.25);
        }
        return damage;
    }
}

